/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ComponentArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.RenderKitArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifact;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class JSFConfigDeleteArtifactAction
extends Action {
    private IArtifact artifact;

    public void run() {
        if (this.artifact != null) {
            FacesConfigArtifactEdit fcArtifactEdit = null;
            try {
                fcArtifactEdit = JsfUiUtil.getFacesConfigArtifactEdit(this.artifact, 1);
                if (fcArtifactEdit != null) {
                    MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 196);
                    msgBox.setText(Messages.JSFConfigDeleteArtifactAction_confirmDialog_title);
                    msgBox.setMessage(Messages.JSFConfigDeleteArtifactAction_confirmDialog_message);
                    if (msgBox.open() == 64) {
                        ValidatorType validator;
                        if (this.artifact instanceof NavigationRuleArtifact) {
                            NavigationRuleType navRule = JsfUiUtil.getNavigationRule(fcArtifactEdit, this.artifact);
                            if (navRule != null) {
                                fcArtifactEdit.getFacesConfig().getNavigationRule().remove((Object)navRule);
                            }
                        } else if (this.artifact instanceof NavigationCaseArtifact) {
                            NavigationRuleType navRule;
                            NavigationCaseType navCase = JsfUiUtil.getNavigationCase(fcArtifactEdit, this.artifact);
                            if (navCase != null && (navRule = JsfUiUtil.getNavigationRule(fcArtifactEdit, this.artifact.getOwner())) != null) {
                                navRule.getNavigationCase().remove((Object)navCase);
                            }
                        } else if (this.artifact instanceof ManagedBeanArtifact) {
                            ManagedBeanType managedBean = JsfUiUtil.getManagedBean(fcArtifactEdit, this.artifact);
                            if (managedBean != null) {
                                fcArtifactEdit.getFacesConfig().getManagedBean().remove((Object)managedBean);
                            }
                        } else if (this.artifact instanceof ComponentArtifact) {
                            ComponentType component = JsfUiUtil.getComponent(fcArtifactEdit, this.artifact);
                            if (component != null) {
                                fcArtifactEdit.getFacesConfig().getComponent().remove((Object)component);
                            }
                        } else if (this.artifact instanceof ConverterArtifact) {
                            ConverterType converter = JsfUiUtil.getConverter(fcArtifactEdit, this.artifact);
                            if (converter != null) {
                                fcArtifactEdit.getFacesConfig().getConverter().remove((Object)converter);
                            }
                        } else if (this.artifact instanceof ReferencedBeanArtifact) {
                            ReferencedBeanType referencedBean = JsfUiUtil.getReferencedBean(fcArtifactEdit, this.artifact);
                            if (referencedBean != null) {
                                fcArtifactEdit.getFacesConfig().getReferencedBean().remove((Object)referencedBean);
                            }
                        } else if (this.artifact instanceof RenderKitArtifact) {
                            RenderKitType renderKit = JsfUiUtil.getRenderKit(fcArtifactEdit, this.artifact);
                            if (renderKit != null) {
                                fcArtifactEdit.getFacesConfig().getRenderKit().remove((Object)renderKit);
                            }
                        } else if (this.artifact instanceof ValidatorArtifact && (validator = JsfUiUtil.getValidator(fcArtifactEdit, this.artifact)) != null) {
                            fcArtifactEdit.getFacesConfig().getValidator().remove((Object)validator);
                        }
                        JsfUiUtil.save(fcArtifactEdit);
                    }
                }
            }
            finally {
                if (fcArtifactEdit != null) {
                    fcArtifactEdit.dispose();
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        TreeSelection treeSelection;
        TreePath[] treePaths;
        boolean setEnabled = false;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0) {
            NavigationRuleArtifact navRuleArtifact = null;
            NavigationCaseArtifact navCaseArtifact = null;
            int i = 0;
            while (i < treePaths[0].getSegmentCount()) {
                Object segment = treePaths[0].getSegment(i);
                if (segment instanceof NavigationRuleArtifact) {
                    navRuleArtifact = (NavigationRuleArtifact)segment;
                } else if (segment instanceof NavigationCaseArtifact) {
                    navCaseArtifact = (NavigationCaseArtifact)segment;
                } else if (segment instanceof ManagedBeanArtifact) {
                    this.artifact = (ManagedBeanArtifact)segment;
                } else if (segment instanceof ComponentArtifact) {
                    this.artifact = (ComponentArtifact)segment;
                } else if (segment instanceof ConverterArtifact) {
                    this.artifact = (ConverterArtifact)segment;
                } else if (segment instanceof ReferencedBeanArtifact) {
                    this.artifact = (ReferencedBeanArtifact)segment;
                } else if (segment instanceof RenderKitArtifact) {
                    this.artifact = (RenderKitArtifact)segment;
                } else if (segment instanceof ValidatorArtifact) {
                    this.artifact = (ValidatorArtifact)segment;
                }
                ++i;
            }
            if (navCaseArtifact != null) {
                this.artifact = navCaseArtifact;
            } else if (navRuleArtifact != null) {
                this.artifact = navRuleArtifact;
            }
            if (this.artifact != null) {
                setEnabled = true;
            }
        }
        this.setEnabled(setEnabled);
    }
}

