/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.config.JSFConfigAddNavigationCaseDialog;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class JSFConfigAddNavigationRuleDialog
extends SelectionStatusDialog {
    private static IStatus STATUS_OK = new Status(0, "oracle.eclipse.tools.webtier.ui", " ");
    private static IStatus STATUS_EXISTING_FROMVIEWID = new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.JSFConfigAddNavigationRuleDialog_status_duplicateFromViewId);
    private static IStatus STATUS_EXISTING_DEFAULTFROMVIEWID = new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.JSFConfigAddNavigationRuleDialog_status_duplicateDefaultFromViewId);
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.AddNavigationRuleDialog";
    private IProject iProject;
    private NavigationRuleType navigationRule;
    private List<String> existingFromViewIDs;
    private Text srcPageText;
    private Text descText;
    private TableViewer navCaseTableViewer;
    private ToolItem editNavCaseButton;
    private ToolItem deleteNavCaseButton;
    private DataBindingContext dataBindContext;
    private Binding srcPageBinding;
    private Binding descBinding;

    public JSFConfigAddNavigationRuleDialog(Shell parent, IProject iProject, NavigationRuleType navigationRule) {
        super(parent);
        this.iProject = iProject;
        this.navigationRule = navigationRule;
        this.setTitle(Messages.JSFConfigAddNavigationRuleDialog_title);
        this.getExistingFromViewIDs();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 14;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 14;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
        }
        Composite localParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        localParent.setLayout((Layout)gridLayout);
        localParent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label srcPageLabel = new Label(localParent, 0);
        srcPageLabel.setText(Messages.JSFConfigAddNavigationRuleDialog_srcPageLabel);
        this.srcPageText = new Text(localParent, 2052);
        GridData srcPageTextGridData = new GridData(4, 0x1000000, true, false);
        srcPageTextGridData.minimumWidth = 265;
        this.srcPageText.setLayoutData((Object)srcPageTextGridData);
        this.srcPageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                String srcPage = JSFConfigAddNavigationRuleDialog.this.srcPageText.getText();
                if (JSFConfigAddNavigationRuleDialog.this.existingFromViewIDs.contains(srcPage)) {
                    if (srcPage.length() > 0) {
                        JSFConfigAddNavigationRuleDialog.this.updateStatus(STATUS_EXISTING_FROMVIEWID);
                    } else {
                        JSFConfigAddNavigationRuleDialog.this.updateStatus(STATUS_EXISTING_DEFAULTFROMVIEWID);
                    }
                } else {
                    JSFConfigAddNavigationRuleDialog.this.updateStatus(STATUS_OK);
                }
            }
        });
        ToolBar srcPageButtonToolBar = this.getToolBar(localParent, 256);
        ToolItem selectPageButton = new ToolItem(srcPageButtonToolBar, 8);
        selectPageButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectPageButton.setToolTipText(Messages.JSFConfigAddNavigationRuleDialog_selectPageButton_tooltip);
        selectPageButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationRuleDialog.this.handleSelectPageButtonSelected();
            }
        });
        Label descLabel = new Label(localParent, 0);
        descLabel.setText(Messages.JSFConfigAddNavigationRuleDialog_descLabel);
        GridData descLabelGridData = new GridData(4, 1, false, false);
        descLabel.setLayoutData((Object)descLabelGridData);
        this.descText = new Text(localParent, 2626);
        GridData descTextGridData = new GridData(4, 1, true, false);
        descTextGridData.heightHint = 40;
        descTextGridData.minimumWidth = 265;
        this.descText.setLayoutData((Object)descTextGridData);
        this.getEmptyComposite(localParent);
        Label navCaseLabel = new Label(localParent, 0);
        navCaseLabel.setText(Messages.JSFConfigAddNavigationRuleDialog_navCaseLabel);
        GridData navCaseLabelGridData = new GridData(16384, 128, false, false);
        navCaseLabel.setLayoutData((Object)navCaseLabelGridData);
        Table table = new Table(localParent, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationRuleDialog.this.enableNavCaseButtons();
            }
        });
        TableColumn column0 = new TableColumn(table, 16384, 0);
        column0.setText(Messages.JSFConfigAddNavigationRuleDialog_column0_label);
        column0.setWidth(120);
        TableColumn column1 = new TableColumn(table, 16384, 1);
        column1.setText(Messages.JSFConfigAddNavigationRuleDialog_column1_label);
        column1.setWidth(125);
        this.navCaseTableViewer = new TableViewer(table);
        this.navCaseTableViewer.setContentProvider((IContentProvider)new NavigationCaseContentProvider());
        TableViewerColumn tableViewerColumn0 = new TableViewerColumn(this.navCaseTableViewer, column0);
        tableViewerColumn0.setLabelProvider((CellLabelProvider)new NavigationCaseOutcomeLabelProvider());
        TableViewerColumn tableViewerColumn1 = new TableViewerColumn(this.navCaseTableViewer, column1);
        tableViewerColumn1.setLabelProvider((CellLabelProvider)new NavigationCaseDestPageLabelProvider());
        this.navCaseTableViewer.setSorter(new ViewerSorter());
        this.navCaseTableViewer.setInput((Object)this.navigationRule.getNavigationCase());
        GridData navCaseTableViewerGridData = new GridData();
        navCaseTableViewerGridData.grabExcessHorizontalSpace = true;
        navCaseTableViewerGridData.grabExcessVerticalSpace = true;
        navCaseTableViewerGridData.horizontalAlignment = 4;
        navCaseTableViewerGridData.verticalAlignment = 4;
        navCaseTableViewerGridData.minimumHeight = 160;
        navCaseTableViewerGridData.minimumWidth = 265;
        this.navCaseTableViewer.getControl().setLayoutData((Object)navCaseTableViewerGridData);
        ToolBar navCaseButtonToolBar = this.getToolBar(localParent, 512);
        ToolItem newNavCaseButton = new ToolItem(navCaseButtonToolBar, 8);
        newNavCaseButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_ADD));
        newNavCaseButton.setToolTipText(Messages.JSFConfigAddNavigationRuleDialog_newNavCaseButton_tooltip);
        newNavCaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationRuleDialog.this.handleNewNavCaseButtonSelected();
            }
        });
        this.editNavCaseButton = new ToolItem(navCaseButtonToolBar, 8);
        this.editNavCaseButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_EDIT));
        this.editNavCaseButton.setToolTipText(Messages.JSFConfigAddNavigationRuleDialog_editNavCaseButton_tooltip);
        this.editNavCaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationRuleDialog.this.handleEditNavCaseButtonSelected();
            }
        });
        this.deleteNavCaseButton = new ToolItem(navCaseButtonToolBar, 8);
        this.deleteNavCaseButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DELETE));
        this.deleteNavCaseButton.setToolTipText(Messages.JSFConfigAddNavigationRuleDialog_deleteNavCaseButton_tooltip);
        this.deleteNavCaseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationRuleDialog.this.handleDeleteNavCaseButtonSelected();
            }
        });
        this.enableNavCaseButtons();
        this.dataBindContext = new DataBindingContext();
        this.bindData();
        this.setStatusLineAboveButtons(true);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    private ToolBar getToolBar(Composite parent, int style) {
        ToolBar toolBar = new ToolBar(parent, 0x800000 | style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        toolBar.setLayout((Layout)gridLayout);
        int alignStyle = 0x1000000;
        if ((style | 0x200) == 512) {
            alignStyle = 1;
        }
        GridData gridData = new GridData(alignStyle, alignStyle, false, false);
        toolBar.setLayoutData((Object)gridData);
        return toolBar;
    }

    private Composite getEmptyComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void handleSelectPageButtonSelected() {
        String JSFFile = JsfUiUtil.selectJSFFileFromDialog(this.iProject);
        if (JSFFile != null) {
            this.srcPageText.setText(JSFFile);
        }
    }

    private void handleNewNavCaseButtonSelected() {
        NavigationCaseType navigationCase = JSFConfigAddNavigationRuleDialog.createNavigationCase();
        this.srcPageBinding.updateTargetToModel();
        int dialogReturn = new JSFConfigAddNavigationCaseDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.iProject, navigationCase, this.navigationRule).open();
        if (dialogReturn == 0) {
            this.navigationRule.getNavigationCase().add((Object)navigationCase);
            this.navCaseTableViewer.refresh();
        }
    }

    private void handleEditNavCaseButtonSelected() {
        Object element;
        ISelection iSelection = this.navCaseTableViewer.getSelection();
        if (iSelection instanceof StructuredSelection && (element = ((StructuredSelection)iSelection).getFirstElement()) instanceof NavigationCaseType) {
            int dialogReturn;
            String fromOutcome;
            NavigationCaseType editNavCase = JSFConfigAddNavigationRuleDialog.createNavigationCase();
            this.copyNavigationCase((NavigationCaseType)element, editNavCase);
            ArrayList<String> allowableExistingFromOutcomes = null;
            FromOutcomeType fromOutcomeType = editNavCase.getFromOutcome();
            if (fromOutcomeType != null && (fromOutcome = fromOutcomeType.getTextContent()) != null) {
                allowableExistingFromOutcomes = new ArrayList<String>();
                allowableExistingFromOutcomes.add(fromOutcome);
            }
            if ((dialogReturn = new JSFConfigAddNavigationCaseDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.iProject, editNavCase, this.navigationRule, allowableExistingFromOutcomes).open()) == 0) {
                this.copyNavigationCase(editNavCase, (NavigationCaseType)element);
                this.navCaseTableViewer.refresh();
            }
        }
    }

    private void handleDeleteNavCaseButtonSelected() {
        Object element;
        ISelection iSelection = this.navCaseTableViewer.getSelection();
        if (iSelection instanceof StructuredSelection && (element = ((StructuredSelection)iSelection).getFirstElement()) instanceof NavigationCaseType) {
            this.navigationRule.getNavigationCase().remove(element);
            this.navCaseTableViewer.refresh();
            this.enableNavCaseButtons();
        }
    }

    public static NavigationCaseType createNavigationCase() {
        NavigationCaseType navigationCase = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
        FromOutcomeType fromOutcome = FacesConfigFactory.eINSTANCE.createFromOutcomeType();
        navigationCase.setFromOutcome(fromOutcome);
        ToViewIdType toViewId = FacesConfigFactory.eINSTANCE.createToViewIdType();
        navigationCase.setToViewId(toViewId);
        DescriptionType description = FacesConfigFactory.eINSTANCE.createDescriptionType();
        navigationCase.getDescription().add((Object)description);
        return navigationCase;
    }

    private void copyNavigationCase(NavigationCaseType source, NavigationCaseType target) {
        FromOutcomeType fromOutcome = source.getFromOutcome();
        if (fromOutcome != null) {
            String content = fromOutcome.getTextContent();
            if (target.getFromOutcome() == null) {
                target.setFromOutcome(FacesConfigFactory.eINSTANCE.createFromOutcomeType());
            }
            target.getFromOutcome().setTextContent(content);
        } else {
            target.setFromOutcome(null);
        }
        ToViewIdType toViewId = source.getToViewId();
        if (toViewId != null) {
            String content = toViewId.getTextContent();
            if (target.getToViewId() == null) {
                target.setToViewId(FacesConfigFactory.eINSTANCE.createToViewIdType());
            }
            target.getToViewId().setTextContent(content);
        } else {
            target.setToViewId(null);
        }
        if (!source.getDescription().isEmpty()) {
            DescriptionType description = (DescriptionType)source.getDescription().get(0);
            String content = description.getTextContent();
            if (target.getDescription().isEmpty()) {
                target.getDescription().add((Object)FacesConfigFactory.eINSTANCE.createDescriptionType());
            }
            ((DescriptionType)target.getDescription().get(0)).setTextContent(content);
        } else if (!target.getDescription().isEmpty()) {
            target.getDescription().clear();
        }
    }

    private void enableNavCaseButtons() {
        boolean enable = false;
        ISelection iSelection = this.navCaseTableViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            enable = true;
        }
        this.editNavCaseButton.setEnabled(enable);
        this.deleteNavCaseButton.setEnabled(enable);
    }

    private void bindData() {
        FromViewIdType eObject = this.navigationRule.getFromViewId();
        EAttribute eStructuralFeature = FacesConfigPackage.eINSTANCE.getFromViewIdType_TextContent();
        this.srcPageBinding = this.dataBindContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.srcPageText), EMFObservables.observeValue((EObject)eObject, (EStructuralFeature)eStructuralFeature), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.srcPageBinding.updateModelToTarget();
        eObject = (DescriptionType)this.navigationRule.getDescription().get(0);
        eStructuralFeature = FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent();
        this.descBinding = this.dataBindContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.descText), EMFObservables.observeValue((EObject)eObject, (EStructuralFeature)eStructuralFeature), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.descBinding.updateModelToTarget();
    }

    protected void computeResult() {
        this.srcPageBinding.updateTargetToModel();
        this.descBinding.updateTargetToModel();
    }

    private void getExistingFromViewIDs() {
        IJSFAppConfigManager appConfigManager;
        this.existingFromViewIDs = new ArrayList<String>();
        if (this.iProject != null && (appConfigManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.iProject)) != null) {
            List navRules = appConfigManager.getNavigationRules();
            for (NavigationRuleType navRuleType : navRules) {
                FromViewIdType fromViewIdType = navRuleType.getFromViewId();
                if (fromViewIdType != null) {
                    String fromViewId = fromViewIdType.getTextContent();
                    if (fromViewId == null) continue;
                    this.existingFromViewIDs.add(fromViewId);
                    continue;
                }
                this.existingFromViewIDs.add("");
            }
        }
    }

    private static class NavigationCaseContentProvider
    implements IStructuredContentProvider {
        private NavigationCaseContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class NavigationCaseDestPageLabelProvider
    extends CellLabelProvider {
        private NavigationCaseDestPageLabelProvider() {
        }

        public void update(ViewerCell cell) {
            ToViewIdType toViewId;
            Object element;
            if (cell != null && (element = cell.getElement()) instanceof NavigationCaseType && (toViewId = ((NavigationCaseType)element).getToViewId()) != null) {
                cell.setText(toViewId.getTextContent());
            }
        }
    }

    private static class NavigationCaseOutcomeLabelProvider
    extends CellLabelProvider {
        private NavigationCaseOutcomeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            FromOutcomeType fromOutcome;
            Object element;
            if (cell != null && (element = cell.getElement()) instanceof NavigationCaseType && (fromOutcome = ((NavigationCaseType)element).getFromOutcome()) != null) {
                cell.setText(fromOutcome.getTextContent());
            }
        }
    }
}

