/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import oracle.eclipse.tools.webtier.jsf.ui.config.JSFConfigAddNavigationRuleDialog;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.PlatformUI;

public class JSFConfigAddNavigationRuleAction
extends Action {
    private IProject iProject;

    public void run() {
        if (this.iProject != null) {
            String configFile;
            try {
                configFile = JsfUiUtil.getFacesConfigFile(this.iProject, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            if (configFile != null) {
                FacesConfigArtifactEdit fcArtifactEdit = null;
                try {
                    FacesConfigType facesConfig;
                    fcArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.iProject, (String)configFile);
                    if (fcArtifactEdit != null && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
                        NavigationRuleType navigationRule = this.constructNewNavigationRule();
                        int dialogReturn = new JSFConfigAddNavigationRuleDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.iProject, navigationRule).open();
                        if (dialogReturn == 0 && this.sanitizeNavigationRule(navigationRule)) {
                            facesConfig.getNavigationRule().add((Object)navigationRule);
                            JsfUiUtil.save(fcArtifactEdit);
                        }
                    }
                }
                finally {
                    if (fcArtifactEdit != null) {
                        fcArtifactEdit.dispose();
                    }
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        Object firstSegment;
        TreeSelection treeSelection;
        TreePath[] treePaths;
        boolean setEnabled = false;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0 && (firstSegment = treePaths[0].getFirstSegment()) instanceof IProject) {
            this.iProject = (IProject)firstSegment;
            setEnabled = true;
        }
        this.setEnabled(setEnabled);
    }

    private NavigationRuleType constructNewNavigationRule() {
        NavigationRuleType navRule = FacesConfigFactory.eINSTANCE.createNavigationRuleType();
        FromViewIdType fromViewId = FacesConfigFactory.eINSTANCE.createFromViewIdType();
        navRule.setFromViewId(fromViewId);
        DescriptionType description = FacesConfigFactory.eINSTANCE.createDescriptionType();
        navRule.getDescription().add((Object)description);
        return navRule;
    }

    private boolean sanitizeNavigationRule(NavigationRuleType navigationRule) {
        boolean isStillValid = false;
        if (navigationRule != null) {
            EList navigationCaseTypes;
            DescriptionType descriptionType;
            EList descriptionTypes;
            FromViewIdType fromViewIdType = navigationRule.getFromViewId();
            if (fromViewIdType != null) {
                String fromViewId = fromViewIdType.getTextContent();
                if (fromViewId == null || fromViewId.trim().isEmpty()) {
                    navigationRule.setFromViewId(null);
                } else {
                    isStillValid = true;
                }
            }
            if ((descriptionTypes = navigationRule.getDescription()) != null && !descriptionTypes.isEmpty() && (descriptionType = (DescriptionType)descriptionTypes.get(0)) != null) {
                String description = descriptionType.getTextContent();
                if (description == null || description.trim().isEmpty()) {
                    descriptionTypes.remove(descriptionType);
                } else {
                    isStillValid = true;
                }
            }
            if ((navigationCaseTypes = navigationRule.getNavigationCase()) != null && !navigationCaseTypes.isEmpty()) {
                isStillValid = true;
            }
        }
        return isStillValid;
    }
}

