/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DataControlContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectPaletteContributor;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.datacontrols.DataControlObjectPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.DesignPaletteEntry;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteContributor;
import oracle.eclipse.tools.webtier.ui.palette.model.PaletteTree;
import oracle.eclipse.tools.webtier.ui.palette.model.TreeModelAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

class DataControlObjectModelAdapter
extends TreeModelAdapter {
    private IDataControlProvider provider;
    private DataControlContentProvider contentProvider;
    private LocalPaletteTreeFilter filter;
    private Set<? extends IDataControlObject> filteredObjects;

    public DataControlObjectModelAdapter(IDataControlProvider provider) {
        super((ILabelProvider)new DescribableLabelProvider());
        this.provider = provider;
    }

    public void dispose() {
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        if (this.filteredObjects != null) {
            this.filteredObjects.clear();
            this.filteredObjects = null;
        }
        this.filter = null;
        this.provider = null;
    }

    private IDataControlObject getDataControlObject(Object model) {
        IDataControlObject dataControlObject;
        if (model instanceof DataControlObjectPaletteEntry && DTRTObjectUtil.isAccessible((IObject)(dataControlObject = ((DataControlObjectPaletteEntry)((Object)model)).getDataControlObject()))) {
            return dataControlObject;
        }
        return null;
    }

    private DataControlContentProvider getContentProvider() {
        return this.contentProvider == null ? (this.contentProvider = new DataControlContentProvider()) : this.contentProvider;
    }

    protected boolean isReadonly(Object model) {
        return false;
    }

    public IDataControlProvider getRoot() {
        return this.provider;
    }

    protected String getLabel(Object model) {
        return this.getLabelProvider().getText((Object)this.getDataControlObject(model));
    }

    protected Image getImage(Object model) {
        return this.getLabelProvider().getImage((Object)this.getDataControlObject(model));
    }

    protected String getToolTipText(Object model) {
        return ((DescribableLabelProvider)this.getLabelProvider()).getToolTipText((Object)this.getDataControlObject(model));
    }

    protected List<DesignPaletteEntry> getChildren(Object model) {
        PaletteContributor paletteContributor;
        IDataControlObject[] dataControlObjects;
        IDataControlObject dataControlObject = this.getDataControlObject(model);
        if (dataControlObject != null) {
            dataControlObjects = this.getContentProvider().hasChildren((Object)dataControlObject) ? this.getContentProvider().getChildren((Object)dataControlObject) : null;
            paletteContributor = ((DesignPaletteEntry)model).getPaletteContributor();
        } else if (model instanceof PaletteTree) {
            paletteContributor = ((PaletteTree)model).getPaletteContributor();
            IDataControlObject[] dcs = this.getContentProvider().getElements((Object)this.provider);
            if (dcs.length > 0) {
                ArrayList<IDataControlObject> list = new ArrayList<IDataControlObject>(dcs.length);
                int i = 0;
                while (i < dcs.length) {
                    if (dcs[i].getStructureObject() != null) {
                        list.add(dcs[i]);
                    }
                    ++i;
                }
                dataControlObjects = list.toArray(new IDataControlObject[list.size()]);
            } else {
                dataControlObjects = dcs;
            }
            if (dataControlObjects.length > 0 && this.getPaletteTreeFilter().shouldFilter()) {
                try {
                    this.filteredObjects = DTRTObjectUtil.findByLabel(Arrays.asList(dataControlObjects), null, (String)this.getPaletteTreeFilter().getFilterString(), null);
                }
                catch (Exception exception) {}
            }
        } else {
            dataControlObjects = null;
            paletteContributor = null;
        }
        if (dataControlObjects != null && dataControlObjects.length > 0) {
            assert (paletteContributor != null);
            if (this.filteredObjects != null) {
                if (this.filteredObjects.isEmpty()) {
                    dataControlObjects = new IDataControlObject[]{};
                } else {
                    ArrayList<IDataControlObject> objects = new ArrayList<IDataControlObject>(Math.min(this.filteredObjects.size(), dataControlObjects.length));
                    IDataControlObject[] iDataControlObjectArray = dataControlObjects;
                    int n = dataControlObjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDataControlObject object = iDataControlObjectArray[n2];
                        if (this.filteredObjects.contains(object)) {
                            objects.add(object);
                        }
                        ++n2;
                    }
                    dataControlObjects = objects.toArray(new IDataControlObject[objects.size()]);
                }
            }
            if (dataControlObjects.length > 0) {
                Arrays.sort(dataControlObjects, DTRTUtil.COMPARATOR);
                ArrayList<DesignPaletteEntry> entries = new ArrayList<DesignPaletteEntry>(dataControlObjects.length);
                int i = 0;
                while (i < dataControlObjects.length) {
                    dataControlObject = dataControlObjects[i];
                    entries.add(new DataControlObjectPaletteEntry((DataControlObjectPaletteContributor)paletteContributor, dataControlObject));
                    ++i;
                }
                return entries;
            }
        }
        return Collections.emptyList();
    }

    public LocalPaletteTreeFilter getPaletteTreeFilter() {
        return this.filter == null ? (this.filter = new LocalPaletteTreeFilter()) : this.filter;
    }

    private class LocalPaletteTreeFilter
    extends TreeModelAdapter.PaletteTreeFilter {
        private String filterString;

        public LocalPaletteTreeFilter() {
            super(DataControlObjectModelAdapter.this.getLabelProvider(), (ITreeContentProvider)DataControlObjectModelAdapter.this.getContentProvider());
        }

        public void setFilterString(String filterString) {
            if (DataControlObjectModelAdapter.this.filteredObjects != null) {
                DataControlObjectModelAdapter.this.filteredObjects.clear();
                DataControlObjectModelAdapter.this.filteredObjects = null;
            }
            this.filterString = filterString;
            super.setFilterString(filterString);
        }

        public String getFilterString() {
            return this.filterString;
        }

        public List<Object> filter(Object parent, List<Object> children, int level) {
            return children;
        }
    }
}

