/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe.dtrt;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.command.IBindCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IWidget;
import oracle.eclipse.tools.adf.dtrt.ui.command.UIProviderImpl;
import oracle.eclipse.tools.adf.dtrt.ui.context.manager.EMFDataBindingCommand;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ObjectContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.wpe.DropPopupMenu;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.WebPageContextManager;
import oracle.eclipse.tools.webtier.ui.tagdrop.ItemOverridingDropCustomizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public abstract class BaseDropCustomizer<O extends IDropSourceData>
extends ItemOverridingDropCustomizer {
    private final O dropSourceData;

    public BaseDropCustomizer(O dropSourceData) {
        assert (dropSourceData != null);
        this.dropSourceData = dropSourceData;
    }

    protected final ItemOverridingDropCustomizer.CustomizationAdapter getCustomizationAdapter() {
        return null;
    }

    protected final O getDropSourceData() {
        return this.dropSourceData;
    }

    protected abstract List<? extends IWidget> getCreateWidgets(IWebPageContext var1, IWebPageContext.IBindPosition var2);

    protected IStatus doValidate(IWebPageContext context, IWorkbenchPart part, IDOMPosition position) {
        return Status.OK_STATUS;
    }

    protected final IStatus doCustomization(IFile file, IDOMPosition position) {
        Node containerNode = position.getContainerNode();
        if (!(containerNode instanceof IDOMNode)) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", "Invalid DOMPostion.");
        }
        HTMLEditor part = DTRTViewUIUtil.findOpenEditor(file);
        if (part == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", "Model not associated with a workbench part.");
        }
        IWebPageContext context = (IWebPageContext)WebPageContextManager.getInstance().getContext((IWorkbenchPart)part);
        if (context == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", "Unable to locate context.");
        }
        try {
            return this.doCustomization(context, (IWorkbenchPart)part, position);
        }
        catch (Exception e) {
            DTRTViewUIUtil.log(e);
            return DTRTUtil.createErrorStatus((String)"An error has occurred while performing the operation", (Throwable)e);
        }
    }

    private IStatus doCustomization(IWebPageContext context, IWorkbenchPart part, IDOMPosition position) throws Exception {
        Node node = position.getContainerNode();
        if (!(node instanceof IDOMNode)) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", "Unknown insertion position");
        }
        IStatus validationStatus = this.doValidate(context, part, position);
        if (!validationStatus.isOK()) {
            return validationStatus;
        }
        List<IWidget> widgets = this.getCreateWidgets(context, DTRTViewUIUtil.createBindPosition(position));
        if (widgets.isEmpty()) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", "The dropped object cannot be represented by any widget");
        }
        return this.execute(context, widgets, part, node);
    }

    protected IStatus execute(IWebPageContext context, List<? extends IWidget> widgets, IWorkbenchPart part, Node node) {
        IWidget widget = widgets.size() == 1 ? widgets.get(0) : this.selectWidget(widgets);
        return this.execute(context, widget, part, node);
    }

    protected final IStatus execute(IWebPageContext context, IWidget widget, IWorkbenchPart part, Node node) {
        if (widget != null) {
            IBindCommand command = (IBindCommand)context.createCommand(IBindCommand.class);
            command.setWidget(widget);
            command.setParticipant((IBindCommand.IBindCommandParticipant)new UIProviderImpl(part));
            EMFDataBindingCommand.executeDataBindCommand((IStructuredModel)((IDOMNode)node).getModel(), (IBindCommand)command);
        }
        return Status.CANCEL_STATUS;
    }

    private IWidget selectWidget(final Collection<? extends IWidget> widgets) {
        DropPopupMenu<IWidget> dropPopupMenu = new DropPopupMenu<IWidget>(){

            @Override
            public void addMenuItems(Shell shell, Menu popupMenu, SelectionAdapter selectionListener) {
                BaseDropCustomizer.addMenuItems(shell, popupMenu, widgets, selectionListener);
            }
        };
        return (IWidget)dropPopupMenu.getUserSelection();
    }

    public static void addMenuItems(Shell shell, Menu menu, Collection<? extends IWidget> widgets, SelectionAdapter selectionListener) {
        ObjectContentProvider contentProvider = new ObjectContentProvider(IWidget.class);
        Object[] elements = contentProvider.getElements(widgets);
        assert (elements.length > 0);
        if (elements.length > 1) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IWidget) {
                    BaseDropCustomizer.addWidgetMenuItem(menu, (IObject)((IWidget)element), selectionListener);
                } else if (element instanceof IDescriptor) {
                    IDescriptor typeDescriptor = (IDescriptor)element;
                    MenuItem typeMenuItem = new MenuItem(menu, 64);
                    typeMenuItem.setText(typeDescriptor.getLabel());
                    Menu typeMenu = new Menu((Decorations)shell, 4);
                    typeMenuItem.setMenu(typeMenu);
                    typeMenuItem.setImage(DTRTUIUtil.getImage((IDescriptor)typeDescriptor));
                    BaseDropCustomizer.addWidgetMenuItems(contentProvider, typeDescriptor, typeMenu, selectionListener);
                }
                ++n2;
            }
        } else {
            BaseDropCustomizer.addWidgetMenuItems(contentProvider, elements[0], menu, selectionListener);
        }
        contentProvider.dispose();
    }

    private static void addWidgetMenuItems(ObjectContentProvider contentProvider, Object parent, Menu menu, SelectionAdapter selectionListener) {
        IObject[] childWidgets;
        IObject[] iObjectArray = childWidgets = contentProvider.getChildren(parent);
        int n = childWidgets.length;
        int n2 = 0;
        while (n2 < n) {
            IObject childWidget = iObjectArray[n2];
            BaseDropCustomizer.addWidgetMenuItem(menu, childWidget, selectionListener);
            ++n2;
        }
    }

    private static void addWidgetMenuItem(Menu menu, IObject widget, SelectionAdapter selectionListener) {
        MenuItem widgetMenuItem = new MenuItem(menu, 8);
        widgetMenuItem.setText(DTRTUtil.getLabel((IDescribable)widget));
        widgetMenuItem.setImage(DTRTUIUtil.getImage((IDescribable)widget));
        widgetMenuItem.setData((Object)widget);
        widgetMenuItem.addSelectionListener((SelectionListener)selectionListener);
    }
}

