/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;

public class TagDropSourceDataAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ITaskFlow taskFlowObject;
        if (!(adaptableObject instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)adaptableObject;
        if (adapterType == ITagDropSourceData.class && (taskFlowObject = TaskFlowFactory.createTaskFlow((IFile)file)) instanceof ITaskFlow && !TaskFlowUtil.isTaskFlowTemplate((ITaskFlow)taskFlowObject)) {
            return new TaskFlowTagDropSourceData(file, taskFlowObject);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ITagDropSourceData.class};
    }

    public static final class TaskFlowTagDropSourceData
    implements ITagDropSourceData {
        private static final String NS_PREFIX = "af";
        private static final String NS_URI = "http://xmlns.oracle.com/adf/faces/rich";
        private static final String TAG_NAME = "region";
        private final IFile _taskFlowFile;
        private final ITaskFlow _taskFlow;

        public TaskFlowTagDropSourceData(IFile taskFlowFile, ITaskFlow taskFlow) {
            this._taskFlowFile = taskFlowFile;
            this._taskFlow = taskFlow;
        }

        public IFile getTaskFlowFile() {
            return this._taskFlowFile;
        }

        public ITaskFlow getTaskFlow() {
            return this._taskFlow;
        }

        public String getNamespace() {
            return NS_URI;
        }

        public String getId() {
            return this.getTagName();
        }

        public String getTagName() {
            return TAG_NAME;
        }

        public String getDefaultPrefix() {
            return NS_PREFIX;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getClass().getSimpleName());
            buffer.append('(');
            buffer.append("taskFlow=");
            buffer.append(this.getTaskFlowFile().getName());
            buffer.append(", boundedTaskFlow");
            buffer.append(", tag=");
            buffer.append(this.getDefaultPrefix());
            buffer.append(':');
            buffer.append(this.getTagName());
            buffer.append(", tagLibrary=");
            buffer.append(this.getNamespace());
            buffer.append(')');
            return buffer.toString();
        }
    }
}

