/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wpe;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class DropPopupMenu<O> {
    public abstract void addMenuItems(Shell var1, Menu var2, SelectionAdapter var3);

    public O getUserSelection() {
        final Object[] selected = new Object[1];
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                selected[0] = ((MenuItem)selectionEvent.getSource()).getData();
            }
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        Shell shell = display.getActiveShell();
        boolean disposeNewShell = false;
        try {
            if (shell == null) {
                shell = new Shell(display);
                disposeNewShell = true;
            }
            Composite menuHolder = new Composite((Composite)shell, 0);
            Menu popupMenu = new Menu((Control)menuHolder);
            this.addMenuItems(shell, popupMenu, selectionListener);
            new MenuItem(popupMenu, 2);
            final MenuItem cancel = new MenuItem(popupMenu, 8);
            cancel.setText("Cancel");
            cancel.addSelectionListener((SelectionListener)selectionListener);
            menuHolder.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 27) {
                        cancel.setSelection(true);
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            popupMenu.setVisible(true);
            while (!popupMenu.isDisposed() && popupMenu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            menuHolder.dispose();
        }
        finally {
            if (disposeNewShell && shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
        return (O)selected[0];
    }
}

