/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibrary;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.IADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowData;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowTemplateData;
import oracle.eclipse.tools.common.util.StringInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class TaskFlowADFLibraryListener
implements IADFLibraryListener {
    private IProject project;
    private List<TaskFlowData> taskFlowData;
    private List<TaskFlowTemplateData> taskFlowTemplateData;

    public TaskFlowADFLibraryListener(IProject project) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException("project must not be null");
        }
        this.project = project;
        this.taskFlowData = new ArrayList<TaskFlowData>();
        this.taskFlowTemplateData = new ArrayList<TaskFlowTemplateData>();
    }

    @Override
    public void entryAdded(ADFLibrary library, String sourceLocation, String destinationLocation) {
        Path sourcePath;
        IResource resource;
        if (sourceLocation != null && sourceLocation.toLowerCase().endsWith(".xml") && (resource = this.project.findMember((sourcePath = new Path(sourceLocation)).makeRelativeTo(this.project.getLocation()))) != null && resource.getType() == 1) {
            try {
                TaskFlowTemplateData templateData;
                TaskFlowData data = ADFLibraryUtils.getTaskFlowData(destinationLocation, (IFile)resource);
                if (data != null && data.getTaskFlow() != null && !data.isEmptyTaskFlow()) {
                    this.taskFlowData.add(data);
                }
                if ((templateData = ADFLibraryUtils.getTaskFlowTemplateData(destinationLocation, (IFile)resource)) != null) {
                    this.taskFlowTemplateData.add(templateData);
                }
            }
            catch (Exception ex) {
                ADFLibraryUtils.log(4, Resources.ERROR_READING_TASKFLOW, ex);
            }
        }
    }

    @Override
    public void entryRemoved(ADFLibrary library, String sourceLocation) {
    }

    @Override
    public void libraryWritten(ADFLibrary library, JarOutputStream out) {
        if (!this.taskFlowData.isEmpty() || !this.taskFlowTemplateData.isEmpty()) {
            StringBuffer sb = new StringBuffer("<?xml version = '1.0' encoding = 'UTF-8'?>\r\n");
            sb.append("<task-flow-registry xmlns=\"http://xmlns.oracle.com/adf/controller/rc\">\r\n");
            for (TaskFlowData data : this.taskFlowData) {
                sb.append("   ");
                sb.append(data.getTaskFlowDescriptorString());
                sb.append("\r\n");
            }
            for (TaskFlowTemplateData templateData : this.taskFlowTemplateData) {
                sb.append("   ");
                sb.append(templateData.getDescriptorString());
                sb.append("\r\n");
            }
            sb.append("</task-flow-registry>");
            try {
                ADFLibraryUtils.copyToJAR(out, (InputStream)new StringInputStream(sb.toString()), "META-INF/task-flow-registry.xml");
            }
            catch (IOException ioex) {
                ADFLibraryUtils.log(4, Resources.ERROR_WRITING_TASKFLOWREGISTRY, ioex);
            }
        }
    }

    private static class Resources
    extends NLS {
        public static String ERROR_WRITING_TASKFLOWREGISTRY;
        public static String ERROR_READING_TASKFLOW;

        static {
            Resources.initializeMessages((String)TaskFlowADFLibraryListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

