/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibrary;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.IADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowData;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowTemplateData;
import oracle.eclipse.tools.common.util.StringInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ResourceServiceADFLibraryListener
implements IADFLibraryListener {
    private static final String ADF_TASKFLOW = "oracle.adf.controller.rc.TaskFlowResourceServiceStrategy ADF_TaskFlow";
    private static final String ADF_BINDINGAPP = "oracle.adf.library.rc.bindingapp.BindingAppServiceStrategy ADF_BindingApp";
    private IProject project;
    private boolean hasTaskFlow;
    private boolean hasBindingApp;

    public ResourceServiceADFLibraryListener(IProject project) throws IllegalArgumentException {
        if (project == null) {
            throw new IllegalArgumentException("project must not be null");
        }
        this.project = project;
    }

    @Override
    public void entryAdded(ADFLibrary library, String sourceLocation, String destinationLocation) {
        if (sourceLocation != null) {
            Path sourcePath;
            IResource resource;
            if (sourceLocation.toLowerCase().endsWith("databindings.cpx")) {
                this.hasBindingApp |= true;
            }
            if (sourceLocation.toLowerCase().endsWith(".xml") && (resource = this.project.findMember((sourcePath = new Path(sourceLocation)).makeRelativeTo(this.project.getLocation()))) != null && resource.getType() == 1) {
                try {
                    TaskFlowTemplateData tftData;
                    TaskFlowData tfData = ADFLibraryUtils.getTaskFlowData(destinationLocation, (IFile)resource);
                    if (tfData != null && tfData.getTaskFlow() != null) {
                        this.hasTaskFlow |= !tfData.isEmptyTaskFlow();
                    }
                    this.hasTaskFlow |= (tftData = ADFLibraryUtils.getTaskFlowTemplateData(destinationLocation, (IFile)resource)) != null;
                }
                catch (Exception ex) {
                    ADFLibraryUtils.log(4, Resources.ERROR_READING_TASKFLOW, ex);
                }
            }
        }
    }

    @Override
    public void entryRemoved(ADFLibrary library, String sourceLocation) {
    }

    @Override
    public void libraryWritten(ADFLibrary library, JarOutputStream out) {
        if (this.hasComponent()) {
            StringBuffer sb = new StringBuffer();
            if (this.hasTaskFlow) {
                sb.append(ADF_TASKFLOW).append("\r\n");
            }
            if (this.hasBindingApp) {
                sb.append(ADF_BINDINGAPP).append("\r\n");
            }
            try {
                ADFLibraryUtils.copyToJAR(out, (InputStream)new StringInputStream(sb.toString()), "META-INF/oracle.adf.common.services.ResourceService.sva");
            }
            catch (IOException ioex) {
                ADFLibraryUtils.log(4, Resources.ERROR_WRITING_RESOURCESERVICE, ioex);
            }
        }
    }

    private boolean hasComponent() {
        return this.hasTaskFlow || this.hasBindingApp;
    }

    private static class Resources
    extends NLS {
        public static String ERROR_WRITING_RESOURCESERVICE;
        public static String ERROR_READING_TASKFLOW;

        static {
            Resources.initializeMessages((String)ResourceServiceADFLibraryListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

