/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners;

import java.io.File;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibrary;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.IADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFmADFLibraryListener
implements IADFLibraryListener {
    private Document masterDocument = null;

    @Override
    public void entryAdded(ADFLibrary library, String sourceLocation, String destinationLocation) {
        if (sourceLocation != null && sourceLocation.toLowerCase().endsWith("adfm.xml")) {
            Document document = this.getDocument(sourceLocation);
            if (this.masterDocument == null) {
                this.masterDocument = document;
            } else {
                this.mergeIntoMaster(document);
            }
            library.removeEntry(sourceLocation);
        }
    }

    @Override
    public void entryRemoved(ADFLibrary library, String sourceLocation) {
    }

    @Override
    public void libraryWritten(ADFLibrary library, JarOutputStream out) {
        if (this.masterDocument != null && out != null) {
            DOMSource source = new DOMSource(this.masterDocument);
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(3));
            try {
                Transformer transformer = factory.newTransformer();
                out.putNextEntry(new JarEntry("META-INF/adfm.xml"));
                try {
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("version", "1.0");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("standalone", "yes");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
                    transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
                }
                catch (IllegalArgumentException iae) {
                    ADFLibraryUtils.log(1, NLS.bind((String)Resources.ERROR_SETTING_OUTPUT_PROPERTY, (Object)iae.getLocalizedMessage()), null);
                }
                transformer.transform(source, result);
            }
            catch (Exception ex) {
                ADFLibraryUtils.log(4, Resources.ERROR_WRITING_ADFM_XML, ex);
            }
        }
    }

    private Document getDocument(String sourceLocation) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(sourceLocation));
        }
        catch (Exception ex) {
            ADFLibraryUtils.log(4, Resources.ERROR_READING_ADFM_XML, ex);
        }
        return document;
    }

    private void mergeIntoMaster(Document document) {
        Element docElement;
        if (this.masterDocument != null && document != null && (docElement = document.getDocumentElement()) != null) {
            NodeList childNodes = docElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element masterDocElement;
                Node newNode;
                Node node = childNodes.item(i);
                if (node.getNodeType() == 1 && (newNode = this.masterDocument.importNode(node, true)) != null && (masterDocElement = this.masterDocument.getDocumentElement()) != null) {
                    masterDocElement.appendChild(newNode);
                }
                ++i;
            }
        }
    }

    private static class Resources
    extends NLS {
        public static String ERROR_READING_ADFM_XML;
        public static String ERROR_WRITING_ADFM_XML;
        public static String ERROR_SETTING_OUTPUT_PROPERTY;

        static {
            Resources.initializeMessages((String)ADFmADFLibraryListener.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

