/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibrary;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.ADFLibraryWizardPageOne;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.ADFmADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.ResourceServiceADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.TaskFlowADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.WebIndexADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.TaskFlowTemplateData;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ADFLibraryExportWizard
extends Wizard
implements IExportWizard {
    private IProject project;
    private ADFLibraryWizardPageOne pageOne;

    public ADFLibraryExportWizard() {
        this.setWindowTitle(Resources.TITLE_WIZARD);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)"icons/wizards/export-adf-library-banner.png"));
        this.pageOne = new ADFLibraryWizardPageOne(1);
        this.addPage((IWizardPage)this.pageOne);
    }

    public void init(IWorkbench theWorkbench, IStructuredSelection selection) {
        this.project = ADFLibraryUtils.getProject(selection);
        this.pageOne.setProject(this.project);
    }

    public boolean performFinish() {
        block20: {
            IPath absoluteWebContentPath;
            this.project = this.pageOne.getProject();
            if (this.project != null && WtpProjectUtil.isDynamicWebProject((IProject)this.project) && (absoluteWebContentPath = ADFLibraryUtils.getWebContentPath(this.project)) != null) {
                IPath relativeWebContentPath = absoluteWebContentPath.makeRelativeTo(this.project.getLocation());
                ADFLibrary adfLibrary = new ADFLibrary();
                adfLibrary.addADFLibraryListener(new WebIndexADFLibraryListener(absoluteWebContentPath.toOSString()));
                adfLibrary.addADFLibraryListener(new ResourceServiceADFLibraryListener(this.project));
                adfLibrary.addADFLibraryListener(new TaskFlowADFLibraryListener(this.project));
                adfLibrary.addADFLibraryListener(new ADFmADFLibraryListener());
                try {
                    this.project.findMember(relativeWebContentPath).accept((IResourceVisitor)new WebContentResourceVisitor(adfLibrary));
                    this.project.findMember(relativeWebContentPath.append("WEB-INF")).accept((IResourceVisitor)new WEBINFResourceVisitor(adfLibrary));
                    this.project.findMember(relativeWebContentPath.append("META-INF")).accept((IResourceVisitor)new METAINFResourceVisitor(adfLibrary));
                    ArrayList<IProject> depProjects = new ArrayList<IProject>(this.pageOne.getDependentProjects());
                    depProjects.add(0, this.project);
                    for (IProject depProject : depProjects) {
                        List<IPath> outputPaths = ADFLibraryUtils.getOutputLocations(depProject);
                        for (IPath outputPath : outputPaths) {
                            depProject.findMember(outputPath.makeRelativeTo(depProject.getFullPath())).accept((IResourceVisitor)new BuildOutputLocationResourceVisitor(adfLibrary, outputPath));
                        }
                    }
                }
                catch (CoreException cex) {
                    ADFLibraryUtils.log(4, Resources.ERROR_SCANNING_PROJECTS, cex);
                }
                File file = new File(this.pageOne.getADFLibraryFilename());
                if (file.exists()) {
                    file.delete();
                }
                ZipOutputStream out = null;
                try {
                    try {
                        file.createNewFile();
                        FileOutputStream fileOut = new FileOutputStream(file);
                        Manifest manifest = new Manifest();
                        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                        out = new JarOutputStream((OutputStream)fileOut, manifest);
                        adfLibrary.write((JarOutputStream)out);
                    }
                    catch (IOException ioex) {
                        ADFLibraryUtils.log(4, Resources.ERROR_WRITING_LIBRARY, ioex);
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    private class BuildOutputLocationResourceVisitor
    implements IResourceVisitor {
        private ADFLibrary adfLibrary;
        private IPath buildOutputPath;

        public BuildOutputLocationResourceVisitor(ADFLibrary adfLibrary, IPath buildOutputPath) {
            this.adfLibrary = adfLibrary;
            this.buildOutputPath = buildOutputPath;
        }

        public boolean visit(IResource resource) throws CoreException {
            switch (resource.getType()) {
                case 1: {
                    String sourceLocation = resource.getLocation().toOSString();
                    if (sourceLocation.toUpperCase().endsWith("MANIFEST.MF")) break;
                    this.adfLibrary.addEntry(sourceLocation, resource.getFullPath().makeRelativeTo(this.buildOutputPath).toString());
                }
            }
            return true;
        }
    }

    private class METAINFResourceVisitor
    implements IResourceVisitor {
        private ADFLibrary adfLibrary;
        private IPath webContentPath;

        public METAINFResourceVisitor(ADFLibrary adfLibrary) {
            this.adfLibrary = adfLibrary;
            this.webContentPath = ADFLibraryUtils.getWebContentPath(ADFLibraryExportWizard.this.project);
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath resourceLocation = resource.getLocation();
            switch (resource.getType()) {
                case 1: {
                    if (resourceLocation.toOSString().toUpperCase().endsWith("MANIFEST.MF")) break;
                    this.adfLibrary.addEntry(resourceLocation.toOSString(), resourceLocation.makeRelativeTo(this.webContentPath).toString());
                }
            }
            return true;
        }
    }

    private static class Resources
    extends NLS {
        public static String TITLE_WIZARD;
        public static String ERROR_SCANNING_PROJECTS;
        public static String ERROR_WRITING_LIBRARY;

        static {
            Resources.initializeMessages((String)ADFLibraryExportWizard.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private class WEBINFResourceVisitor
    implements IResourceVisitor {
        private ADFLibrary adfLibrary;
        private IPath webContentPath;

        public WEBINFResourceVisitor(ADFLibrary adfLibrary) {
            this.adfLibrary = adfLibrary;
            this.webContentPath = ADFLibraryUtils.getWebContentPath(ADFLibraryExportWizard.this.project);
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath resourceLocation = resource.getLocation();
            switch (resource.getType()) {
                case 1: {
                    String resourceExtension = resource.getFileExtension();
                    if (!"xml".equalsIgnoreCase(resourceExtension)) break;
                    if (TaskFlowUtil.getTaskFlowType((IFile)((IFile)resource)) == TaskFlowType.Bounded || !resource.getName().equalsIgnoreCase("adfc-config.xml") && TaskFlowUtil.getTaskFlowType((IFile)((IFile)resource)) == TaskFlowType.Unbounded || TaskFlowTemplateData.create(resourceLocation.toOSString(), (IFile)resource) != null) {
                        this.adfLibrary.addEntry(resourceLocation.toOSString(), resourceLocation.makeRelativeTo(this.webContentPath).toString());
                        break;
                    }
                    if (resource.getName().equalsIgnoreCase("faces-config.xml")) {
                        String oldFCPath = resourceLocation.makeRelativeTo(this.webContentPath).toString();
                        String newFCPath = oldFCPath.replace("WEB-INF", "META-INF");
                        this.adfLibrary.addEntry(resourceLocation.toOSString(), newFCPath);
                        break;
                    }
                    if (!resource.getName().equalsIgnoreCase("adfc-config.xml")) break;
                    String oldADFcPath = resourceLocation.makeRelativeTo(this.webContentPath).toString();
                    String newADFcPath = oldADFcPath.replace("WEB-INF", "META-INF");
                    this.adfLibrary.addEntry(resourceLocation.toOSString(), newADFcPath);
                }
            }
            return true;
        }
    }

    private class WebContentResourceVisitor
    implements IResourceVisitor {
        private ADFLibrary adfLibrary;
        private IPath webContentPath;
        private IPath pathWEBINF;
        private IPath pathMETAINF;

        public WebContentResourceVisitor(ADFLibrary adfLibrary) {
            this.adfLibrary = adfLibrary;
            this.webContentPath = ADFLibraryUtils.getWebContentPath(ADFLibraryExportWizard.this.project);
            this.pathWEBINF = this.webContentPath.append("WEB-INF");
            this.pathMETAINF = this.webContentPath.append("META-INF");
        }

        public boolean visit(IResource resource) throws CoreException {
            boolean visitMembers = true;
            IPath resourceLocation = resource.getLocation();
            switch (resource.getType()) {
                case 2: {
                    if (!this.pathWEBINF.equals((Object)resourceLocation) && !this.pathMETAINF.equals((Object)resourceLocation)) break;
                    visitMembers = false;
                    break;
                }
                case 1: {
                    String resourceExtension = resource.getFileExtension();
                    if ("JAR".equalsIgnoreCase(resourceExtension) || "ZIP".equalsIgnoreCase(resourceExtension)) break;
                    this.adfLibrary.addEntry(resourceLocation.toOSString(), resourceLocation.makeRelativeTo(this.webContentPath).toString());
                }
            }
            return visitMembers;
        }
    }
}

