/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.listeners.IADFLibraryListener;
import oracle.eclipse.tools.adf.view.ui.wizard.internal.adflibrary.utils.ADFLibraryUtils;

public class ADFLibrary {
    private Map<String, String> entries = new HashMap<String, String>();
    private List<IADFLibraryListener> listeners = new ArrayList<IADFLibraryListener>();

    public void addADFLibraryListener(IADFLibraryListener listener) {
        this.listeners.add(listener);
    }

    public void addEntry(String sourceLocation, String destinationLocation) {
        if (sourceLocation != null && destinationLocation != null) {
            this.entries.put(sourceLocation, destinationLocation);
            for (IADFLibraryListener listener : this.listeners) {
                listener.entryAdded(this, sourceLocation, destinationLocation);
            }
        }
    }

    public void removeEntry(String sourceLocation) {
        if (sourceLocation != null) {
            this.entries.remove(sourceLocation);
            for (IADFLibraryListener listener : this.listeners) {
                listener.entryRemoved(this, sourceLocation);
            }
        }
    }

    public void write(JarOutputStream out) throws IOException {
        if (out != null) {
            for (String sourceLocation : this.entries.keySet()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(sourceLocation);
                    String destinationLocation = this.entries.get(sourceLocation);
                    ADFLibraryUtils.copyToJAR(out, in, destinationLocation);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            for (IADFLibraryListener listener : this.listeners) {
                listener.libraryWritten(this, out);
            }
        }
    }
}

