/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.util.Messages;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JavaUtils {
    public static final IStatus validateJavaClassName(String className) {
        if (className == null || className.trim().length() == 0) {
            String msg = Messages.JavaValidationUtil_classNameEmpty;
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, msg, null);
        }
        if (className.lastIndexOf(46) != -1) {
            String msg = Messages.JavaValidationUtil_qualifiedClassNameError;
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, msg, null);
        }
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className, (String)"1.3", (String)"1.3");
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(Messages.JavaValidationUtil_invalidClassNameError) + javaStatus.getMessage();
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, msg, null);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(Messages.JavaValidationUtil_warning_msg) + javaStatus.getMessage();
            return new Status(2, "oracle.eclipse.tools.adf.view.ui", 0, msg, null);
        }
        return Status.OK_STATUS;
    }

    public static final IStatus canCreateTypeInClasspath(IJavaProject project, String srcFolder, String packageName, String typeName) {
        IPackageFragmentRoot packRoot = JavaUtils.getJavaPackageFragmentRoot(project, srcFolder);
        IPackageFragment pack = null;
        if (packRoot != null) {
            pack = packRoot.getPackageFragment(packageName);
        }
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            String fullyQualifiedName = JavaUtils.getFullyQualifiedName(cu.getType(typeName));
            IResource resource = cu.getResource();
            if (resource.exists()) {
                String message = NLS.bind((String)Messages.JavaValidationUtil_typeAlreadyExists, (Object[])new Object[]{fullyQualifiedName});
                return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, message, null);
            }
            URI location = resource.getLocationURI();
            if (location != null) {
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    if (store.fetchInfo().exists()) {
                        String message = NLS.bind((String)Messages.JavaValidationUtil_typeExistsDifferentCase, (Object[])new Object[]{fullyQualifiedName});
                        return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, message, null);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static final IStatus typeAlreadyExists(IJavaProject project, String srcFolder, String packageName, String typeName) {
        IPackageFragmentRoot packRoot = JavaUtils.getJavaPackageFragmentRoot(project, srcFolder);
        IPackageFragment pack = null;
        if (packRoot != null) {
            pack = packRoot.getPackageFragment(packageName);
        }
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            String fullyQualifiedName = JavaUtils.getFullyQualifiedName(cu.getType(typeName));
            IResource resource = cu.getResource();
            if (resource.exists()) {
                String message = NLS.bind((String)Messages.JavaValidationUtil_typeAlreadyExists, (Object[])new Object[]{fullyQualifiedName});
                return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, message, null);
            }
        }
        return Status.OK_STATUS;
    }

    public static final IStatus typeExistsDifferentCase(IJavaProject project, String srcFolder, String packageName, String typeName) {
        IPackageFragmentRoot packRoot = JavaUtils.getJavaPackageFragmentRoot(project, srcFolder);
        IPackageFragment pack = null;
        if (packRoot != null) {
            pack = packRoot.getPackageFragment(packageName);
        }
        if (pack != null) {
            URI location;
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            String fullyQualifiedName = JavaUtils.getFullyQualifiedName(cu.getType(typeName));
            IResource resource = cu.getResource();
            if (!resource.exists() && (location = resource.getLocationURI()) != null) {
                try {
                    IFileStore store = EFS.getStore((URI)location);
                    if (store.fetchInfo().exists()) {
                        String message = NLS.bind((String)Messages.JavaValidationUtil_typeExistsDifferentCase, (Object[])new Object[]{fullyQualifiedName});
                        return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, message, null);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static final String showPackageSelectionDlg(IProject project, String srcFolderName, Shell shell) {
        IPackageFragmentRoot pkgRoot;
        block12: {
            IJavaProject javaProj = JavaCore.create((IProject)project);
            if (javaProj == null) {
                return null;
            }
            if (srcFolderName == null || srcFolderName.equals("")) {
                return null;
            }
            IPath srcFolderPath = project.getFullPath().append(srcFolderName);
            pkgRoot = null;
            try {
                IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
                if (roots == null) break block12;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && root.getCorrespondingResource().getFullPath().equals((Object)srcFolderPath)) {
                        pkgRoot = root;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logException((String)"oracle.eclipse.tools.adf.view.ui", (CoreException)((Object)jme));
                return null;
            }
        }
        if (pkgRoot == null) {
            return null;
        }
        Object[] packages = null;
        try {
            packages = pkgRoot.getChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(Messages.JavaValidationUtil_pkg_dlg_title);
        dialog.setMessage(Messages.JavaValidationUtil_pkg_dlg_msg);
        dialog.setEmptyListMessage(Messages.JavaValidationUtil_pkg_not_available);
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            if (fragment != null) {
                return fragment.getElementName();
            }
            return "";
        }
        return null;
    }

    public static final IContainer handleFolderButtonPressed(IProject project, Shell shell) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        ISelectionStatusValidator validator = JavaUtils.getContainerDialogSelectionValidator();
        ViewerFilter filter = JavaUtils.getContainerDialogViewerFilter(javaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(Messages.JavaValidationUtil_srcFolderDlgTitle);
        dialog.setMessage(Messages.JavaValidationUtil_srcFolderDlgDesc);
        dialog.addFilter(filter);
        dialog.setInput((Object)project);
        if (project != null) {
            dialog.setInitialSelection((Object)project);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IContainer) {
                    return (IContainer)element;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static final boolean isValidSourceFolder(IJavaProject javaProject, String srcFolderName) {
        List<IContainer> containers = JavaUtils.getJavaSourceContainers(javaProject);
        IPath srcFolderPath = javaProject.getProject().getFullPath().append(srcFolderName);
        if (containers != null) {
            for (IContainer container : containers) {
                if (!container.getFullPath().equals((Object)srcFolderPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static final List<IContainer> getJavaSourceContainers(IJavaProject javaProject) {
        IClasspathEntry[] entries = javaProject.readRawClasspath();
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 0) {
                Object container = null;
                container = entry.getPath().segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(entry.getPath());
                if (!containers.contains(container)) {
                    containers.add((IContainer)container);
                }
            }
            ++n2;
        }
        return containers;
    }

    public static IFolder getSourceFolder(ISelection selection, IProject project) throws JavaModelException {
        IPackageFragmentRoot root = JavaUtils.getSelectedPackageFragmentRoot(selection);
        if (root == null || !root.getJavaProject().getProject().equals((Object)project)) {
            return JavaUtils.getDefaultJavaSourceFolder(project);
        }
        IResource resource = root.getCorrespondingResource();
        if (resource.getProject().equals((Object)project) && resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return null;
    }

    public static IPackageFragment getPackageFragment(ISelection selection, IProject project) throws JavaModelException {
        IJavaElement element = JavaUtils.getInitialJavaElement(selection);
        if (element == null) {
            return null;
        }
        IResource resource = element.getCorrespondingResource();
        if (resource == null || !resource.getProject().equals((Object)project)) {
            return null;
        }
        if (element.getElementType() == 4) {
            return (IPackageFragment)element;
        }
        if (element.getParent() != null && element.getParent().getElementType() == 4) {
            return (IPackageFragment)element.getParent();
        }
        return null;
    }

    public static IResource getResource(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        }
        return (IResource)Platform.getAdapterManager().getAdapter(obj, IResource.class);
    }

    public static IFolder getDefaultJavaSourceFolder(IProject project) {
        if (project == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        List<IContainer> sources = JavaUtils.getJavaSourceContainers(javaProject);
        if (sources.size() > 0) {
            try {
                return (IFolder)sources.get(0);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static IJavaElement getJavaElement(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof IJavaElement) {
            return (IJavaElement)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IJavaElement)((IAdaptable)obj).getAdapter(IJavaElement.class);
        }
        return (IJavaElement)Platform.getAdapterManager().getAdapter(obj, IJavaElement.class);
    }

    public static IJavaElement getJavaElement(IProject project, String className) {
        if (className != null) {
            return ClassUtil.safeGetType((String)className, (IProject)project);
        }
        return null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement element) {
        IJavaElement primaryElement = element.getPrimaryElement();
        if (primaryElement instanceof ICompilationUnit) {
            return (ICompilationUnit)primaryElement;
        }
        ICompilationUnit icu = (ICompilationUnit)primaryElement.getAncestor(5);
        return icu;
    }

    public static IType getTargetIType(String fullClassName, IJavaProject project) throws JavaModelException {
        String fullyQualified;
        IType targetType = project.findType(fullClassName);
        if (targetType != null && fullClassName.equals(fullyQualified = ClassUtil.$toDot((String)targetType.getFullyQualifiedName()))) {
            return targetType;
        }
        return null;
    }

    private static final ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] != null && !(selection[0] instanceof IProject)) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.JavaValidationUtil_srcFolderNotValid, null);
            }
        };
    }

    private static final ViewerFilter getContainerDialogViewerFilter(final IJavaProject javaProject) {
        final List<IContainer> sourceFolders = JavaUtils.getJavaSourceContainers(javaProject);
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(javaProject.getProject().getName());
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    for (IContainer c : sourceFolders) {
                        if (!c.equals((Object)folder)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private static final IPackageFragmentRoot getJavaPackageFragmentRoot(IJavaProject javaProject, String srcFolder) {
        IPackageFragmentRoot pkgRoot = null;
        IPath srcFolderPath = javaProject.getProject().getFullPath().append(srcFolder);
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            if (roots != null) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && root.getCorrespondingResource().getFullPath().equals((Object)srcFolderPath)) {
                        pkgRoot = root;
                        return pkgRoot;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e1) {
            Activator.log(e1);
            return null;
        }
        return null;
    }

    private static final String getFullyQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return String.valueOf(JavaUtils.getFullyQualifiedName(declaringType)) + '.' + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {}
        return type.getFullyQualifiedName('.');
    }

    private static IPackageFragmentRoot getSelectedPackageFragmentRoot(ISelection selection) {
        IJavaElement element = JavaUtils.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 3) {
                return (IPackageFragmentRoot)element;
            }
            if (element.getElementType() == 4) {
                return JavaUtils.getPackageFragmentRoot((IPackageFragment)element);
            }
        }
        return null;
    }

    private static IJavaElement getInitialJavaElement(ISelection selection) {
        IResource resource;
        Object selectedElement;
        IJavaElement jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (jelem = JavaUtils.getJavaElement(selectedElement = ((IStructuredSelection)selection).getFirstElement())) == null && (resource = JavaUtils.getResource(selectedElement)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        return jelem;
    }

    private static IPackageFragmentRoot getPackageFragmentRoot(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            return null;
        }
        if (packageFragment.getParent() instanceof IPackageFragment) {
            return JavaUtils.getPackageFragmentRoot((IPackageFragment)packageFragment.getParent());
        }
        if (packageFragment.getParent() instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)packageFragment.getParent();
        }
        return null;
    }
}

