/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.view.configuration.FacesConfiguration;
import oracle.eclipse.tools.adf.view.configuration.WebXMLConfiguration;
import oracle.eclipse.tools.adf.view.configuration.WeblogicApplicationConfiguration;
import oracle.eclipse.tools.adf.view.configuration.WeblogicConfiguration;
import oracle.eclipse.tools.adf.view.ui.quickfix.AddFacesConfigXmlBlockResolution;
import oracle.eclipse.tools.adf.view.ui.quickfix.AddMissingXmlBlockResolution;
import oracle.eclipse.tools.adf.view.ui.quickfix.AddWeblogicApplicationXmlBlockResolution;
import oracle.eclipse.tools.adf.view.ui.quickfix.AddWeblogicXmlBlockResolution;
import oracle.eclipse.tools.adf.view.ui.quickfix.Messages;
import oracle.eclipse.tools.common.services.ui.quickfix.AbstractQuickFixFactory;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogueIndex;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.ui.IMarkerResolution;

public class ADFQuickFixFactory
extends AbstractQuickFixFactory {
    private static final List<QuickFixCatalogueIndex> FIXES = Collections.unmodifiableList(ADFQuickFixFactory.create((AbstractVirtualComponentQuery)new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery(), new StructuredModelXMLDocumentProvider(StructuredModelXMLDocumentProvider.ModelRequestType.SHARED_WRITE)));

    protected static List<QuickFixCatalogueIndex> create(AbstractVirtualComponentQuery query, StructuredModelXMLDocumentProvider provider) {
        ArrayList<QuickFixCatalogueIndex> indices = new ArrayList<QuickFixCatalogueIndex>();
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingResourceServlet", Messages.ADFMarkerResolutionGenerator_0, WebXMLConfiguration.WebXMLConfigType.RESOURCES_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingTrindadFilter", Messages.ADFMarkerResolutionGenerator_1, WebXMLConfiguration.WebXMLConfigType.TRINIDAD_FILTER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFacesServlet", Messages.ADFMarkerResolutionGenerator_2, WebXMLConfiguration.WebXMLConfigType.FACES_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingAdfVersionStringHiddenParam", Messages.ADFMarkerResolutionGenerator_3, WebXMLConfiguration.WebXMLConfigType.VERSION_STRING_HIDDEN_CONTEXT, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFacesStateSavingParam", Messages.ADFMarkerResolutionGenerator_4, WebXMLConfiguration.WebXMLConfigType.STATE_SAVING_METHOD_CONTEXT, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingCheckFileModParam", Messages.ADFMarkerResolutionGenerator_5, WebXMLConfiguration.WebXMLConfigType.TRINIDAD_CHECK_FILE_MOD_CONTEXT, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingResourceServletMappingAdf", Messages.ADFMarkerResolutionGenerator_12, WebXMLConfiguration.WebXMLConfigType.RESOURCES_ADF_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingResourceServletMappingAfr", Messages.ADFMarkerResolutionGenerator_13, WebXMLConfiguration.WebXMLConfigType.RESOURCES_AFR_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingResourceServletMappingBi", Messages.ADFMarkerResolutionGenerator_14, WebXMLConfiguration.WebXMLConfigType.RESOURCES_BI_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFacesServletMapping", Messages.ADFMarkerResolutionGenerator_15, WebXMLConfiguration.WebXMLConfigType.FACES_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingTrindadFilterMapping", Messages.ADFMarkerResolutionGenerator_19, WebXMLConfiguration.WebXMLConfigType.TRINIDAD_FILTER_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingBIGaugeServlet", Messages.ADFMarkerResolutionGenerator_20, WebXMLConfiguration.WebXMLConfigType.BIGAUGE_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingBIGraphServlet", Messages.ADFMarkerResolutionGenerator_21, WebXMLConfiguration.WebXMLConfigType.BIGRAPH_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingMapProxyServlet", Messages.ADFMarkerResolutionGenerator_22, WebXMLConfiguration.WebXMLConfigType.MAP_PROXY_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingGatewayServlet", Messages.ADFMarkerResolutionGenerator_23, WebXMLConfiguration.WebXMLConfigType.GATEWAY_SERVLET, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingBIGaugeServletMapping", Messages.ADFMarkerResolutionGenerator_24, WebXMLConfiguration.WebXMLConfigType.BIGAUGE_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingBiGraphServletMapping", Messages.ADFMarkerResolutionGenerator_25, WebXMLConfiguration.WebXMLConfigType.BIGRAPH_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingMapProxyServletMapping", Messages.ADFMarkerResolutionGenerator_26, WebXMLConfiguration.WebXMLConfigType.MAP_PROXY_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingGatewayServletMapping", Messages.ADFMarkerResolutionGenerator_27, WebXMLConfiguration.WebXMLConfigType.GATEWAY_SERVLET_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingADFBindingFilter", Messages.ADFMarkerResolutionGenerator_28, WebXMLConfiguration.WebXMLConfigType.ADF_BINDING_FILTER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingADFBindingFilterMapping", Messages.ADFMarkerResolutionGenerator_29, WebXMLConfiguration.WebXMLConfigType.ADF_BINDING_FILTER_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingServletADFFilter", Messages.ADFMarkerResolutionGenerator_30, WebXMLConfiguration.WebXMLConfigType.ADF_SERVLET_FILTER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingServletADFFilterMapping", Messages.ADFMarkerResolutionGenerator_31, WebXMLConfiguration.WebXMLConfigType.ADF_SERVLET_FILTER_MAPPING, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingJSPPropertyJSFF", Messages.ADFMarkerResolutionGenerator_32, WebXMLConfiguration.WebXMLConfigType.JSP_JSFF_CONFIG, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingADFConfigLifecycleCallBack", Messages.ADFMarkerResolutionGenerator_33, WebXMLConfiguration.WebXMLConfigType.ADF_CONFIG_LIFECYCLE_CALLBACK_LISTENER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingADFGlassfishAppConfigLifecycleCallBack", Messages.ADFMarkerResolutionGenerator_34, WebXMLConfiguration.WebXMLConfigType.ADF_GLASSFISH_APPCONFIG_LIFECYCLECALLBACK_LISTENER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFaceletContextParamADFFaceletResourceResolver", Messages.ADFMarkerResolutionGenerator_35, WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_ADF_FACELET_RESOURCE_RESOLVER, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFaceletContextParamADFFaceletTagDecorator", Messages.ADFMarkerResolutionGenerator_36, WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_ADF_FACELET_TAG_DECORATOR, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFaceletContextParamJSFFaceletViewMappings", Messages.ADFMarkerResolutionGenerator_37, WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_JSF_FACELET_VIEW_MAPPINGS, query, provider));
        indices.add(ADFQuickFixFactory.createMissingWebXmlBlock("missingFaceletContextParamSkipComments", Messages.ADFMarkerResolutionGenerator_38, WebXMLConfiguration.WebXMLConfigType.FACELET_CONTEXT_PARAM_SKIP_COMMENTS, query, provider));
        indices.add(ADFQuickFixFactory.createMissingFacesConfigBlock("missingRichFacesDefaultRenderKit", Messages.ADFMarkerResolutionGenerator_6, FacesConfiguration.FacesConfigType.DEFAULT_RENDER_KIT));
        indices.add(ADFQuickFixFactory.createMissingWeblogicBlock("missingWebappDomainSharedLibrary", Messages.ADFMarkerResolutionGenerator_7, WeblogicConfiguration.WeblogicConfigType.ADF_DOMAIN_WEBAPP_LIB_REF));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingEarDomainSharedLibrary", Messages.ADFMarkerResolutionGenerator_16, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.ADF_DOMAIN_LIBRARY_REF));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingWlLifecycleListener", Messages.ADFMarkerResolutionGenerator_17, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.WL_LIFECYCLE_LISTENER));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingAdfAppicationLifecycleListener", Messages.ADFMarkerResolutionGenerator_18, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.ADF_APPLICATION_LIFECYCLE_LISTENER));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingXmlParserFactory", Messages.ADFMarkerResolutionGenerator_8, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.XML_PARSER_FACTORY));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingSaxParserFactory", Messages.ADFMarkerResolutionGenerator_9, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.XML_SAX_PARSER_FACTORY));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingDocumentBuilderFactory", Messages.ADFMarkerResolutionGenerator_10, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.XML_DOCUMENT_BUILDER_FACTORY));
        indices.add(ADFQuickFixFactory.createMissingWeblogicApplicationBlock("missingTransformerParserFactory", Messages.ADFMarkerResolutionGenerator_11, WeblogicApplicationConfiguration.WeblogicApplicationConfigType.XML_TRANFORMER_FACTORY));
        return indices;
    }

    private static QuickFixCatalogueIndex createMissingWebXmlBlock(String id, String message, WebXMLConfiguration.WebXMLConfigType type, AbstractVirtualComponentQuery query, StructuredModelXMLDocumentProvider provider) {
        return new QuickFixCatalogueIndex("adfWebXml", id, (IMarkerResolution)new AddMissingXmlBlockResolution(message, type, query, provider));
    }

    private static QuickFixCatalogueIndex createMissingWeblogicApplicationBlock(String id, String message, WeblogicApplicationConfiguration.WeblogicApplicationConfigType type) {
        return new QuickFixCatalogueIndex("adfWeblogicApplicationXml", id, (IMarkerResolution)new AddWeblogicApplicationXmlBlockResolution(message, type));
    }

    private static QuickFixCatalogueIndex createMissingWeblogicBlock(String id, String message, WeblogicConfiguration.WeblogicConfigType type) {
        return new QuickFixCatalogueIndex("adfWeblogicXml", id, (IMarkerResolution)new AddWeblogicXmlBlockResolution(message, type));
    }

    private static QuickFixCatalogueIndex createMissingFacesConfigBlock(String id, String message, FacesConfiguration.FacesConfigType type) {
        return new QuickFixCatalogueIndex("adfFacesConfigXml", id, (IMarkerResolution)new AddFacesConfigXmlBlockResolution(message, type));
    }

    public Collection<? extends QuickFixCatalogueIndex> createQuickFixes() {
        return FIXES;
    }
}

