/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.quickfix;

import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogue;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogueIndex;
import oracle.eclipse.tools.common.services.ui.quickfix.QuickFixCatalogueInstance;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ADFMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private final QuickFixCatalogue _catalogue;

    public ADFMarkerResolutionGenerator() {
        this._catalogue = QuickFixCatalogueInstance.getInstance();
    }

    public ADFMarkerResolutionGenerator(QuickFixCatalogue catalogue) {
        this._catalogue = catalogue;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        String catalogueIndexKey = this.getCatalogueIndexKey(marker);
        QuickFixCatalogueIndex index = this._catalogue.findByKey(catalogueIndexKey);
        if (index != null && index.getResolutions().size() > 0) {
            return index.getResolutions().toArray(new IMarkerResolution[0]);
        }
        return new IMarkerResolution[0];
    }

    public boolean hasResolutions(IMarker marker) {
        return this.getCatalogueIndexKey(marker) != null;
    }

    private String getCatalogueIndexKey(IMarker marker) {
        try {
            Object attribute = marker.getAttribute("oracle.eclipse.tools.KEY_CATALOGUED_INDEX");
            if (attribute != null) {
                return attribute.toString();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

