/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.pagedefinition;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.pagedef.BindingBreakpoint;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IDeleteCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CreatableTypeDialog;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.provider.PageDefinitionContextContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.PageDefinitionContextLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseMenuCreator;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.BindingPage;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.HelpContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.progress.UIJob;

class PageDefinitionOutline
extends Outline<IPageDefinitionContext> {
    private IAction createAction;
    private IAction deleteAction;
    private ICreateCommand createCommand;
    private IDeleteCommand deleteCommand;
    private IAction toggleBreakpointBeforeAction;
    private IAction toggleBreakpointAfterAction;
    private IBreakpointListener breakpointListener;
    private IDebugEventSetListener debugEventListener;

    public PageDefinitionOutline(BindingPage editorPage, String identifier) {
        super((EditorPage)editorPage, identifier);
    }

    public void dispose() {
        if (this.createCommand != null) {
            this.createCommand.dispose();
            this.createCommand = null;
        }
        if (this.deleteCommand != null) {
            this.deleteCommand.dispose();
            this.deleteCommand = null;
        }
        if (this.breakpointListener != null) {
            IBreakpointManager mgr = DebugPlugin.getDefault().getBreakpointManager();
            mgr.removeBreakpointListener(this.breakpointListener);
            this.breakpointListener = null;
        }
        if (this.debugEventListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.debugEventListener);
            this.debugEventListener = null;
        }
        this.createAction = null;
        this.deleteAction = null;
        this.toggleBreakpointAfterAction = null;
        this.toggleBreakpointBeforeAction = null;
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        return new PageDefinitionContextContentProvider();
    }

    protected PageDefinitionContextLabelProvider createLabelProvider() {
        PageDefinitionContextLabelProvider labelProvider = new PageDefinitionContextLabelProvider((IPageDefinitionContext)this.getContext());
        labelProvider.setValidationMap(this.getEditorPage().getEditor().getValidationMap());
        return labelProvider;
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(2);
        treeViewer.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Object object;
                Tree tree = (Tree)e.widget;
                Menu menu = new Menu((Control)tree);
                tree.setMenu(menu);
                if (PageDefinitionOutline.this.createAction.isEnabled()) {
                    DTRTUIUtil.renderAction((Object)menu, (IAction)PageDefinitionOutline.this.createAction);
                }
                if (PageDefinitionOutline.this.deleteAction.isEnabled()) {
                    if (PageDefinitionOutline.this.createAction.isEnabled()) {
                        new MenuItem(menu, 2);
                    }
                    DTRTUIUtil.renderAction((Object)menu, (IAction)PageDefinitionOutline.this.deleteAction);
                }
                if ((object = DTRTUIUtil.getFirstElement((ISelection)PageDefinitionOutline.this.getSelection())) instanceof IBindingObject) {
                    String className;
                    if (PageDefinitionOutline.this.deleteAction.isEnabled() || PageDefinitionOutline.this.createAction.isEnabled()) {
                        new MenuItem(menu, 2);
                    }
                    boolean actionEnabled = (className = object.getClass().getName()).indexOf(".ICtrlHierImpl") < 0;
                    PageDefinitionOutline.this.toggleBreakpointBeforeAction.setEnabled(actionEnabled);
                    PageDefinitionOutline.this.toggleBreakpointAfterAction.setEnabled(actionEnabled);
                    DTRTUIUtil.renderAction((Object)menu, (IAction)PageDefinitionOutline.this.toggleBreakpointBeforeAction);
                    DTRTUIUtil.renderAction((Object)menu, (IAction)PageDefinitionOutline.this.toggleBreakpointAfterAction);
                }
            }
        });
    }

    protected void createActions() {
        BaseMenuCreator menuCreator = new BaseMenuCreator(){

            protected void initializeMenu(Menu menu) {
                ActionContributionItem item;
                if (!((IPageDefinitionContext)PageDefinitionOutline.this.getContext()).getCreatableTypes(IBinding.class).isEmpty()) {
                    Action createBindingAction = new Action(Messages.createBindingAction){

                        public void run() {
                            PageDefinitionOutline.this.handleCreateAction(IBinding.class);
                        }
                    };
                    createBindingAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.BINDING));
                    item = new ActionContributionItem((IAction)createBindingAction);
                    item.fill(menu, -1);
                }
                if (!((IPageDefinitionContext)PageDefinitionOutline.this.getContext()).getCreatableTypes(IIteratorBinding.class).isEmpty() || !((IPageDefinitionContext)PageDefinitionOutline.this.getContext()).getCreatableTypes(IExecutable.class).isEmpty()) {
                    Action createExecutableAction = new Action(Messages.createExecutableAction){

                        public void run() {
                            PageDefinitionOutline.this.handleCreateAction(IExecutable.class);
                        }
                    };
                    createExecutableAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.EXECUTABLE));
                    item = new ActionContributionItem((IAction)createExecutableAction);
                    item.fill(menu, -1);
                }
            }
        };
        this.createAction = new Action(Messages.createAction, 4){

            public void run() {
                Object object = DTRTUIUtil.getFirstElement((ISelection)PageDefinitionOutline.this.getSelection());
                if (object != null) {
                    Class baseType = PageDefinitionOutline.this.getCreatableBaseType(object instanceof PageDefinitionContextContentProvider.Category ? ((PageDefinitionContextContentProvider.Category)object).getType() : object.getClass());
                    if (baseType != null) {
                        PageDefinitionOutline.this.handleCreateAction(baseType);
                    }
                } else {
                    PageDefinitionOutline.this.handleCreateAction(IBinding.class);
                }
            }
        };
        this.createAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.ACTION_ADD));
        this.createAction.setMenuCreator((IMenuCreator)menuCreator);
        this.deleteAction = new Action(Messages.deleteAction){

            public void run() {
                PageDefinitionOutline.this.handleDeleteAction();
            }
        };
        this.deleteAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.ACTION_DELETE));
        this.toggleBreakpointBeforeAction = new Action(Messages.breakpointBefore){

            public void run() {
                PageDefinitionOutline.this.handleToggleBreakpoint(true);
            }
        };
        this.toggleBreakpointBeforeAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.BREAKPOINT_BEFORE));
        this.toggleBreakpointAfterAction = new Action(Messages.breakpointAfter){

            public void run() {
                PageDefinitionOutline.this.handleToggleBreakpoint(false);
            }
        };
        this.toggleBreakpointAfterAction.setImageDescriptor(DTRTUIUtil.getImageDescriptor((ImageManager.IImageData)DTRTBundleIcon.BREAKPOINT_AFTER));
        this.addBreakpointListener();
    }

    protected IAction getCreateAction() {
        return this.createAction;
    }

    protected IAction getDeleteAction() {
        return this.deleteAction;
    }

    protected void updateActions(ISelection currentSelection) {
        if (((IPageDefinitionContext)this.getContext()).getPageDefinition() == null || ((IPageDefinitionContext)this.getContext()).getPageDefinition().isDisposed()) {
            this.deleteAction.setEnabled(false);
            this.createAction.setEnabled(false);
        } else {
            Object selectedObject = DTRTUIUtil.getFirstElement((ISelection)currentSelection);
            if (selectedObject instanceof PageDefinitionContextContentProvider.Category) {
                this.deleteAction.setEnabled(false);
                this.deleteAction.setToolTipText(Messages.delete);
                PageDefinitionContextContentProvider.Category category = (PageDefinitionContextContentProvider.Category)selectedObject;
                this.updateCreateAction(this.getCreatableBaseType(category.getType()));
            } else if (selectedObject instanceof IBindingObject) {
                if (this.getDeleteCommand((IBindingObject)selectedObject) == null) {
                    this.deleteAction.setEnabled(false);
                    this.deleteAction.setToolTipText(Messages.cannotDelete);
                } else {
                    this.deleteAction.setEnabled(true);
                    this.deleteAction.setToolTipText(NLS.bind((String)Messages.deleteObject, (Object)DTRTUtil.getLabel((IDescribable)((IObject)selectedObject))));
                }
                this.updateCreateAction(this.getCreatableBaseType(selectedObject.getClass()));
            } else {
                this.deleteAction.setEnabled(false);
                this.deleteAction.setToolTipText(Messages.delete);
                this.updateCreateAction(IBinding.class);
            }
        }
    }

    protected void handleUpdateObject(Collection<? extends IObject> objects) {
        Object bindingCategory = null;
        Object executableCategory = null;
        ITreeContentProvider contentProvider = this.getContentProvider();
        for (IObject iObject : objects) {
            if (bindingCategory == null && iObject instanceof IBinding) {
                bindingCategory = contentProvider.getParent((Object)iObject);
            }
            if (executableCategory == null && iObject instanceof IExecutable) {
                executableCategory = contentProvider.getParent((Object)iObject);
            }
            if (bindingCategory != null && executableCategory != null) break;
        }
        if (bindingCategory != null || executableCategory != null) {
            Object[] objectArray = bindingCategory != null && executableCategory != null ? new Object[objects.size() + 2] : new Object[objects.size() + 1];
            objects.toArray(objectArray);
            if (bindingCategory != null && executableCategory != null) {
                objectArray[objectArray.length - 2] = bindingCategory;
                objectArray[objectArray.length - 1] = executableCategory;
            } else {
                objectArray[objectArray.length - 1] = bindingCategory != null ? bindingCategory : executableCategory;
            }
            this.update(objectArray);
        }
    }

    private void handleToggleBreakpoint(boolean beforeBreakpoint) {
        block6: {
            Object object = DTRTUIUtil.getFirstElement((ISelection)this.getSelection());
            if (object instanceof IObject) {
                String id;
                IObject obj = (IObject)object;
                IPageDefinitionContext context = (IPageDefinitionContext)this.getContext();
                IFile file = context.getAccessibleFile(obj);
                BindingBreakpoint brkpt = AdfDebugModel.findBidningBreakpoint((IResource)file, (String)(id = obj.getId()), (boolean)beforeBreakpoint);
                if (brkpt != null) {
                    try {
                        if (brkpt.isEnabled()) {
                            this.removeBreakpoint(obj, beforeBreakpoint);
                            break block6;
                        }
                        this.createBreakPoint(obj, beforeBreakpoint);
                    }
                    catch (Exception exception) {}
                } else {
                    this.createBreakPoint(obj, beforeBreakpoint);
                }
            }
        }
    }

    private void removeBreakpoint(IObject obj, boolean breakBefore) {
        IFile file = DTRTUIUtil.getAccessiblePageDefinitionFile((IPageDefinitionContext)((IPageDefinitionContext)this.getContext()));
        String id = obj.getId();
        try {
            AdfDebugModel.removeDCBindingBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createBreakPoint(IObject obj, boolean breakBefore) {
        IFile file = DTRTUIUtil.getAccessiblePageDefinitionFile((IPageDefinitionContext)((IPageDefinitionContext)this.getContext()));
        String id = obj.getId();
        try {
            BindingBreakpoint bkpt = AdfDebugModel.findBidningBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            if (bkpt != null) {
                bkpt.setEnabled(true);
                return;
            }
            String className = obj.getClass().getName();
            if (className.indexOf(".ICtrlMethodActionImpl") > 0) {
                AdfDebugModel.createMethodBindingBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            } else if (className.indexOf(".ICtrlActionImpl") > 0) {
                AdfDebugModel.createActionBindingBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            } else if (className.indexOf(".DTTaskFlowBindingImpl") > 0) {
                AdfDebugModel.createTaskflowExecutableBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            } else if (obj instanceof IIteratorBinding) {
                AdfDebugModel.createIteratorBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            } else {
                AdfDebugModel.createValueBindingBreakpoint((IResource)file, (String)id, (boolean)breakBefore);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private Class<? extends IBindingObject> getCreatableBaseType(Class<?> type) {
        Class baseType;
        Class clazz = IIteratorBinding.class.isAssignableFrom(type) ? IIteratorBinding.class : (baseType = IExecutable.class.isAssignableFrom(type) ? IExecutable.class : IBinding.class);
        if (((IPageDefinitionContext)this.getContext()).getCreatableTypes(baseType).isEmpty()) {
            Class clazz2 = baseType == IExecutable.class ? IIteratorBinding.class : (baseType = baseType == IIteratorBinding.class ? IExecutable.class : null);
            if (baseType != null && ((IPageDefinitionContext)this.getContext()).getCreatableTypes(baseType).isEmpty()) {
                baseType = null;
            }
        }
        return baseType;
    }

    private void handleCreateAction(Class<? extends IBindingObject> baseType) {
        assert (this.createCommand != null);
        assert (baseType != null);
        if (this.chooseType(baseType)) {
            ICreateCommand cc = this.createCommand;
            this.createCommand = null;
            ((IPageDefinitionContext)this.getContext()).setExecuteCommand((ICommand)cc.setParent((IObject)((IPageDefinitionContext)this.getContext()).getPageDefinition()));
            DTRTUIUtil.executeWithProgressMonitorDialog((Shell)this.getShell(), (ICommandStack)this.getContext());
            this.updateActions(this.getTreeSelection());
        }
    }

    private boolean chooseType(Class<? extends IBindingObject> baseType) {
        List types = ((IPageDefinitionContext)this.getContext()).getCreatableTypes(baseType);
        assert (!types.isEmpty());
        BindingObjectCreationDialog dialog = new BindingObjectCreationDialog(this.getShell(), (IPageDefinitionContext)this.getContext(), this.createCommand, baseType);
        dialog.create();
        return dialog.open() == 0;
    }

    private void handleDeleteAction() {
        assert (this.deleteCommand != null);
        IObject object = DTRTUIUtil.getObject((ISelection)this.getTreeSelection());
        assert (object != null);
        IDeleteCommand dc = this.deleteCommand;
        this.deleteCommand = null;
        ((IPageDefinitionContext)this.getContext()).setExecuteCommand((ICommand)dc.setParent((IObject)((IPageDefinitionContext)this.getContext()).getPageDefinition()).setObject(object));
        DTRTUIUtil.executeWithProgressMonitorDialog((Shell)this.getShell(), (ICommandStack)this.getContext());
        this.removeBreakpoint(object, true);
        this.removeBreakpoint(object, false);
        this.updateActions(this.getTreeSelection());
    }

    private ICreateCommand getCreateCommand() {
        return this.createCommand == null ? (this.createCommand = (ICreateCommand)((IPageDefinitionContext)this.getContext()).createCommand(ICreateCommand.class)) : this.createCommand;
    }

    private IDeleteCommand getDeleteCommand(IBindingObject bindingObject) {
        if (this.deleteCommand == null) {
            IDeleteCommand deleteCommand = (IDeleteCommand)((IPageDefinitionContext)this.getContext()).createCommand(IDeleteCommand.class);
            deleteCommand.setParent((IObject)((IPageDefinitionContext)this.getContext()).getPageDefinition()).setObject((IObject)bindingObject);
            if (((IPageDefinitionContext)this.getContext()).setExecuteCommand((ICommand)deleteCommand).canExecute().isOK()) {
                this.deleteCommand = deleteCommand;
            }
        }
        return this.deleteCommand;
    }

    private void updateCreateAction(Class<? extends IBindingObject> baseType) {
        if (baseType != null) {
            if (this.getCreateCommand() != null) {
                this.createAction.setEnabled(true);
                this.createAction.setToolTipText(baseType == IIteratorBinding.class || baseType == IExecutable.class ? Messages.createExecutable : (baseType == IBinding.class ? Messages.createBinding : Messages.create));
            } else {
                this.createAction.setEnabled(false);
                this.createAction.setToolTipText(Messages.cannotCreate);
            }
        } else {
            this.createAction.setEnabled(false);
            this.createAction.setToolTipText(Messages.create);
        }
    }

    private void addBreakpointListener() {
        IBreakpointManager mgr = DebugPlugin.getDefault().getBreakpointManager();
        this.breakpointListener = new IBreakpointListener(){

            public void breakpointRemoved(IBreakpoint arg0, IMarkerDelta arg1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageDefinitionOutline.this.refresh(true);
                    }
                });
            }

            public void breakpointChanged(IBreakpoint bkpt, IMarkerDelta arg1) {
                if (bkpt instanceof BindingBreakpoint) {
                    this.refreshTreeViewer();
                }
            }

            public void breakpointAdded(IBreakpoint bkpt) {
                if (bkpt instanceof BindingBreakpoint) {
                    this.refreshTreeViewer();
                }
            }

            private void refreshTreeViewer() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageDefinitionOutline.this.refresh(true);
                    }
                });
            }
        };
        mgr.addBreakpointListener(this.breakpointListener);
        this.debugEventListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events.length > 0 && (events[0].getKind() == 1 || events[0].getKind() == 8 || events[0].getKind() == 2)) {
                    UIJob refreshJob = new UIJob("Refresh"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            PageDefinitionOutline.this.refresh(true);
                            return Status.OK_STATUS;
                        }
                    };
                    refreshJob.schedule(500L);
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventListener);
    }

    protected ISelection toTreeSelection(TreeViewer treeViewer, ISelection selection) {
        Object selectedObject = DTRTUIUtil.getFirstElement((ISelection)selection);
        if (selectedObject instanceof IDataControlObject) {
            DescribableTreeElement objectTreeElement = PageDefinitionContextContentProvider.findObjectTreeElement((TreeViewer)treeViewer, (IObject)((IObject)selectedObject));
            selection = objectTreeElement != null ? new StructuredSelection((Object)objectTreeElement) : null;
        } else if (!(selectedObject instanceof PageDefinitionContextContentProvider.Category || selectedObject instanceof IBindingObject || selectedObject instanceof DescribableTreeElement)) {
            selection = null;
        }
        return selection;
    }

    protected ISelection fromTreeSelection(TreeViewer treeViewer, ISelection rawSelection) {
        Object selectedObject = DTRTUIUtil.getFirstElement((ISelection)rawSelection);
        if (selectedObject instanceof PageDefinitionContextContentProvider.Category || selectedObject instanceof IObject) {
            return rawSelection;
        }
        IObject object = DTRTUIUtil.getObject((ISelection)rawSelection);
        if (object != null) {
            return new StructuredSelection((Object)object);
        }
        return StructuredSelection.EMPTY;
    }

    private static class BindingObjectCreationDialog
    extends CreatableTypeDialog {
        public BindingObjectCreationDialog(Shell shell, IPageDefinitionContext context, ICreateCommand command, Class<? extends IBindingObject> baseType) {
            super(shell, (IOEPEExecutableContext)context, command, baseType);
        }

        private boolean isExecutable() {
            return this.getBaseType() == IExecutable.class || this.getBaseType() == IIteratorBinding.class;
        }

        protected IPageDefinitionContext getContext() {
            return (IPageDefinitionContext)super.getContext();
        }

        protected String getTitle() {
            return this.isExecutable() ? Messages.createExecutableTitle : Messages.createBindingTitle;
        }

        protected String getMessage() {
            return this.isExecutable() ? Messages.selectExecutableType : Messages.selectBindingType;
        }

        protected void addCreatableTypes(List<IDescribable> types) {
            if (this.isExecutable()) {
                types.addAll(this.getContext().getCreatableTypes(IExecutable.class));
                types.addAll(this.getContext().getCreatableTypes(IIteratorBinding.class));
            } else {
                types.addAll(this.getContext().getCreatableTypes(IBinding.class));
            }
        }

        protected String computeUniqueId(String label, IDescribable type) {
            return this.getContext().computeUniqueId(this.getBaseType(), DTRTUtil.getLabel((IDescribable)type), type);
        }

        protected boolean canModifyId(IDescribable type) {
            return this.getContext().canModifyId(type);
        }

        protected void applyContextHelp(Control control) {
            HelpContext helpContext = this.isExecutable() ? HelpContext.NEW_EXECUTABLE : HelpContext.NEW_BINDING;
            helpContext.apply(control);
        }
    }

    private static class Messages
    extends NLS {
        public static String create;
        public static String createBinding;
        public static String createExecutable;
        public static String delete;
        public static String createAction;
        public static String createBindingAction;
        public static String createExecutableAction;
        public static String deleteAction;
        public static String deleteObject;
        public static String cannotCreate;
        public static String cannotDelete;
        public static String createBindingTitle;
        public static String createExecutableTitle;
        public static String selectBindingType;
        public static String selectExecutableType;
        public static String breakpointBefore;
        public static String breakpointAfter;

        static {
            NLS.initializeMessages((String)PageDefinitionOutline.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

