/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.pagedefinition;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicDataControlObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.BaseDetailPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.ObjectDetailsPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.FormTextHTMLGenerator;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ui.pagedefinition.BindingPage;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

class PageDefinitionObjectDetailsPage
extends ObjectDetailsPage<IPageDefinitionContext> {
    private Section objectSection;
    private PageBook pageBook;
    private Control pageBookDefaultControl;
    private Font labelItalicFont;
    private Section usageSection;
    private FormText usageText;
    private BindingObjectUsageManager.IResetListener resetListener;

    public PageDefinitionObjectDetailsPage(BindingPage editorPage) {
        super((EditorPage)editorPage);
    }

    public void dispose() {
        if (this.resetListener != null) {
            BindingObjectUsageManager usageManager = this.getEditorPage().getUsageManager();
            if (usageManager != null) {
                usageManager.removeResetListener(this.resetListener);
            }
            this.resetListener = null;
        }
        if (this.labelItalicFont != null) {
            this.labelItalicFont.dispose();
            this.labelItalicFont = null;
        }
        this.objectSection = null;
        this.pageBook = null;
        this.pageBookDefaultControl = null;
        this.usageSection = null;
        this.usageText = null;
        super.dispose();
    }

    protected BindingPage getEditorPage() {
        return (BindingPage)super.getEditorPage();
    }

    public void createContents(Composite parent) {
        super.createContents(parent);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.objectSection = BaseDetailPage.createSection((IManagedForm)this.getManagedForm(), (Composite)parent, (String)Messages.object, (boolean)true, (int)64);
        this.pageBook = new PageBook((Composite)this.objectSection, 0);
        toolkit.adapt((Composite)this.pageBook);
        this.objectSection.setClient((Control)this.pageBook);
        this.pageBookDefaultControl = toolkit.createLabel((Composite)this.pageBook, Messages.unsupportedObject);
        this.labelItalicFont = DTRTUIUtil.createItalicFont((Font)this.pageBookDefaultControl.getFont());
        this.pageBookDefaultControl.setFont(this.labelItalicFont);
        this.pageBook.showPage(this.pageBookDefaultControl);
        this.usageSection = BaseDetailPage.createSection((IManagedForm)this.getManagedForm(), (Composite)parent, (String)Messages.usage, (boolean)false, (int)0);
        this.usageText = DTRTUIUtil.createFormText((FormToolkit)toolkit, (Composite)this.usageSection, (int)(0x48 | toolkit.getOrientation()));
        this.usageSection.setClient((Control)this.usageText);
        this.usageSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PageDefinitionObjectDetailsPage.this.updateUsage();
            }
        });
        this.usageText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                Object object = FormTextHTMLGenerator.decodeHRef((FormText)PageDefinitionObjectDetailsPage.this.usageText, (Object)event.getHref());
                if (object instanceof IObject) {
                    PageDefinitionObjectDetailsPage.this.getManagedForm().fireSelectionChanged((IFormPart)PageDefinitionObjectDetailsPage.this, (ISelection)new StructuredSelection(object));
                } else if (object instanceof BindingObjectUsageManager.INodeProxy) {
                    BindingObjectUsageManager.INodeProxy nodeProxy = (BindingObjectUsageManager.INodeProxy)object;
                    if (!$assertionsDisabled && nodeProxy.isDisposed()) {
                        throw new AssertionError();
                    }
                    DTRTUIUtil.openWebPageEditor((Shell)PageDefinitionObjectDetailsPage.this.usageText.getShell(), (BindingObjectUsageManager.INodeProxy)nodeProxy);
                }
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (this.objectSection != null) {
            if (this.getEditorPage().getContext().getPageDefinition() == null) {
                this.objectSection.setText(Messages.object);
                this.pageBook.showPage(this.pageBookDefaultControl);
                this.disposeObjectEditor();
                this.objectEditorControl = null;
                this.objectEditor = null;
            } else {
                IObject object = DTRTUIUtil.getObject((ISelection)selection);
                if (!this.isCurrentObject(object)) {
                    String objectSectionTitle = null;
                    Control control = null;
                    Object objectEditor = null;
                    if (object != null) {
                        objectEditor = (IUIObjectEditor)this.getEditorPage().getContext().createObjectEditor(IUIObjectEditor.class, object);
                        if (objectEditor == null) {
                            objectEditor = object instanceof IDataControlObject ? new BasicDataControlObjectEditor((IDataControlProvider)this.getEditorPage().getContext(), (IDataControlObject)object, true, false) : new BasicObjectEditor(object);
                        }
                        objectEditor.addObjectSelectionListener(new ISelectionListener(){

                            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                                PageDefinitionObjectDetailsPage.this.getManagedForm().fireSelectionChanged((IFormPart)PageDefinitionObjectDetailsPage.this, selection);
                            }
                        });
                        control = objectEditor.createControl(this.getManagedForm(), this.getManagedForm().getToolkit(), (Composite)this.pageBook);
                        objectEditor.setClient((IUIObjectEditor.IObjectEditorClient)this.getEditorPage().getEditor());
                        objectEditor.refresh();
                        this.pageBook.showPage(control);
                        DTRTUIUtil.controlChanged((Control)this.pageBook);
                        String string = object instanceof IIteratorBinding ? Messages.iteratorBinding : (object instanceof IExecutable ? Messages.executable : (object instanceof IBinding ? Messages.binding : (object instanceof IDataControlChild ? Messages.dataControlChild : (objectSectionTitle = object instanceof IDataControl ? Messages.dataControl : object.getClass().getName()))));
                    }
                    if (objectSectionTitle == null) {
                        objectSectionTitle = Messages.object;
                    }
                    this.objectSection.setText(objectSectionTitle);
                    if (control == null) {
                        this.pageBook.showPage(this.pageBookDefaultControl);
                    }
                    this.disposeObjectEditor();
                    this.objectEditorControl = control;
                    this.objectEditor = objectEditor;
                    this.updateUsage();
                }
            }
        }
    }

    private void updateUsage() {
        if (this.usageSection != null) {
            if (this.objectEditor == null) {
                this.usageSection.setVisible(false);
            } else {
                this.usageSection.setVisible(true);
                if (this.usageSection.isExpanded()) {
                    IObject object = this.objectEditor.getObject();
                    String label = DTRTUtil.getLabel((IDescribable)object);
                    FormTextHTMLGenerator.HTMLUnorderedList generator = null;
                    if (label != null) {
                        if (object instanceof IExecutable) {
                            List usages = this.getEditorPage().getUsageManager().getUsages((IBindingObject)((IExecutable)object));
                            List bindingObjects = ((IExecutable)object).collectUsage();
                            if (!bindingObjects.isEmpty() || !usages.isEmpty()) {
                                FormTextHTMLGenerator.HTMLUnorderedList unorderedList = new FormTextHTMLGenerator.HTMLUnorderedList(this.usageText);
                                if (!bindingObjects.isEmpty()) {
                                    unorderedList.addEncodedText(Messages.usedInPageDefinition);
                                    this.addLIs(unorderedList, bindingObjects);
                                }
                                if (!usages.isEmpty()) {
                                    this.addBoundSourceUsage(unorderedList, usages);
                                }
                                if (unorderedList.liCounter() > 0) {
                                    generator = unorderedList;
                                }
                            }
                            if (generator == null) {
                                FormTextHTMLGenerator.HTMLText text = new FormTextHTMLGenerator.HTMLText(this.usageText);
                                text.addEncodedText(NLS.bind((String)Messages.notUsed, (Object)label));
                                generator = text;
                            }
                        } else if (object instanceof IDataControlObject) {
                            Pair usages = DTRTObjectUtil.computePageDefinitionUsage((IPageDefinition)this.getEditorPage().getContext().getPageDefinition(), (IDataControlObject)((IDataControlObject)object));
                            if (!((List)usages.getFirst()).isEmpty() || !((List)usages.getSecond()).isEmpty()) {
                                FormTextHTMLGenerator.HTMLUnorderedList unorderedList = new FormTextHTMLGenerator.HTMLUnorderedList(this.usageText);
                                unorderedList.addEncodedText(NLS.bind((String)Messages.usedInPageDefinition, (Object)label));
                                this.addLIs(unorderedList, (List)usages.getFirst());
                                this.addLIs(unorderedList, (List)usages.getSecond());
                                if (unorderedList.liCounter() > 0) {
                                    generator = unorderedList;
                                }
                            }
                            if (generator == null) {
                                FormTextHTMLGenerator.HTMLText text = new FormTextHTMLGenerator.HTMLText(this.usageText);
                                text.addEncodedText(NLS.bind((String)Messages.notUsed, (Object)label));
                                generator = text;
                            }
                        } else if (object instanceof IBinding) {
                            List usages = this.getEditorPage().getUsageManager().getUsages((IBindingObject)((IBinding)object));
                            if (!usages.isEmpty()) {
                                FormTextHTMLGenerator.HTMLUnorderedList unorderedList = new FormTextHTMLGenerator.HTMLUnorderedList(this.usageText);
                                this.addBoundSourceUsage(unorderedList, usages);
                                if (unorderedList.liCounter() > 0) {
                                    generator = unorderedList;
                                }
                            }
                            if (generator == null) {
                                FormTextHTMLGenerator.HTMLText text = new FormTextHTMLGenerator.HTMLText(this.usageText);
                                text.addEncodedText(NLS.bind((String)Messages.notUsed, (Object)label));
                                generator = text;
                            }
                        }
                    }
                    if (generator != null) {
                        generator.flush();
                    } else {
                        this.usageText.setText(Messages.unableToComputeUsage, false, false);
                    }
                    this.usageSection.setVisible(true);
                    DTRTUIUtil.controlChanged((Control)this.usageText);
                }
            }
        }
    }

    private void addBoundSourceUsage(FormTextHTMLGenerator.HTMLUnorderedList unorderedList, List<? extends BindingObjectUsageManager.Usage> usages) {
        Map map = BindingObjectUsageManager.toUsageByFile(usages);
        for (Map.Entry entry : map.entrySet()) {
            IPageDefinition.IBoundSource boundSource = ((BindingObjectUsageManager.Usage)((List)entry.getValue()).get(0)).getBoundSource();
            String text = DTRTUtil.getLabel((IDescribable)boundSource);
            if (text == null) continue;
            unorderedList.addEncodedText(text);
            for (BindingObjectUsageManager.Usage usage : (List)entry.getValue()) {
                for (BindingObjectUsageManager.INodeProxy tagReference : usage.getNodeProxies()) {
                    unorderedList.addLI(null, (Object)tagReference, tagReference.toString());
                }
            }
        }
        if (this.resetListener == null && unorderedList.liCounter() > 0) {
            this.resetListener = new BindingObjectUsageManager.IResetListener(){

                public void handleReset(BindingObjectUsageManager manager) {
                    Display display = Display.getCurrent();
                    if (display != null) {
                        PageDefinitionObjectDetailsPage.this.updateUsage();
                    } else {
                        display = Display.getDefault();
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PageDefinitionObjectDetailsPage.this.updateUsage();
                                }
                            });
                        }
                    }
                }
            };
            this.getEditorPage().getUsageManager().addResetListener(this.resetListener);
        }
    }

    private void addLIs(FormTextHTMLGenerator.HTMLUnorderedList generator, List<? extends IBindingObject> bindingObjects) {
        if (!bindingObjects.isEmpty()) {
            Collections.sort(bindingObjects, DTRTUtil.COMPARATOR);
            int i = 0;
            while (i < bindingObjects.size()) {
                IBindingObject bindingObject = bindingObjects.get(i);
                String label = DTRTUtil.getLabel((IDescribable)bindingObject);
                if (label != null) {
                    generator.addLI(DTRTUIUtil.getImage((IDescribable)bindingObject), (Object)bindingObject, label);
                }
                ++i;
            }
        }
    }

    private static class Messages
    extends NLS {
        public static String object;
        public static String usage;
        public static String binding;
        public static String executable;
        public static String iteratorBinding;
        public static String dataControl;
        public static String dataControlChild;
        public static String unsupportedObject;
        public static String notUsed;
        public static String usedInPageDefinition;
        public static String unableToComputeUsage;

        static {
            NLS.initializeMessages((String)PageDefinitionObjectDetailsPage.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

