/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ManagedBeanFromSessionBeanPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ServiceDefinitionUtil;
import oracle.eclipse.tools.common.operations.DeleteFileOperation;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NewManagedBeanFromSessionBeanWizard
extends DataModelWizard {
    private static final String MB_FROM_SB_PAGE_NAME = "ManagedBeanFromSessionBeanPage";
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.view.ui.NewManagedBeanFromSessionBeanWizard";
    private ManagedBeanFromSessionBeanPage mbFromSessionPage;
    private final boolean allowOverwrite;
    DataWizardModel wizardModel = new DataWizardModel();

    public NewManagedBeanFromSessionBeanWizard() {
        this(false);
    }

    public NewManagedBeanFromSessionBeanWizard(boolean allowOverwrite) {
        this.setWindowTitle(Messages.NewManagedBeanFromSessionBeanWizard_windowTitle);
        this.allowOverwrite = allowOverwrite;
    }

    public void addPages() {
        this.mbFromSessionPage = new ManagedBeanFromSessionBeanPage(MB_FROM_SB_PAGE_NAME, this.allowOverwrite, HELP_CONTEXT_ID);
        this.mbFromSessionPage.setSelection(this.getSelection());
        this.addPage((IWizardPage)this.mbFromSessionPage);
    }

    public boolean canFinish() {
        return this.mbFromSessionPage.isPageComplete();
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewManagedBeanFromSessionBeanWizard.this.doFinish(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Activator.log(realException);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewManagedBeanFromSessionBeanWizard_genManagedBeanTaskError, (String)realException.getMessage());
            return false;
        }
        IFile file = this.getFile();
        if (file != null) {
            NewManagedBeanFromSessionBeanWizard.openEditor(this.getShell(), file);
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor) throws ExecutionException {
        IServiceDefinition mbServiceDefn;
        IServiceDefinitionInfo mbAppSpecModel;
        IStatus status;
        monitor.beginTask(Messages.NewManagedBeanFromSessionBeanWizard_genManagedBeanTask, 1);
        IFile file = this.getExistingFile();
        if (this.allowOverwrite && file != null) {
            DeleteFileOperation deleteFileOperation = new DeleteFileOperation(file);
            deleteFileOperation.execute(monitor, null);
        }
        if ((status = NewADFDataModelComponentsWizard.generateBeans(null, null, mbAppSpecModel = ServiceDefinitionUtil.createSBAndMBServiceDefinitionInfo(mbServiceDefn = ServiceDefinitionUtil.createBasicServiceDefn(this.wizardModel.getSessionBeanSD()), this.wizardModel), this.wizardModel.getWebProjSrcFolderName(), EnumSet.of(IGenerationContextFactory.GenerationOption.MANAGED_BEAN), monitor)) != null && status.getSeverity() == 4) {
            this.openStatusDialog(this.getShell(), Messages.NewManagedBeanFromSessionBeanWizard_genManagedBeanTaskError, status);
            return;
        }
        monitor.worked(1);
    }

    private IFile getFile() {
        IFile file = this.getExistingFile();
        if (file == null) {
            return this.getSelectionAsFile();
        }
        return file;
    }

    private IFile getExistingFile() {
        if (this.wizardModel.getJpaProjectName() != null) {
            IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.wizardModel.getWebProjectName());
            String managedBeanName = this.wizardModel.getManagedBeanName();
            String packageName = this.wizardModel.getManagedBeanPackageName();
            if (managedBeanName != null) {
                StringBuilder classname = new StringBuilder();
                if (packageName != null && !packageName.isEmpty()) {
                    classname.append(packageName);
                    classname.append('.');
                }
                classname.append(managedBeanName);
                IFile sourceFile = JavaUtil.getExistingJavaFile((IProject)webProject, (String)classname.toString());
                if (sourceFile != null) {
                    return sourceFile;
                }
            }
        }
        return null;
    }
}

