/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinitionInfo;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaServiceEntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaServiceInputPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ServiceDefinitionUtil;
import oracle.eclipse.tools.adf.view.ui.util.JavaUtils;
import oracle.eclipse.tools.common.services.appgen.generators.IGenerationContextFactory;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewJavaServiceFromEntitiesWizard
extends DataModelWizard {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.adf.view.ui.NewJavaServiceFromEntitiesWizard";
    private static final String HELP_CONTEXT_ID_EDIT = "oracle.eclipse.tools.adf.view.ui.EditJavaServiceFromEntitiesWizard";
    static final String PAGE_ENTITIES_SELECTION = "EntitiesSelection";
    static final String PAGE_JAVA_SERVICE_INPUT = "JavaServiceInputPage";
    DataWizardModel wizardModel = new DataWizardModel();
    private JavaServiceInputPage inputPage;
    private JavaServiceEntitiesSelectionPage entitiesSelectionPage;
    private boolean isEditWizard = false;

    public NewJavaServiceFromEntitiesWizard() {
        this.setWindowTitle(Messages.NewJavaServiceFromEntitiesWizard_title);
    }

    public void setIsEditWizard(boolean b) {
        this.isEditWizard = b;
        if (b) {
            this.setWindowTitle(Messages.NewJavaServiceFromEntitiesWizard_editJavaServiceWindowTitle);
        }
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object o;
        IJavaElement javaElem;
        super.init(workbench, selection);
        if (this.isEditWizard && selection != null && (javaElem = JavaUtils.getJavaElement(o = selection.getFirstElement())) instanceof ICompilationUnit) {
            String name;
            ICompilationUnit cu = (ICompilationUnit)javaElem;
            int index = (name = cu.getElementName()).indexOf(46);
            this.wizardModel.setSessionBeanName(name.substring(0, index != -1 ? index : name.length()));
            IJavaElement javaElementParent = cu.getParent();
            if (javaElementParent instanceof IPackageFragment) {
                String pkg = ((IPackageFragment)javaElementParent).getElementName();
                this.wizardModel.setSessionBeanPackageName(pkg);
            }
        }
    }

    public void addPages() {
        String helpContext = HELP_CONTEXT_ID;
        if (this.isEditWizard) {
            helpContext = HELP_CONTEXT_ID_EDIT;
        }
        IDataModel dataModel = this.createDataModel();
        this.wizardModel.setDataModel(dataModel);
        this.inputPage = new JavaServiceInputPage(dataModel, PAGE_JAVA_SERVICE_INPUT, this.getSelection(), this.isEditWizard, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.inputPage);
        this.entitiesSelectionPage = new JavaServiceEntitiesSelectionPage(PAGE_ENTITIES_SELECTION, this.isEditWizard, false, this.getSelection(), helpContext);
        this.addPage((IWizardPage)this.entitiesSelectionPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.inputPage) {
            return false;
        }
        if (currentPage == this.entitiesSelectionPage) {
            return ((EntitiesSelectionPage)currentPage).isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewJavaServiceFromEntitiesWizard.this.doFinish(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            LoggingService.logException((String)"oracle.eclipse.tools.adf.view.ui", (Throwable)realException);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewJavaServiceFromEntitiesWizard_javaServiceGenError, (String)realException.getMessage());
            return false;
        }
        IFile file = this.getFile();
        if (file != null) {
            NewJavaServiceFromEntitiesWizard.openEditor(this.getShell(), file);
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException {
        if (this.isEditWizard) {
            IStatus status = this.saveExistingServiceDefnAndGenBeans(monitor);
            if (status != null && status.getSeverity() == 4) {
                this.openStatusDialog(this.getShell(), Messages.NewJavaServiceFromEntitiesWizard_javaServiceGenError, status);
                return;
            }
        } else {
            IStatus status = this.createNewServiceDefnAndGenBeans(monitor);
            if (status != null && status.getSeverity() == 4) {
                this.openStatusDialog(this.getShell(), Messages.NewJavaServiceFromEntitiesWizard_javaServiceGenError, status);
            }
        }
    }

    private IStatus saveExistingServiceDefnAndGenBeans(IProgressMonitor pm) throws CoreException {
        IServiceDefinitionInfo sbAppSpecModel;
        IGenerationContextFactory contextFactory;
        IStatus status;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (String)Messages.NewJavaServiceFromEntitiesWizard_mainTaskLabel, (int)3);
        IServiceDefinition serviceDefn = this.entitiesSelectionPage.getServiceDefinition();
        if (serviceDefn == null) {
            Status status2 = new Status(4, "oracle.eclipse.tools.adf.view.ui", "Program Error: Service definition is null");
            CoreException ce = new CoreException((IStatus)status2);
            throw ce;
        }
        IFile beanFile = this.getFile();
        String srcFolderName = null;
        IFolder srcFolder = JavaUtil.getSourceFolder((IFile)beanFile);
        if (srcFolder != null) {
            srcFolderName = srcFolder.getProjectRelativePath().toString();
        }
        if (!(status = NewADFDataModelComponentsWizard.validateEdit(contextFactory = NewADFDataModelComponentsWizard.createGenerationContextFactory(sbAppSpecModel = ServiceDefinitionUtil.createSBServiceDefinitionInfo(serviceDefn, this.wizardModel), srcFolderName, null, null, EnumSet.of(IGenerationContextFactory.GenerationOption.JAVA_SERVICE)))).isOK()) {
            return status;
        }
        status = NewADFDataModelComponentsWizard.generateBeansFromContextFactory(contextFactory, (IProgressMonitor)monitor.newChild(1));
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        NewADFDataModelComponentsWizard.saveFile(contextFactory, (IProgressMonitor)monitor.newChild(1));
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    private IStatus createNewServiceDefnAndGenBeans(IProgressMonitor pm) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (String)Messages.NewJavaServiceFromEntitiesWizard_mainTaskLabel, (int)2);
        IServiceDefinition serviceDefn = ServiceDefinitionUtil.createBasicServiceDefn(this.wizardModel);
        monitor.subTask(Messages.NewJavaServiceFromEntitiesWizard_subtaskLabel);
        IServiceDefinitionInfo sbSDInfo = ServiceDefinitionUtil.createSBServiceDefinitionInfo(serviceDefn, this.wizardModel);
        IStatus status = NewADFDataModelComponentsWizard.generateBeans(sbSDInfo, this.wizardModel.getJpaProjSrcFolderName(), null, null, EnumSet.of(IGenerationContextFactory.GenerationOption.JAVA_SERVICE), (IProgressMonitor)monitor.newChild(1));
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    private IFile getFile() {
        if (this.wizardModel.getJpaProjectName() != null) {
            IProject jpaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.wizardModel.getJpaProjectName());
            String sessionBeanName = this.wizardModel.getSessionBeanName();
            String packageName = this.wizardModel.getSessionBeanPackageName();
            if (sessionBeanName != null) {
                StringBuilder classname = new StringBuilder();
                if (packageName != null && !packageName.isEmpty()) {
                    classname.append(packageName);
                    classname.append('.');
                }
                classname.append(sessionBeanName);
                IFile sourceFile = JavaUtil.getExistingJavaFile((IProject)jpaProject, (String)classname.toString());
                if (sourceFile != null) {
                    return sourceFile;
                }
            }
        }
        return this.getSelectionAsFile();
    }
}

