/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.view.appgen.appspec.IServiceDefinition;
import oracle.eclipse.tools.adf.view.appgen.utils.SessionBeanUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.AbstractWizardPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataModelWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.JavaClassInputComposite;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewManagedBeanFromSessionBeanWizard;
import oracle.eclipse.tools.adf.view.ui.util.JavaUtils;
import oracle.eclipse.tools.common.services.ui.dependency.ArtifactNavigationContentProvider;
import oracle.eclipse.tools.common.services.util.JPAUtils;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ManagedBeanFromSessionBeanPage
extends AbstractWizardPage
implements PropertyChangeListener {
    private static final int HORIZONTAL_OFFSET_RIGHT = -79;
    private static final int VERTICAL_GAP = 8;
    private final List<IProject> jpaProjects = new ArrayList<IProject>();
    private Label lblProject;
    private ComboViewer jpaProjectViewer;
    private ComboViewer sessionBeanViewer;
    private JavaClassInputComposite javaClassComp;
    private List<IProject> webProjects;
    private ISelectionChangedListener jpaProjectViewerListener;
    private ISelectionChangedListener sessionBeanSelectionChangedListener;
    private MouseTrackListener sessionBeanMouseTrackListener;
    private FocusListener sessionBeanFocusListener;
    private IProject selectionProject;
    private IProject currentJpaProject;
    private SessionBeanUtil.GeneratedSessionBean currentSessionBean;
    private final boolean allowOverwrite;
    public static final IProjectFacet WEB_MODULE_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");

    public ManagedBeanFromSessionBeanPage(String pageName, boolean allowOverwrite, String helpContextID) {
        super(pageName, helpContextID);
        this.setTitle(Messages.ManagedBeanFromSessionBeanPage_title);
        this.setDescription(Messages.ManagedBeanFromSessionBeanPage_description);
        this.allowOverwrite = allowOverwrite;
    }

    public void createControl(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        this.setControl((Control)parentComposite);
        if (this.helpContextID != null) {
            IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
            help.setHelp((Control)parentComposite, this.helpContextID);
        }
        parentComposite.setLayout((Layout)new FormLayout());
        this.lblProject = new Label(parentComposite, 0);
        this.lblProject.setText(Messages.ManagedBeanFromSessionBeanPage_labelModelProject);
        FormData fd_lblJPAProject = new FormData();
        fd_lblJPAProject.top = new FormAttachment(0, 10);
        fd_lblJPAProject.left = new FormAttachment(0, 10);
        this.lblProject.setLayoutData((Object)fd_lblJPAProject);
        this.jpaProjectViewer = new ComboViewer(parentComposite);
        FormData fd_projectViewer = new FormData();
        fd_projectViewer.top = new FormAttachment((Control)this.lblProject, 0, 0x1000000);
        fd_projectViewer.left = new FormAttachment((Control)this.lblProject, 10);
        fd_projectViewer.right = new FormAttachment(100, -79);
        this.jpaProjectViewer.getControl().setLayoutData((Object)fd_projectViewer);
        this.jpaProjectViewer.setContentProvider((IContentProvider)new JavaClassInputComposite.ProjectListContentProvider());
        this.jpaProjectViewer.setLabelProvider((IBaseLabelProvider)new JavaClassInputComposite.ProjectListLabelProvider());
        this.sessionBeanViewer = new ComboViewer(parentComposite);
        Label lblSessionBean = new Label(parentComposite, 0);
        lblSessionBean.setText(Messages.ManagedBeanFromSessionBeanPage_labelSessionBean);
        FormData fd_lblSessionBean = new FormData();
        fd_lblSessionBean.top = new FormAttachment(this.sessionBeanViewer.getControl(), 0, 0x1000000);
        fd_lblSessionBean.left = new FormAttachment((Control)this.lblProject, 0, 16384);
        lblSessionBean.setLayoutData((Object)fd_lblSessionBean);
        FormData fd_sessionBeanViewer = new FormData();
        fd_sessionBeanViewer.top = new FormAttachment(this.jpaProjectViewer.getControl(), 8);
        fd_sessionBeanViewer.left = new FormAttachment(this.jpaProjectViewer.getControl(), 0, 16384);
        fd_sessionBeanViewer.right = new FormAttachment(this.jpaProjectViewer.getControl(), 0, 131072);
        this.sessionBeanViewer.getControl().setLayoutData((Object)fd_sessionBeanViewer);
        this.sessionBeanViewer.setContentProvider((IContentProvider)new SessionBeanListContentProvider());
        this.sessionBeanViewer.setLabelProvider((IBaseLabelProvider)new SessionBeanListLabelProvider());
        Label seperator = new Label(parentComposite, 258);
        FormData fd_seperator = new FormData();
        fd_seperator.top = new FormAttachment(this.sessionBeanViewer.getControl(), 10);
        fd_seperator.left = new FormAttachment(0, 10);
        fd_seperator.right = new FormAttachment(100, -10);
        seperator.setLayoutData((Object)fd_seperator);
        this.javaClassComp = this.getJavaClassInputComposite(parentComposite);
        this.javaClassComp.setProjectLabel(Messages.BindingTypeComposite_projectLabel);
        this.javaClassComp.addPropertyChangeListener(this);
        FormData fd_javaClassComp = new FormData();
        fd_javaClassComp.top = new FormAttachment((Control)seperator, 5);
        fd_javaClassComp.left = new FormAttachment(0, 0);
        fd_javaClassComp.right = new FormAttachment(100, 0);
        this.javaClassComp.setLayoutData(fd_javaClassComp);
        parentComposite.setTabList(new Control[]{this.jpaProjectViewer.getControl(), this.sessionBeanViewer.getControl(), this.javaClassComp});
        this.init();
        this.jpaProjectViewer.getControl().setFocus();
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        IStatus status = this.getStatus();
        if (status == null || status.getSeverity() != 4) {
            this.saveDataToModel();
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateStatus();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ISelection selection = this.javaClassComp.projectViewer.getSelection();
            if (selection == null || selection.isEmpty()) {
                this.javaClassComp.projectViewer.getControl().setFocus();
            } else {
                String pkg = this.javaClassComp.textJavaPkg.getText();
                if (pkg == null || pkg.isEmpty()) {
                    this.javaClassComp.textJavaPkg.setFocus();
                } else {
                    this.javaClassComp.classNameText.selectAll();
                    this.javaClassComp.classNameText.setFocus();
                }
            }
        }
    }

    void setSelection(IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        if (o instanceof IFile) {
            this.currentSessionBean = SessionBeanUtil.getGeneratedSessionBean((IFile)((IFile)o));
        }
        if (o instanceof IResource) {
            this.selectionProject = ((IResource)o).getProject();
        }
        if (this.selectionProject == null && o instanceof IAdaptable) {
            this.selectionProject = (IProject)((IAdaptable)o).getAdapter(IProject.class);
        }
        if (this.selectionProject == null && o instanceof ArtifactNavigationContentProvider.IProjectScopeArtifactCategory) {
            this.selectionProject = ((ArtifactNavigationContentProvider.IProjectScopeArtifactCategory)o).getProject();
        }
        for (JpaProject jpaProj : JPAUtils.getJpaProjects((IProject)this.selectionProject)) {
            this.jpaProjects.add(jpaProj.getProject());
        }
        this.webProjects = ProjectUtils.getWebProjects((IProject)this.selectionProject);
    }

    @Override
    protected IStatus getStatus() {
        IStructuredSelection ss = (IStructuredSelection)this.jpaProjectViewer.getSelection();
        if (ss.getFirstElement() == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_emptyModelProject, null);
        }
        IProject modelProject = (IProject)ss.getFirstElement();
        IStatus modelProjStatus = this.evaluateModelProject(modelProject);
        if (modelProjStatus != null && modelProjStatus.getSeverity() == 4) {
            return modelProjStatus;
        }
        Object[] elements = ((IStructuredContentProvider)this.sessionBeanViewer.getContentProvider()).getElements(null);
        if (elements == null || elements.length == 0) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_noSessionBeanError, null);
        }
        ss = (IStructuredSelection)this.sessionBeanViewer.getSelection();
        if (ss.getFirstElement() == null) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_emptySessionBeanError, null);
        }
        List viewerInput = (List)this.javaClassComp.projectViewer.getInput();
        if (viewerInput == null || viewerInput.size() == 0) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_noWebProjectsError, null);
        }
        IStatus javaClassStatus = this.javaClassComp.validate("oracle.eclipse.tools.adf.view.ui", Messages.JavaClassInputComposite_selectWebProjectError);
        if (javaClassStatus != null && javaClassStatus.getSeverity() == 4) {
            return javaClassStatus;
        }
        if (modelProjStatus != null && modelProjStatus.getSeverity() == 2) {
            return modelProjStatus;
        }
        return javaClassStatus;
    }

    private IStatus evaluateModelProject(IProject project) {
        IFacetedProject facetedProject;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_emptyModelProject, null);
        }
        if (facetedProject != null && facetedProject.hasProjectFacet(WEB_MODULE_FACET)) {
            return new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_invalidModelProject, null);
        }
        return null;
    }

    private void saveDataToModel() {
        DataWizardModel wizardModel = ((NewManagedBeanFromSessionBeanWizard)this.getWizard()).wizardModel;
        this.javaClassComp.saveDataToWizardModel(wizardModel, true);
        IStructuredSelection ss = (IStructuredSelection)this.jpaProjectViewer.getSelection();
        IProject project = (IProject)ss.getFirstElement();
        wizardModel.setJpaProjectName(project.getName());
        ss = (IStructuredSelection)this.sessionBeanViewer.getSelection();
        SessionBeanUtil.GeneratedSessionBean genSessionBean = (SessionBeanUtil.GeneratedSessionBean)ss.getFirstElement();
        if (!(project == null || genSessionBean == null || genSessionBean.equals((Object)this.currentSessionBean) && wizardModel.getSessionBeanName() != null)) {
            IServiceDefinition sbSD = SessionBeanUtil.getServiceDefinition((IProject)project, (SessionBeanUtil.GeneratedSessionBean)genSessionBean);
            if (sbSD != null) {
                wizardModel.setSessionBeanSD(sbSD);
            }
            String name = genSessionBean.getSessionBean().getEjbClass();
            wizardModel.setSessionBeanName(ClassUtil.getClassName((String)name));
            wizardModel.setSessionBeanPackageName(ClassUtil.getPackageName((String)name));
            this.currentSessionBean = genSessionBean;
        }
    }

    private void init() {
        this.jpaProjectViewer.setInput(this.jpaProjects);
        this.javaClassComp.setProjectInputAndSelection(this.webProjects, (ISelection)((DataModelWizard)this.getWizard()).getSelection());
        this.setInitialSelections();
        this.finalInitialStatusCheck();
        this.createListeners();
        this.addListeners();
    }

    private void setInitialSelections() {
        JpaProject jpaPr;
        this.currentJpaProject = null;
        if (this.jpaProjects.size() == 1) {
            this.currentJpaProject = this.jpaProjects.get(0);
        } else if (this.jpaProjects.size() > 1 && (jpaPr = (JpaProject)this.selectionProject.getAdapter(JpaProject.class)) != null) {
            this.currentJpaProject = jpaPr.getProject();
        }
        if (this.currentJpaProject != null) {
            this.jpaProjectViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentJpaProject), true);
            this.sessionBeanViewer.setInput(ManagedBeanFromSessionBeanPage.getGeneratedSessionBeans(this.currentJpaProject));
            if (this.currentSessionBean != null) {
                this.sessionBeanViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentSessionBean), true);
            }
        } else {
            this.jpaProjectViewer.setSelection((ISelection)new StructuredSelection(), true);
            this.sessionBeanViewer.setInput(new ArrayList());
            this.sessionBeanViewer.setSelection((ISelection)new StructuredSelection(), true);
        }
        if (this.webProjects.size() == 1) {
            this.javaClassComp.projectViewer.setSelection((ISelection)new StructuredSelection((Object)this.webProjects.get(0)));
        } else if (this.webProjects.size() > 1 && ProjectUtils.isWebProject((IProject)this.selectionProject)) {
            this.javaClassComp.projectViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectionProject));
        }
    }

    private void finalInitialStatusCheck() {
        Status status = null;
        if (this.webProjects == null || this.webProjects.size() == 0) {
            status = new Status(4, "oracle.eclipse.tools.adf.view.ui", 0, Messages.ManagedBeanFromSessionBeanPage_noWebProjectsError, null);
        }
        this.applyToStatusLine((IStatus)status);
    }

    private void createListeners() {
        this.jpaProjectViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection newSelection = (IStructuredSelection)event.getSelection();
                if (newSelection.getFirstElement() != null) {
                    IProject selectedProject = (IProject)newSelection.getFirstElement();
                    if (!selectedProject.equals((Object)ManagedBeanFromSessionBeanPage.this.currentJpaProject)) {
                        ManagedBeanFromSessionBeanPage.this.currentJpaProject = selectedProject;
                        ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.removeSelectionChangedListener(ManagedBeanFromSessionBeanPage.this.sessionBeanSelectionChangedListener);
                        ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.setInput((Object)ManagedBeanFromSessionBeanPage.getGeneratedSessionBeans(ManagedBeanFromSessionBeanPage.this.currentJpaProject));
                        ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.setSelection((ISelection)new StructuredSelection(), true);
                        ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.addSelectionChangedListener(ManagedBeanFromSessionBeanPage.this.sessionBeanSelectionChangedListener);
                    }
                } else {
                    ManagedBeanFromSessionBeanPage.this.currentJpaProject = null;
                    ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.removeSelectionChangedListener(ManagedBeanFromSessionBeanPage.this.sessionBeanSelectionChangedListener);
                    ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.setInput(new ArrayList());
                    ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.setSelection((ISelection)new StructuredSelection(), true);
                    ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.addSelectionChangedListener(ManagedBeanFromSessionBeanPage.this.sessionBeanSelectionChangedListener);
                }
                ManagedBeanFromSessionBeanPage.this.updateStatus();
            }
        };
        this.sessionBeanSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ManagedBeanFromSessionBeanPage.this.updateStatus();
            }
        };
        this.sessionBeanMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                IStructuredSelection selection;
                if (ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.getControl().getToolTipText() == null && (selection = (IStructuredSelection)ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.getSelection()).getFirstElement() != null) {
                    SessionBeanUtil.GeneratedSessionBean genSessionBean = (SessionBeanUtil.GeneratedSessionBean)selection.getFirstElement();
                    ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.getControl().setToolTipText(genSessionBean.getSessionBean().getEjbClass());
                }
            }

            public void mouseExit(MouseEvent e) {
                ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.getControl().setToolTipText(null);
            }

            public void mouseHover(MouseEvent e) {
            }
        };
        this.sessionBeanFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ManagedBeanFromSessionBeanPage.this.sessionBeanViewer.getControl().setToolTipText(null);
            }
        };
    }

    private void addListeners() {
        this.jpaProjectViewer.addSelectionChangedListener(this.jpaProjectViewerListener);
        this.sessionBeanViewer.addSelectionChangedListener(this.sessionBeanSelectionChangedListener);
        this.sessionBeanViewer.getControl().addMouseTrackListener(this.sessionBeanMouseTrackListener);
        this.sessionBeanViewer.getControl().addFocusListener(this.sessionBeanFocusListener);
    }

    private JavaClassInputComposite getJavaClassInputComposite(Composite parentComposite) {
        if (this.allowOverwrite) {
            return new JavaClassInputComposite(parentComposite, 0){

                @Override
                IStatus validateCanCreateType(IJavaProject project, String srcFolder, String packageName, String typeName) {
                    IStatus pkgClassStatus = JavaUtils.typeAlreadyExists(project, srcFolder, packageName, typeName);
                    if (pkgClassStatus != null && pkgClassStatus.getSeverity() == 4) {
                        String baseMessage = pkgClassStatus.getMessage();
                        String message = NLS.bind((String)Messages.ManagedBeanFromSessionBeanPage_fileExistsOverwrite, (Object[])new Object[]{baseMessage});
                        Status warningPkgClassStatus = new Status(2, "oracle.eclipse.tools.adf.view.ui", 0, message, null);
                        return warningPkgClassStatus;
                    }
                    return JavaUtils.typeExistsDifferentCase(project, srcFolder, packageName, typeName);
                }
            };
        }
        return new JavaClassInputComposite(parentComposite, 0);
    }

    private static List<SessionBeanUtil.GeneratedSessionBean> getGeneratedSessionBeans(IProject project) {
        List beans = SessionBeanUtil.getGeneratedSessionBeans((IProject)project);
        Collections.sort(beans, new Comparator<SessionBeanUtil.GeneratedSessionBean>(){

            @Override
            public int compare(SessionBeanUtil.GeneratedSessionBean bean1, SessionBeanUtil.GeneratedSessionBean bean2) {
                String name1 = ClassUtil.getClassName((String)bean1.getSessionBean().getEjbClass());
                String name2 = ClassUtil.getClassName((String)bean2.getSessionBean().getEjbClass());
                return name1.compareTo(name2);
            }
        });
        return beans;
    }

    private static class SessionBeanListContentProvider
    implements IStructuredContentProvider {
        List<SessionBeanUtil.GeneratedSessionBean> contentList = new ArrayList<SessionBeanUtil.GeneratedSessionBean>();

        private SessionBeanListContentProvider() {
        }

        public void dispose() {
            this.contentList = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contentList = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.contentList == null) {
                return new ArrayList().toArray();
            }
            return this.contentList.toArray();
        }
    }

    private static class SessionBeanListLabelProvider
    extends LabelProvider {
        private SessionBeanListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SessionBeanUtil.GeneratedSessionBean) {
                SessionBeanUtil.GeneratedSessionBean bean = (SessionBeanUtil.GeneratedSessionBean)element;
                String name = bean.getSessionBean().getEjbClass();
                return ClassUtil.getClassName((String)name);
            }
            return "";
        }
    }
}

