/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.appgen.utils.JavaServiceUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.DataWizardModel;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.EntitiesSelectionPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.ManagedBeanInputPage;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewADFDataModelComponentsWizard;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel.NewJavaServiceFromEntitiesWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;

public class JavaServiceEntitiesSelectionPage
extends EntitiesSelectionPage {
    private final List<String> existingEntityNames = new ArrayList<String>();
    private boolean hasNextPage;
    private IStatus infoStatus = null;

    JavaServiceEntitiesSelectionPage(String pageName, boolean editWizard, boolean hasNextPage, IStructuredSelection selection, String helpContextID) {
        super(pageName, helpContextID);
        this.hasNextPage = hasNextPage;
        this.setDescription(Messages.JavaServiceEntitiesSelectionPage_description);
        if (editWizard) {
            this.computeServiceDefn(selection);
            this.infoStatus = new Status(1, "oracle.eclipse.tools.common.services", Messages.JavaServiceEntitiesSelectionPage_overwriteExisting);
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        if (this.hasNextPage) {
            ManagedBeanInputPage managedBeanPage = (ManagedBeanInputPage)this.getWizard().getPage("ManagedBeanInputPage");
            managedBeanPage.initialize();
            return managedBeanPage;
        }
        return null;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.hasNextPage) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    boolean hasEntitiesChanged() {
        boolean found;
        DataWizardModel wizardModel = this.getDataWizardModel();
        List<String> entities = wizardModel.getSelectedEntities();
        if (this.existingEntityNames.size() != entities.size()) {
            return true;
        }
        for (String entityName : entities) {
            found = false;
            for (String name : this.existingEntityNames) {
                if (!entityName.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        for (String name : this.existingEntityNames) {
            found = false;
            for (String entityName : entities) {
                if (!name.equals(entityName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveDataToModel() {
        DataWizardModel wizardModel = this.getDataWizardModel();
        if (wizardModel != null) {
            wizardModel.setSelectedEntities(this.entitiesComposite.getSelectedEntities());
        }
        if (this.serviceDefinition != null) {
            this.serviceDefinition.removeAllEntities();
            for (String entityName : this.entitiesComposite.getSelectedEntities()) {
                this.serviceDefinition.addEntityName(entityName);
            }
        }
    }

    @Override
    protected IStatus getStatus() {
        IStatus status = super.getStatus();
        if (status == null) {
            return this.infoStatus;
        }
        return status;
    }

    private void computeServiceDefn(IStructuredSelection selection) {
        if (selection != null) {
            Object o = selection.getFirstElement();
            if (!(o instanceof IFile)) {
                return;
            }
            IFile jsFile = (IFile)o;
            this.jpaProjectName = jsFile.getProject().getName();
            IType[] types = null;
            try {
                types = JavaServiceUtil.getTypes((IFile)jsFile);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            if (types != null) {
                this.serviceDefinition = JavaServiceUtil.reconstructServiceDefinition((IProject)jsFile.getProject(), (String)types[0].getFullyQualifiedName());
                if (this.serviceDefinition != null) {
                    for (String entityName : this.serviceDefinition.getEntityNames()) {
                        this.existingEntityNames.add(entityName);
                    }
                }
            }
        }
    }

    private DataWizardModel getDataWizardModel() {
        if (this.getWizard() instanceof NewADFDataModelComponentsWizard) {
            return ((NewADFDataModelComponentsWizard)this.getWizard()).wizardModel;
        }
        if (this.getWizard() instanceof NewJavaServiceFromEntitiesWizard) {
            return ((NewJavaServiceFromEntitiesWizard)this.getWizard()).wizardModel;
        }
        return null;
    }
}

