/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.datamodel;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public abstract class AbstractDataModelWizardPage
extends DataModelWizardPage {
    protected String helpContextID;

    protected AbstractDataModelWizardPage(IDataModel dataModel, String pageName, String helpContextID) {
        super(dataModel, pageName);
        this.helpContextID = helpContextID;
    }

    public boolean canFlipToNextPage() {
        IStatus status = this.getStatus();
        return status == null || status.getSeverity() != 4;
    }

    public final void performHelp() {
        if (this.helpContextID != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextID);
        }
    }

    protected abstract IStatus getStatus();

    protected void applyToStatusLine(IStatus status) {
        if (status == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return;
        }
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    protected void updateStatus() {
        IStatus status = this.getStatus();
        this.applyToStatusLine(status);
        this.getWizard().getContainer().updateButtons();
    }

    public static GridData gdhspan(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }
}

