/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.wizard.binding;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommandExecutorDelegator;
import oracle.eclipse.tools.adf.dtrt.context.command.IBindCommand;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IWidget;
import oracle.eclipse.tools.adf.dtrt.ui.command.IWizardCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.ui.context.manager.EMFDataBindingCommand;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.internal.wizard.binding.SelectDataControlWizardPage;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.WebPageContextManager;
import oracle.eclipse.tools.webtier.ui.tagdrop.AbstractTagDropWizardAdvisor;
import oracle.eclipse.tools.webtier.ui.tagdrop.ISupportTagDropTester;
import oracle.eclipse.tools.webtier.ui.tagdrop.TagDropWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class BindToAdfDataTagDropWizardAdvisor
extends AbstractTagDropWizardAdvisor {
    private final List<IWizardPage> pages = new ArrayList<IWizardPage>();
    private SelectDataControlWizardPage selectPage;
    private IDataControlObject dataControlObject;
    private IWidget widget;
    private IWebPageContext webPageContext;
    private IWizardCommandExecutor<IBindCommand> executor;

    public BindToAdfDataTagDropWizardAdvisor(TagDropWizard wizard) {
        super(wizard);
    }

    public IWebPageContext getWebPageContext() {
        HTMLEditor editor;
        if (this.webPageContext == null && (editor = DTRTViewUIUtil.findOpenEditor(this.getWizard().getFile())) != null) {
            this.webPageContext = (IWebPageContext)WebPageContextManager.getInstance().getContext((IWorkbenchPart)editor);
        }
        return this.webPageContext;
    }

    public void setDataControlObject(IDataControlObject dataControlObject) {
        this.dataControlObject = dataControlObject;
    }

    public IDataControlObject getDataControlObject() {
        return this.dataControlObject;
    }

    public void addPages() {
        this.selectPage = new SelectDataControlWizardPage("", this);
        this.addPage((IWizardPage)this.selectPage);
    }

    public void performFinish() {
        if (this.executor != null) {
            try {
                this.executor.performFinish(null);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                UIExceptionHandler.DEFAULT.handleException(e);
            }
        }
    }

    public String getWizardFieldsPageDescription() {
        return null;
    }

    public String getWizardConfigPageTitle() {
        return null;
    }

    public String getWizardConfigPageDescription() {
        return null;
    }

    public String getWizardConfigPageTableLabel() {
        return null;
    }

    public IFile getFile() {
        return this.getWizard().getFile();
    }

    public void reInitPages(IDataControlObject dataControlObject_) {
        TagIdentifier tagId;
        this.executor = (IWizardCommandExecutor)this.getWebPageContext().createCommandExecutor(IWizardCommandExecutor.class, IBindCommand.class);
        if (this.executor != null && (tagId = this.getWizard().getTagToDrop()) != null) {
            IWebPageContext.IBindPosition bindPosition = DTRTViewUIUtil.createBindPosition(this.getWizard().getPosition());
            this.widget = this.getWebPageContext().getCreateWidget(bindPosition, tagId.getUri(), tagId.getTagName(), dataControlObject_);
            if (this.widget != null) {
                ((IBindCommand)this.executor.getCommand()).setWidget(this.widget);
                final Node node = this.getWizard().getSelectionRoot();
                if (node instanceof IDOMNode) {
                    ICommandExecutorDelegator<IBindCommand> delegator = new ICommandExecutorDelegator<IBindCommand>(){

                        public void execute(IBindCommand command, IProgressMonitor monitor) throws InterruptedException, Exception {
                            IDOMModel model = ((IDOMNode)node).getModel();
                            EMFDataBindingCommand.executeDataBindCommand((IStructuredModel)model, (IBindCommand)command);
                        }
                    };
                    this.executor.setDelegator((ICommandExecutorDelegator)delegator);
                }
                this.clearPages();
                for (IWizardPage page : this.executor.createWizardPages()) {
                    this.addPage(page);
                }
            }
        }
    }

    protected void addPage(IWizardPage page) {
        if (this.getFirstPage() == null) {
            super.addPage(page);
        } else {
            this.pages.add(page);
            page.setWizard((IWizard)this.getWizard());
        }
    }

    private void clearPages() {
        this.pages.clear();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pArray = this.getPages();
        if (page instanceof TagDropWizard.PropertyEditorWizardPage && pArray.length > 0) {
            return pArray[0];
        }
        int i = 0;
        while (i < pArray.length) {
            if (pArray[i] == page) {
                if (i == pArray.length - 1) {
                    return null;
                }
                return pArray[++i];
            }
            ++i;
        }
        return null;
    }

    private IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public ISupportTagDropTester getSupportTagDropTester() {
        return new ISupportTagDropTester(){

            public boolean canSupportTagDrop(TagIdentifier tag) {
                IWebPageContext context = BindToAdfDataTagDropWizardAdvisor.this.getWebPageContext();
                return context != null && context.canBindOnCreation(tag.getUri(), tag.getTagName());
            }
        };
    }
}

