/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.launch.parameters;

import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameter;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameterList;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ParametersValidator
extends ValidationService {
    @Text(value="There is at least one required parameter without value.")
    private static LocalizableText missingRequiredError;
    private Listener listener;

    static {
        LocalizableText.init(ParametersValidator.class);
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ParametersValidator.this.refresh();
            }
        };
        IParameterList plist = (IParameterList)this.context(IParameterList.class);
        plist.attach(this.listener, "Parameters/Required");
        plist.attach(this.listener, "Parameters/Value");
    }

    protected Status compute() {
        ElementList parameters = (ElementList)this.context(ElementList.of(IParameter.class));
        for (IParameter parameter : parameters) {
            if (parameter.isRequired().content() != Boolean.TRUE || parameter.getValue().content() != null) continue;
            return Status.createErrorStatus((String)missingRequiredError.text());
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            IParameterList plist = (IParameterList)this.context(IParameterList.class);
            plist.detach(this.listener, "Parameters/Required");
            plist.detach(this.listener, "Parameters/Value");
        }
        super.dispose();
    }
}

