/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.launch.parameters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameter;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameterList;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Serialization;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.DerivedValueServiceData;

public final class ParameterUtil {
    @Text(value="<b>Date</b> parameter. The value must be a valid date that conforms to one of the following examples:{0}")
    private static LocalizableText dateFormats;

    static {
        LocalizableText.init(ParameterUtil.class);
    }

    private ParameterUtil() {
    }

    public static Class<? extends IParameter> getTypedParameter(String javaClass) {
        String string = javaClass = javaClass == null ? "" : javaClass.trim();
        return javaClass.length() == 0 ? IParameter.class : (String.class.getName().equals(javaClass) ? IParameter.IStringParameter.class : (BigDecimal.class.getName().equals(javaClass) ? IParameter.IBigDecimalParameter.class : (BigInteger.class.getName().equals(javaClass) ? IParameter.IBigIntegerParameter.class : (Boolean.class.getName().equals(javaClass) ? IParameter.IBooleanParameter.class : (Double.class.getName().equals(javaClass) ? IParameter.IDoubleParameter.class : (Float.class.getName().equals(javaClass) ? IParameter.IFloatParameter.class : (Integer.class.getName().equals(javaClass) ? IParameter.IIntegerParameter.class : (Long.class.getName().equals(javaClass) ? IParameter.ILongParameter.class : (URL.class.getName().equals(javaClass) ? IParameter.IURLParameter.class : (Byte.class.getName().equals(javaClass) ? IParameter.IByteParameter.class : (Date.class.getName().equals(javaClass) ? IParameter.IDateParameter.class : (Short.class.getName().equals(javaClass) ? IParameter.IShortParameter.class : IParameter.IUnknownTypeParameter.class))))))))))));
    }

    public static IParameter createParameter(IParameterList parameterList, String parameterType, String name, boolean required) {
        Class<? extends IParameter> cls = ParameterUtil.getTypedParameter(parameterType);
        IParameter parameter = (IParameter)parameterList.getParameters().insert(cls);
        parameter.setName(name);
        parameter.setRequired(required);
        if (parameter instanceof IParameter.IUnknownTypeParameter) {
            ((IParameter.IUnknownTypeParameter)parameter).setType(parameterType);
        }
        return parameter;
    }

    /*
     * WARNING - void declaration
     */
    private static String computeDateTypeDescription(ValueProperty property) {
        Date date = new Date();
        ArrayList<SimpleDateFormat> formats = new ArrayList<SimpleDateFormat>();
        Serialization serialization = (Serialization)property.getAnnotation(Serialization.class);
        if (serialization != null) {
            void var5_8;
            formats.add(new SimpleDateFormat(serialization.primary()));
            String[] stringArray = serialization.alternative();
            int n = stringArray.length;
            boolean n2 = false;
            while (var5_8 < n) {
                String alternative = stringArray[var5_8];
                formats.add(new SimpleDateFormat(alternative));
                ++var5_8;
            }
        }
        ArrayList<String> formattedValues = new ArrayList<String>(formats.size());
        for (DateFormat dateFormat : formats) {
            String formattedValue = dateFormat.format(date);
            if (formattedValues.contains(formattedValue)) continue;
            formattedValues.add(formattedValue);
        }
        Collections.sort(formattedValues);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>");
        for (String formattedValue : formattedValues) {
            stringBuilder.append("\n<li>").append(formattedValue).append("</li>");
        }
        stringBuilder.append("\n</ul>");
        return dateFormats.format(new Object[]{stringBuilder.toString()});
    }

    public static class DateTypeDescriptionProvider
    extends DerivedValueService {
        protected DerivedValueServiceData compute() {
            return new DerivedValueServiceData(ParameterUtil.computeDateTypeDescription(IParameter.IDateParameter.PROP_TYPED_VALUE));
        }
    }
}

