/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.controller.model.IADFView;
import oracle.eclipse.tools.adf.controller.model.IInputParameterDefinition;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchClient;
import oracle.eclipse.tools.adf.view.launch.TaskFlowLaunchUtil;
import oracle.eclipse.tools.adf.view.launch.ViewActivityData;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameter;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.IParameterList;
import oracle.eclipse.tools.adf.view.ui.internal.launch.parameters.ParameterUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.ui.internal.WebLaunchableClient;

public class UITaskFlowLaunchClient
extends TaskFlowLaunchClient {
    private static final String IMAGE_PAGE = "icons/oracle/adfdtinternal/view/rich/metadata/icons/page.png";
    private static Map<IFile, Object> lastViewActivitySelectionMap;
    private static Map<IFile, Map<String, String>> lastParameterValuesMap;

    public static synchronized void clearCachedValues() {
        try {
            if (lastViewActivitySelectionMap != null) {
                lastViewActivitySelectionMap.clear();
                lastViewActivitySelectionMap = null;
            }
            if (lastParameterValuesMap != null) {
                lastParameterValuesMap.clear();
                lastParameterValuesMap = null;
            }
        }
        catch (Exception exception) {}
    }

    protected IStatus launch(IServer server, HttpLaunchable httpLaunchable, String launchMode, ILaunch launch) {
        return new WebLaunchableClient().launch(server, (Object)httpLaunchable, launchMode, launch);
    }

    protected IADFView selectViewActivity(String launchMode, ITaskFlow taskFlow, IFile file, IPath webResourcePath, Collection<? extends IADFView> viewActivities) {
        String message;
        Object object;
        Object lastViewActivityId;
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                IADFView viewActivity = (IADFView)element;
                String label = (String)viewActivity.getDisplayName().content();
                if (label == null) {
                    label = (String)viewActivity.getActivityId().content();
                }
                return label;
            }

            public Image getImage(Object element) {
                return Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)UITaskFlowLaunchClient.IMAGE_PAGE).createImage();
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return selection.length == 1 && selection[0] instanceof IADFView ? new Status(0, "oracle.eclipse.tools.adf.view.ui", NLS.bind((String)Messages.pageLabel, (Object)((Path)((IADFView)selection[0]).getPage().content()).toString())) : new Status(4, "oracle.eclipse.tools.adf.view.ui", null);
            }
        };
        IADFView initialSelection = null;
        if (lastViewActivitySelectionMap != null && (lastViewActivityId = lastViewActivitySelectionMap.get(file)) instanceof String) {
            for (IADFView iADFView : viewActivities) {
                if (!lastViewActivityId.equals(iADFView.getActivityId().content())) continue;
                initialSelection = iADFView;
                break;
            }
        }
        if ((object = this.openSelectionDialog(launchMode, message = NLS.bind((String)Messages.selectView, (Object)TaskFlowLaunchUtil.getDisplayName((ITaskFlow)taskFlow, (IPath)webResourcePath)), (ILabelProvider)labelProvider, contentProvider, validator, viewActivities.toArray(), initialSelection)) instanceof IADFView) {
            if (lastViewActivitySelectionMap == null) {
                lastViewActivitySelectionMap = new HashMap<IFile, Object>();
            }
            IADFView viewActivity = (IADFView)object;
            lastViewActivitySelectionMap.put(file, viewActivity.getActivityId().content());
            return viewActivity;
        }
        return null;
    }

    protected ViewActivityData selectViewActivity(String launchMode, IFile file, Collection<? extends ViewActivityData> viewActivities) {
        Object ret;
        Object lastViewActivity;
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element instanceof ViewActivityData ? ((ViewActivityData)element).getId() : WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getText(element);
            }

            public Image getImage(Object element) {
                return element instanceof ViewActivityData ? Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)UITaskFlowLaunchClient.IMAGE_PAGE).createImage() : WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage(element);
            }
        };
        ITreeContentProvider contentProvider = new ITreeContentProvider(){
            private Map<IFile, List<ViewActivityData>> map;

            public void dispose() {
                this.map = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (this.map == null && newInput != null) {
                    Object[] input = (Object[])newInput;
                    this.map = new HashMap<IFile, List<ViewActivityData>>(input.length);
                    Object[] objectArray = input;
                    int n = input.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        ViewActivityData viewActivity = (ViewActivityData)obj;
                        IFile taskFlowFile = ((ViewActivityData)obj).getFile();
                        List<ViewActivityData> activities = this.map.get(taskFlowFile);
                        if (activities == null) {
                            activities = new ArrayList<ViewActivityData>();
                            this.map.put(taskFlowFile, activities);
                        }
                        activities.add(viewActivity);
                        ++n2;
                    }
                }
                if (viewer instanceof TreeViewer) {
                    ((TreeViewer)viewer).setAutoExpandLevel(2);
                }
            }

            public Object[] getElements(Object inputElement) {
                return this.map.keySet().toArray();
            }

            public Object getParent(Object element) {
                return element instanceof ViewActivityData ? ((ViewActivityData)element).getFile() : null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof IFile;
            }

            public Object[] getChildren(Object parentElement) {
                return this.map.get(parentElement).toArray();
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return selection.length != 1 ? new Status(4, "oracle.eclipse.tools.adf.view.ui", null) : (selection[0] instanceof ViewActivityData ? new Status(0, "oracle.eclipse.tools.adf.view.ui", null) : new Status(1, "oracle.eclipse.tools.adf.view.ui", ((IResource)selection[0]).getFullPath().toString()));
            }
        };
        Object[] input = viewActivities.toArray();
        contentProvider.inputChanged(null, null, (Object)input);
        ViewActivityData initialSelection = null;
        if (lastViewActivitySelectionMap != null && (lastViewActivity = lastViewActivitySelectionMap.get(file)) instanceof ViewActivityData) {
            initialSelection = (ViewActivityData)lastViewActivity;
        }
        if (initialSelection == null && viewActivities.size() == 1) {
            initialSelection = viewActivities.iterator().next();
        }
        if ((ret = this.openSelectionDialog(launchMode, Messages.getLaunchReferringViewMessage(launchMode), (ILabelProvider)labelProvider, contentProvider, validator, input, initialSelection)) instanceof ViewActivityData) {
            if (lastViewActivitySelectionMap == null) {
                lastViewActivitySelectionMap = new HashMap<IFile, Object>();
            }
            lastViewActivitySelectionMap.put(file, ret);
            return (ViewActivityData)ret;
        }
        return null;
    }

    private Object openSelectionDialog(String launchMode, String message, ILabelProvider labelProvider, ITreeContentProvider contentProvider, ISelectionStatusValidator validator, Object[] input, Object initialSelection) {
        final ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, labelProvider, contentProvider){

            protected void updateButtonsEnableState(IStatus status) {
                Button okButton = this.getOkButton();
                if (okButton != null && !okButton.isDisposed()) {
                    okButton.setEnabled(status.isOK());
                }
            }

            protected Label createMessageArea(Composite composite) {
                Label label = new Label(composite, 64);
                if (label.getParent().getLayout() instanceof GridLayout) {
                    GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)label);
                }
                if (this.getMessage() != null) {
                    label.setText(this.getMessage());
                    composite.layout();
                }
                label.setFont(composite.getFont());
                return label;
            }
        };
        dialog.setValidator(validator);
        dialog.setComparator(new ViewerComparator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.getLaunchTaskFlowMessage(launchMode));
        dialog.setMessage(message);
        dialog.setInput((Object)input);
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        final Object[] ret = new Object[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] result;
                    if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                        ret[0] = result[0];
                    }
                }
                catch (SWTException sWTException) {}
            }
        };
        UITaskFlowLaunchClient.runOnUIThread(runnable);
        return ret[0];
    }

    protected boolean setValues(String launchMode, IFile file, Map<IInputParameterDefinition, String> valuesMap) {
        IParameterList parameterList = (IParameterList)IParameterList.TYPE.instantiate();
        Map<String, String> lastValuesMap = lastParameterValuesMap != null ? lastParameterValuesMap.get(file) : null;
        HashMap<IParameter, IInputParameterDefinition> parametersMap = new HashMap<IParameter, IInputParameterDefinition>(valuesMap.size());
        for (IInputParameterDefinition inputParameterDefinition : valuesMap.keySet()) {
            IParameter parameter = ParameterUtil.createParameter(parameterList, inputParameterDefinition.getParameterClass().text(), (String)inputParameterDefinition.getName().content(), inputParameterDefinition.isRequired().content() == Boolean.TRUE);
            if (lastValuesMap != null) {
                parameter.setValue(lastValuesMap.get(parameter.getName().content()));
            }
            parametersMap.put(parameter, inputParameterDefinition);
        }
        if (!this.openParameterDialog(launchMode, parameterList)) {
            return false;
        }
        if (lastParameterValuesMap == null) {
            lastParameterValuesMap = new HashMap<IFile, Map<String, String>>();
        }
        lastValuesMap = new HashMap<String, String>(valuesMap.size());
        lastParameterValuesMap.put(file, lastValuesMap);
        for (IParameter parameter : parameterList.getParameters()) {
            IInputParameterDefinition inputParameterDefinition = (IInputParameterDefinition)parametersMap.get(parameter);
            String value = (String)parameter.getValue().content();
            valuesMap.put(inputParameterDefinition, value);
            if (value != null) {
                lastValuesMap.put((String)parameter.getName().content(), value);
                continue;
            }
            lastValuesMap.remove(parameter.getName().content());
        }
        return true;
    }

    private boolean openParameterDialog(String launchMode, IParameterList parameterList) {
        Display display = UITaskFlowLaunchClient.getDisplay();
        Shell shell = display.getActiveShell();
        final String title = Messages.getLaunchTaskFlowMessage(launchMode);
        final SapphireDialog dialog = new SapphireDialog(shell, parameterList, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).dialog()){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                this.getShell().setText(title);
                return control;
            }
        };
        final int[] ret = new int[]{100};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = dialog.open();
                }
                catch (Exception exception) {}
            }
        };
        UITaskFlowLaunchClient.runOnUIThread(display, runnable);
        return ret[0] == 0;
    }

    private static Display getDisplay() {
        try {
            return PlatformUI.getWorkbench().getDisplay();
        }
        catch (Exception exception) {
            Display display = Display.getCurrent();
            return display != null ? display : Display.getDefault();
        }
    }

    private static void runOnUIThread(Runnable runnable) {
        UITaskFlowLaunchClient.runOnUIThread(null, runnable);
    }

    private static void runOnUIThread(Display display, Runnable runnable) {
        if (display == null) {
            display = UITaskFlowLaunchClient.getDisplay();
        }
        if (Display.getCurrent() == null) {
            display.syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private static final class Messages
    extends NLS {
        public static String runTasKFlow;
        public static String debugTasKFlow;
        public static String profileTasKFlow;
        public static String launchTasKFlow;
        public static String runReferringView;
        public static String debugReferringView;
        public static String profileReferringView;
        public static String launchReferringView;
        public static String selectView;
        public static String pageLabel;

        static {
            Messages.initializeMessages((String)(String.valueOf(UITaskFlowLaunchClient.class.getName()) + "Ext"), Messages.class);
        }

        private Messages() {
        }

        public static String getLaunchTaskFlowMessage(String launchMode) {
            return "run".equals(launchMode) ? runTasKFlow : ("debug".equals(launchMode) ? debugTasKFlow : ("profile".equals(launchMode) ? profileTasKFlow : launchTasKFlow));
        }

        public static String getLaunchReferringViewMessage(String launchMode) {
            return "run".equals(launchMode) ? runReferringView : ("debug".equals(launchMode) ? debugReferringView : ("profile".equals(launchMode) ? profileReferringView : launchReferringView));
        }
    }
}

