/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.glassfish;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.adf.common.util.ADFGlassfishUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.server.core.IServer;
import org.osgi.framework.Bundle;

public class InstallADFEssentailsAction
implements IObjectActionDelegate,
IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String ADF_PLUGIN_ID = "oracle.eclipse.tools.adf";
    private static final String TEMPLATE_PATH = "/adf-essentials-glassfish-config/build.xml";
    private IServer server = null;
    IWorkbenchWindow window = null;

    public void run(IAction action) {
        String adfVersion = ADFGlassfishUtil.getInstalledADFVersion((IServer)this.server);
        if (adfVersion != null) {
            String msg = String.format("ADF Essential %s is already installed in the selected domain. Continue to configure domain JVM options for ADF application?", adfVersion);
            boolean ret = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)msg);
            if (ret) {
                this.configGlassfishDomain(null);
            }
            return;
        }
        FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
        dlg.setFilterExtensions(new String[]{"*.zip"});
        String path = dlg.open();
        if (path == null) {
            return;
        }
        File adf = new File(path);
        try {
            boolean isValid = false;
            ZipFile zip = new ZipFile(adf);
            Enumeration<? extends ZipEntry> itr = zip.entries();
            while (itr.hasMoreElements()) {
                ZipEntry zipentry = itr.nextElement();
                String name = zipentry.getName().toLowerCase();
                if (name.indexOf("jrf-api.jar") <= 0) continue;
                isValid = true;
            }
            if (!isValid) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Invalid ADF Essential installer file.");
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configGlassfishDomain(path);
    }

    private void configGlassfishDomain(String installerPath) {
        StringBuffer targets = new StringBuffer();
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (installerPath != null) {
            attribs.put("adfe_core_zip_path", installerPath);
            targets.append("install-adfe-core,");
        }
        if (this.server.getServerState() != 2) {
            targets.append("start-dev-domain,");
        }
        targets.append("configure-dev-domain-adfe,restart-dev-domain");
        this.runAntConfigScript(targets.toString(), attribs);
    }

    private void runAntConfigScript(String targets, Map<String, String> extrAttributes) {
        try {
            File domainPath = ADFGlassfishUtil.getDomainPath((IServer)this.server);
            File antScript = this.getGlassfishConfigAntScriptDir();
            ILaunchConfiguration lcfg = AntLaunchShortcut.createDefaultLaunchConfiguration((IPath)new Path(antScript.getAbsolutePath()), null);
            ILaunchConfigurationWorkingCopy copy = lcfg.getWorkingCopy();
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            copy.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("asinstall.dir", domainPath.getParentFile().getParentFile().getAbsolutePath());
            map.put("glassfish_domain", domainPath.getName());
            map.put("user", ADFGlassfishUtil.getAdmin((IServer)this.server));
            String adminPort = ADFGlassfishUtil.getAdminPort((IServer)this.server);
            map.put("glassfish_admin_port", adminPort == null ? "4848" : adminPort);
            String passwd = ADFGlassfishUtil.getPassword((IServer)this.server);
            if (passwd != null && passwd.trim().length() > 0) {
                File tempPasswd = File.createTempFile("oepe", null);
                FileUtil.writeFile((File)tempPasswd, (String)("AS_ADMIN_PASSWORD=" + passwd.trim()));
                map.put("passwordfile", tempPasswd.getAbsolutePath());
            }
            if (extrAttributes != null) {
                map.putAll(extrAttributes);
            }
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", map);
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
            lcfg = copy.doSave();
            DebugUITools.launch((ILaunchConfiguration)lcfg, (String)"run");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object o = sel.getFirstElement();
        if (o instanceof IServer) {
            this.server = (IServer)o;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window1) {
        this.window = window1;
    }

    public void init(IViewPart view) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public File getGlassfishConfigAntScriptDir() throws Exception {
        Bundle bundle = Platform.getBundle((String)ADF_PLUGIN_ID);
        Path path = new Path(TEMPLATE_PATH);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        URL templUrl = FileLocator.resolve((URL)url);
        File templDir = null;
        templDir = InstallADFEssentailsAction.extractFilesFromBundle(templUrl, bundle, TEMPLATE_PATH);
        if (templDir == null || !templDir.exists()) {
            throw new IOException("Failed to locate ANT build xml for Glassfish domain configuration.");
        }
        return templDir;
    }

    public static File extractFilesFromBundle(URL url, Bundle bundle, String path) throws Exception {
        Location configLocation = Platform.getConfigurationLocation();
        String pluginId = bundle.getSymbolicName();
        File configFolder = new File(configLocation.getURL().getFile(), pluginId);
        File antScript = new File(configFolder, path);
        if (!antScript.exists()) {
            InputStream inputStream = url.openConnection().getInputStream();
            FileUtil.writeFile((File)antScript, (InputStream)inputStream);
            inputStream.close();
        }
        return antScript;
    }
}

