/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.internal.bind;

import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.adf.view.ui.internal.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.bind.BindingSelectionValidator;
import oracle.eclipse.tools.adf.view.ui.wpe.dtrt.WebPageContextManager;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

abstract class AbstractBindingCommandHandler2
extends AbstractHandler {
    AbstractBindingCommandHandler2() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HTMLEditor htmlEditor = DTRTViewUIUtil.getActiveEditor();
        if (htmlEditor == null) {
            return null;
        }
        IFile webPageFile = DTRTUIUtil.getFile((IWorkbenchPart)htmlEditor);
        if (webPageFile == null) {
            return null;
        }
        IStatus writeableStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{webPageFile}, IWorkspace.VALIDATE_PROMPT);
        if (!writeableStatus.isOK()) {
            DialogService.showInfoDialog((String)Messages.DataControlBindingOperation_title, (String)Messages.DataControlBindingOperation_aborted);
            return null;
        }
        HTMLEditor part = DTRTViewUIUtil.findOpenEditor(webPageFile);
        IWebPageContext webPageContext = (IWebPageContext)WebPageContextManager.getInstance().getContext((IWorkbenchPart)part);
        if (webPageContext == null) {
            throw new ExecutionException("Unable to locate WebPageContext for selection.");
        }
        BindingSelectionValidator validator = Activator.getDefault().getSelectionValidator();
        IDOMNode node = validator.getRootNode();
        IDOMElement element = this.validateNode(webPageContext, (Node)node);
        if (element != null) {
            return this.doExecute(webPageContext, (IWorkbenchPart)part, element);
        }
        return Status.CANCEL_STATUS;
    }

    protected abstract IStatus doExecute(IWebPageContext var1, IWorkbenchPart var2, IDOMElement var3);

    protected abstract IDOMElement validateNode(IWebPageContext var1, Node var2);
}

