/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import java.util.ArrayList;
import java.util.Collections;
import oracle.eclipse.tools.adf.dtrt.ui.provider.CollectionContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DataControlWizardModel;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class TypePage
extends BaseWizardPage {
    private DataControlWizardModel model;
    private Label label;
    private TableViewer typeViewer;
    private Text typeDescriptionText;
    private boolean canCompletePage;

    public TypePage(DataControlWizardModel model) {
        super(TypePage.class.getSimpleName(), Messages.dcTypePageTitle, null);
        assert (model.getContext() != null);
        assert (model.getStructureSource() != null);
        this.model = model;
        this.setMessage(Messages.dcTypePageMessage);
    }

    public void dispose() {
        this.model = null;
        this.label = null;
        this.typeViewer = null;
        this.typeDescriptionText = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        this.label = new Label(composite, 64);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.label);
        this.typeViewer = new TableViewer(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)this.typeViewer.getControl());
        this.typeViewer.setContentProvider((IContentProvider)CollectionContentProvider.getDefault());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this.typeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TypePage.this.handleSelection(event.getSelection());
            }
        });
        this.typeDescriptionText = new Text(composite, 2626);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.typeDescriptionText).heightHint = 2 * DTRTUIUtil.getFontHeight((Control)this.typeDescriptionText);
        this.typeDescriptionText.setEditable(false);
    }

    protected void aboutToBecomeVisible(boolean firstTime) throws Exception {
        ArrayList dataControlTypes = this.model.getContext().getDataControlTypes(this.model.getStructureSource());
        if (dataControlTypes.isEmpty()) {
            this.canCompletePage = false;
            dataControlTypes = new ArrayList(this.model.getContext().getDataControlTypes());
            Collections.sort(dataControlTypes, DTRTUtil.COMPARATOR);
            this.typeViewer.setInput(dataControlTypes);
            this.setErrorMessage(Messages.noTypesForSourceMessage);
            this.label.setText(Messages.availableTypesLabel);
            DTRTUIUtil.controlChanged((Control)this.label);
        } else {
            Object element;
            this.canCompletePage = true;
            this.label.setText(Messages.selectTypeLabel);
            DTRTUIUtil.controlChanged((Control)this.label);
            this.typeViewer.setInput(dataControlTypes);
            if (this.model.getDataControlType() != null) {
                assert (dataControlTypes.contains(this.model.getDataControlType())) : this.model.getDataControlType();
                element = this.model.getDataControlType();
            } else {
                element = this.typeViewer.getElementAt(0);
            }
            assert (element != null);
            this.typeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    private void handleSelection(ISelection selection) {
        Object object = DTRTUIUtil.getFirstElement((ISelection)selection);
        if (object instanceof IDescribable) {
            IDescribable describable = (IDescribable)object;
            this.typeDescriptionText.setText(DTRTUtil.getToolTipText((IDescribable)describable));
            this.model.setDataControlType(describable);
        } else {
            this.typeDescriptionText.setText("");
        }
        this.setPageComplete(this.canCompletePage && this.model.getDataControlType() != null);
    }
}

