/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import oracle.eclipse.tools.adf.dtrt.ui.provider.ISummaryProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DataControlWizardModel;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class SummaryPage
extends BaseWizardPage {
    private DataControlWizardModel model;
    private Text summaryText;
    private Button showModifiedFilesButton;
    private Button showDataControlManagerButton;

    public SummaryPage(DataControlWizardModel model) {
        super(SummaryPage.class.getSimpleName(), Messages.summaryPageTitle, null);
        this.model = model;
        this.setMessage(Messages.summaryPageMessage);
    }

    public void dispose() {
        this.model = null;
        this.summaryText = null;
        this.showModifiedFilesButton = null;
        this.showDataControlManagerButton = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        this.summaryText = new Text(composite, 2626);
        DTRTUIUtil.applyGrabAllGridData((Control)this.summaryText);
        this.summaryText.setEditable(false);
        this.showModifiedFilesButton = new Button(composite, 32);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.showModifiedFilesButton);
        this.showModifiedFilesButton.setText(Messages.summaryPageShowModifiedFilesLabel);
        this.showModifiedFilesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SummaryPage.this.model.setShowModifiedFiles(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.showDataControlManagerButton = new Button(composite, 32);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.showDataControlManagerButton);
        this.showDataControlManagerButton.setText(Messages.summaryPageShowDataControlManagerLabel);
        this.showDataControlManagerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SummaryPage.this.model.setShowDataControlManagerOnFinish(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void aboutToBecomeVisible(boolean firstTime) {
        this.summaryText.setText(this.computeSummary());
        this.showModifiedFilesButton.setSelection(this.model.isShowModifiedFiles());
        this.showDataControlManagerButton.setSelection(this.model.isShowDataControlManagerOnFinish());
    }

    private String computeSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(NLS.bind((String)Messages.summaryProject, (Object)this.toSummaryString(this.getProjectName())));
        sb.append('\n').append(NLS.bind((String)Messages.summaryDataControlType, (Object)this.toSummaryString(DTRTUtil.getLabel((IDescribable)this.model.getDataControlType()))));
        sb.append('\n').append(NLS.bind((String)Messages.summaryDataControlSource, (Object)this.toSummaryString(DTRTUtil.getLabel((IDescribable)this.model.getStructureSource()))));
        if (this.model.getWizardAction() == DataControlWizardModel.WizardAction.CREATE) {
            sb.append('\n').append(NLS.bind((String)Messages.summaryDataControlId, (Object)this.toSummaryString(this.model.getDataControlId())));
        } else {
            sb.append('\n');
            sb.append('\n').append(Messages.summaryUpdate);
        }
        for (ISummaryProvider summaryProvider : this.model.getSummaryProviders()) {
            for (String summary : summaryProvider.getSummaries()) {
                sb.append('\n').append(summary);
            }
        }
        return sb.toString();
    }

    private String getProjectName() {
        if (this.model.getContext() != null) {
            IProject project;
            IProject iProject = project = this.model.getContext().getModelProject() != null ? this.model.getContext().getModelProject() : this.model.getContext().getWebProject();
            if (project != null) {
                return project.getName();
            }
        }
        return null;
    }

    private String toSummaryString(String string) {
        return string == null ? Messages.summaryUndefined : string;
    }
}

