/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IStructure;
import oracle.eclipse.tools.adf.dtrt.ui.provider.CollectionContentProvider;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DialogColors;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewerComparator;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.IDescribableViewerListener;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ui.datacontrol.DataControlUtil;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DataControlWizardModel;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.TableComboViewer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class SourcePage
extends BaseWizardPage {
    private DataControlWizardModel model;
    private Map<IProject, IDataControlContext> projectMap;
    private IProject project;
    private TableComboViewer projectViewer;
    private TableComboViewer typeViewer;
    private Text typeDescriptionText;
    private FormToolkit toolkit;
    private DescribableViewer sourceViewer;

    public SourcePage(DataControlWizardModel model) {
        super(SourcePage.class.getSimpleName(), Messages.dcSourcePageTitle, null);
        assert (model.getContext() == null);
        assert (model.getStructureSource() == null);
        this.model = model;
        this.setMessage(Messages.dcSourcePageMessage);
    }

    public void dispose() {
        if (this.projectMap != null) {
            for (IDataControlContext context : this.projectMap.values()) {
                if (this.model != null && context == this.model.getContext()) continue;
                context.dispose();
            }
            this.projectMap.clear();
        }
        this.model = null;
        this.project = null;
        this.projectViewer = null;
        this.typeViewer = null;
        this.typeDescriptionText = null;
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.sourceViewer = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo(composite);
        new Label(composite, 0).setText(Messages.projectLabel);
        this.projectViewer = new TableComboViewer(composite);
        this.projectViewer.getTableCombo().setEditable(false);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.projectViewer.getControl());
        this.projectViewer.setContentProvider((IContentProvider)CollectionContentProvider.getDefault());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SourcePage.this.handleProjectSelection(event.getSelection());
            }
        });
        Label typeLabel = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.verticalIndent = 3;
        gridData.verticalAlignment = 128;
        typeLabel.setLayoutData((Object)gridData);
        typeLabel.setText(Messages.typeLabel);
        Composite typeComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().spacing(-1, 2).applyTo(typeComposite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)typeComposite);
        this.typeViewer = new TableComboViewer(typeComposite);
        this.typeViewer.getTableCombo().setEditable(false);
        this.typeViewer.getTableCombo().setEnabled(false);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.typeViewer.getControl());
        this.typeViewer.setContentProvider((IContentProvider)CollectionContentProvider.getDefault());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new DescribableLabelProvider());
        this.typeViewer.setComparator((ViewerComparator)new DescribableViewerComparator());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SourcePage.this.handleTypeSelection(event.getSelection());
            }
        });
        this.typeDescriptionText = new Text(typeComposite, 2626);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.typeDescriptionText).heightHint = 2 * DTRTUIUtil.getFontHeight((Control)this.typeDescriptionText);
        this.typeDescriptionText.setEditable(false);
        new Label(composite, 0).setText(Messages.sourceLabel);
        this.toolkit = new FormToolkit((FormColors)new DialogColors(parent.getDisplay()));
        this.sourceViewer = new DescribableViewer();
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.sourceViewer.createControl(this.toolkit, composite, true, false));
        this.sourceViewer.setBrowseControlEnabled(false);
        this.sourceViewer.addListener(new IDescribableViewerListener(){

            public void handleEvent(IDescribable describable, IDescribableViewerListener.ActionType type) {
                if (type == IDescribableViewerListener.ActionType.BROWSE) {
                    SourcePage.this.browseSource();
                }
            }
        });
    }

    protected void aboutToBecomeVisible(boolean firstTime) {
        if (firstTime) {
            this.computeProjects();
            if (this.projectMap.isEmpty()) {
                this.setMessage(Messages.dcSourcePageNoProject, 3);
            } else {
                IProject project;
                this.projectViewer.setInput(this.projectMap.keySet());
                if (this.model.getSelectedResource() != null && this.projectMap.containsKey(project = this.model.getSelectedResource().getProject())) {
                    this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)project));
                }
            }
        }
    }

    private void computeProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length > 0) {
            this.projectMap = new LinkedHashMap<IProject, IDataControlContext>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    try {
                        IDataControlContext context = DataControlUtil.createInitializedContext(project);
                        if (context != null && !context.getDataControlTypes().isEmpty()) {
                            this.projectMap.put(project, context);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
    }

    private void handleProjectSelection(ISelection selection) {
        Object object = DTRTUIUtil.getFirstElement((ISelection)selection);
        if (object == null) {
            this.project = null;
            this.typeViewer.setInput(null);
            this.typeViewer.getControl().setEnabled(false);
            this.handleTypeSelection((ISelection)StructuredSelection.EMPTY);
        } else if (!object.equals(this.project)) {
            this.project = (IProject)object;
            IDataControlContext context = this.projectMap.get(this.project);
            this.model.setContext(context);
            this.typeViewer.setInput(context.getDataControlTypes());
            Object element = this.typeViewer.getElementAt(0);
            assert (element != null);
            this.typeViewer.setSelection((ISelection)new StructuredSelection(element));
            this.typeViewer.getControl().setEnabled(true);
        }
    }

    private void handleTypeSelection(ISelection selection) {
        Object object = DTRTUIUtil.getFirstElement((ISelection)selection);
        if (object == null) {
            this.model.setDataControlType(null);
            this.sourceViewer.setInput(null);
            this.sourceViewer.setBrowseControlEnabled(false);
            this.typeDescriptionText.setText("");
        } else if (!object.equals(this.model.getDataControlType())) {
            this.model.setDataControlType((IDescribable)object);
            this.sourceViewer.setInput(null);
            this.sourceViewer.setBrowseControlEnabled(true);
            this.typeDescriptionText.setText(DTRTUtil.getToolTipText((IDescribable)this.model.getDataControlType()));
        }
        this.model.setStructureSource(null);
        this.setPageComplete(false);
    }

    private void browseSource() {
        assert (this.model.getContext() != null);
        assert (this.model.getDataControlType() != null);
        Collection structureSources = this.model.getContext().getStructureSources(this.model.getDataControlType());
        if (structureSources.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.dcSourcePageNoSourceTitle, (String)Messages.dcSourcePageNoSourceText);
        } else {
            ArrayList list = new ArrayList(structureSources);
            Collections.sort(list, DTRTUtil.COMPARATOR);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new DescribableLabelProvider());
            dialog.setMultipleSelection(false);
            dialog.setTitle(Messages.selectSourceDialogTitle);
            dialog.setMessage(Messages.selectSourceDialogMessage);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    IResource resource;
                    if (selection != null && selection.length == 1 && selection[0] instanceof IStructure.IStructureSource && (resource = DTRTObjectUtil.getResource((IStructure.IStructureSource)((IStructure.IStructureSource)selection[0]))) != null) {
                        return new Status(0, "oracle.eclipse.tools.adf.view.ui", resource.getFullPath().toString());
                    }
                    return new Status(4, "oracle.eclipse.tools.adf.view.ui", "");
                }
            });
            dialog.setStatusLineAboveButtons(true);
            dialog.setElements(list.toArray());
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null) {
                assert (result.length == 1);
                IStructure.IStructureSource source = (IStructure.IStructureSource)result[0];
                this.model.setStructureSource(source);
                this.model.setDataControlId(this.computeDataControlId());
            }
        }
        this.sourceViewer.setInput((IDescribable)this.model.getStructureSource());
        this.setPageComplete(this.model.getStructureSource() != null);
    }

    private String computeDataControlId() {
        try {
            return this.model.getContext().computeUniqueDataControlId(this.model.getDataControlType(), this.model.getStructureSource());
        }
        catch (Exception e) {
            DTRTUIUtil.handleError((Shell)this.getShell(), (Throwable)e);
            return null;
        }
    }
}

