/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseWizardPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DataControlWizardModel;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.part.PageBook;

class DetailsPage
extends BaseWizardPage {
    private DataControlWizardModel model;
    private PageBook pageBook;
    private Control[] pages;
    private Button updateStructureButton;
    private Button createDataControlButton;
    private List<Text> dataControlIdTexts;
    private int currentPageIndex;
    private boolean shouldSetErrorMessage = true;
    private List<IDataControl> dataControls;

    public DetailsPage(DataControlWizardModel model) {
        super(DetailsPage.class.getSimpleName(), Messages.dcDetailsPageTitle, null);
        this.model = model;
    }

    public void dispose() {
        this.model = null;
        this.dataControls = null;
        this.pageBook = null;
        this.pages = null;
        this.dataControlIdTexts = null;
        this.updateStructureButton = null;
        this.createDataControlButton = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        this.pageBook = new PageBook(composite, 0);
        DTRTUIUtil.applyGrabAllGridData((Control)this.pageBook);
        this.pages = new Control[3];
        this.dataControlIdTexts = new ArrayList<Text>(this.pages.length);
        this.pages[0] = this.createIdControl((Composite)this.pageBook, false);
        this.pages[1] = this.createDataControlsAndIdControls((Composite)this.pageBook);
        this.pages[2] = this.createDataControlsAndUpdateAndIdControl((Composite)this.pageBook);
    }

    private Control createIdControl(Composite parent, boolean indent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults();
        if (indent) {
            layoutFactory.numColumns(3).applyTo(composite);
            new Label(composite, 0).setText("\t");
        } else {
            layoutFactory.numColumns(2).applyTo(composite);
        }
        new Label(composite, 0).setText(Messages.dataControlIdLabel);
        Text dataControlIdText = new Text(composite, 2048);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)dataControlIdText);
        dataControlIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DetailsPage.this.model.setDataControlId(((Text)e.widget).getText());
                DetailsPage.this.validatePage();
            }
        });
        this.dataControlIdTexts.add(dataControlIdText);
        return composite;
    }

    private Control createDataControlsAndIdControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createDataControlsControl(composite);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.createIdControl(composite, false));
        return composite;
    }

    private Control createDataControlsAndUpdateAndIdControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createDataControlsControl(composite);
        this.updateStructureButton = new Button(composite, 16);
        this.updateStructureButton.setText(Messages.dcDetailsPageUpdateStructureLabel);
        this.updateStructureButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DetailsPage.this.handleWizardActionSelection(DataControlWizardModel.WizardAction.UPDATE);
                DetailsPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createDataControlButton = new Button(composite, 16);
        this.createDataControlButton.setText(Messages.dcDetailsPageCreateDataControlLabel);
        this.createDataControlButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DetailsPage.this.handleWizardActionSelection(DataControlWizardModel.WizardAction.CREATE);
                DetailsPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.createIdControl(composite, true));
        return composite;
    }

    private void createDataControlsControl(Composite parent) {
        assert (parent.getLayout() instanceof GridLayout);
        Link displayDataControlsLink = new Link(parent, 64);
        displayDataControlsLink.setText(Messages.dcDetailsPageDataControlsMessage);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)displayDataControlsLink);
        displayDataControlsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailsPage.this.displayDataControls();
            }
        });
        Label separator = new Label(parent, 258);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)separator);
    }

    protected void aboutToBecomeVisible(boolean firstTime) throws Exception {
        try {
            this.dataControls = new ArrayList<IDataControl>(this.model.getContext().getDataControls(this.model.getDataControlType(), this.model.getStructureSource(), null));
        }
        catch (IllegalStateException e) {
            DTRTViewUIUtil.log(e);
        }
        catch (InterruptedException interruptedException) {}
        if (this.model.getDataControlId() == null) {
            this.model.setDataControlId(this.model.getContext().computeUniqueDataControlId(this.model.getDataControlType(), this.model.getStructureSource()));
            assert (this.model.getDataControlId() != null);
        }
        if (this.dataControls == null || this.dataControls.isEmpty()) {
            this.setMessage(Messages.dcDetailsPageMessage1);
            this.currentPageIndex = 0;
            this.model.setCanUpdateStructure(false);
        } else {
            Collections.sort(this.dataControls, DTRTUtil.COMPARATOR);
            if (this.model.getContext().hasUpdateableStructure(this.model.getStructureSource())) {
                this.setMessage(Messages.dcDetailsPageMessage3);
                this.currentPageIndex = 2;
                this.model.setCanUpdateStructure(true);
                if (firstTime) {
                    switch (this.model.getWizardAction()) {
                        case CREATE: {
                            this.createDataControlButton.setSelection(true);
                            break;
                        }
                        case UPDATE: {
                            this.updateStructureButton.setSelection(true);
                        }
                    }
                    this.handleWizardActionSelection(this.model.getWizardAction());
                }
            } else {
                this.setMessage(Messages.dcDetailsPageMessage2);
                this.currentPageIndex = 1;
                this.model.setCanUpdateStructure(false);
            }
        }
        this.shouldSetErrorMessage = false;
        this.dataControlIdTexts.get(this.currentPageIndex).setText(this.model.getDataControlId());
        this.dataControlIdTexts.get(this.currentPageIndex).setSelection(0, this.model.getDataControlId().length());
        this.shouldSetErrorMessage = true;
        this.pageBook.showPage(this.pages[this.currentPageIndex]);
    }

    private void handleWizardActionSelection(DataControlWizardModel.WizardAction action) {
        this.model.setWizardAction(action);
        switch (action) {
            case UPDATE: {
                this.dataControlIdTexts.get(this.currentPageIndex).setEnabled(false);
                break;
            }
            case CREATE: {
                this.dataControlIdTexts.get(this.currentPageIndex).setEnabled(true);
            }
        }
    }

    private void validatePage() {
        if (this.model.getWizardAction() == DataControlWizardModel.WizardAction.CREATE && this.model.getDataControlId() == null) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.dcDetailsPageEmptyDataControlId);
        } else {
            IStatus status = this.model.canPerformFinish();
            if (status.isOK()) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(status.getMessage());
                this.setPageComplete(false);
            }
        }
    }

    public void setErrorMessage(String newMessage) {
        if (this.shouldSetErrorMessage || newMessage == null) {
            super.setErrorMessage(newMessage);
        }
    }

    private void displayDataControls() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new DescribableLabelProvider()){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dialog.setTitle(Messages.dcDetailsPageExistingDataControlsTitle);
        dialog.setMessage(Messages.dcDetailsPageDataExistingControlsLabel);
        dialog.setStatusLineAboveButtons(true);
        dialog.setMultipleSelection(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length == 1 && selection[0] instanceof IDataControl) {
                    IDataControl dataControl = (IDataControl)selection[0];
                    IFile file = DetailsPage.this.model.getContext().getAccessibleFile((IObject)dataControl);
                    String message = file != null ? file.getFullPath().toString() : Messages.notPersisted;
                    return new Status(0, "oracle.eclipse.tools.adf.view.ui", message);
                }
                return Status.OK_STATUS;
            }
        });
        dialog.setElements(this.dataControls.toArray());
        dialog.open();
    }
}

