/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateDataControlCommand;
import oracle.eclipse.tools.adf.dtrt.context.command.IUpdateStructureCommand;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.command.IWizardCommandExecutor;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ISummaryProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.SaveSummaryDialog;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummaryCollector;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DataControlManager;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DataControlWizardModel;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.DetailsPage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.Messages;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.SourcePage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.SummaryPage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.wizard.TypePage;
import oracle.eclipse.tools.adf.view.ui.internal.Activator;
import oracle.eclipse.tools.adf.view.ui.internal.DTRTViewUIUtil;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class DataControlCreationWizard
extends Wizard
implements INewWizard {
    private static final String DSKEY_SHOW_MODIFIED_FILES = "showModifiedFiles";
    private static final String DSKEY_SHOW_DATA_CONTROL_MANAGER = "showDataControlManager";
    private static final String DSKEY_WIZARD_ACTION = "wizardAction";
    private static final IOEPEExecutableContext.ISaveSummary EmptySaveSummary = new IOEPEExecutableContext.ISaveSummary(){

        public int getFileCount() {
            return 0;
        }

        public Collection<? extends IFile> getCreatedFiles() {
            return Collections.emptySet();
        }

        public Collection<? extends IFile> getDeletedFiles() {
            return Collections.emptySet();
        }

        public Collection<? extends IFile> getChangedFiles() {
            return Collections.emptySet();
        }
    };
    private DataControlWizardModel model;
    private List<? extends IWizardPage> contextPages;
    private IWizardPage pageBeforeContextPages;
    private IWizardPage pageAfterContextPages;

    public DataControlCreationWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.dcWizardTitle);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"oracle.eclipse.tools.adf.view.ui", (String)"icons/wizards/data-control-banner.png"));
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        if (dialogSettings != null) {
            String sectionName = ((Object)((Object)this)).getClass().getName();
            IDialogSettings wizardSettings = dialogSettings.getSection(sectionName);
            if (wizardSettings == null) {
                wizardSettings = dialogSettings.addNewSection(sectionName);
            }
            this.setDialogSettings(wizardSettings);
        }
    }

    public DataControlCreationWizard(IWizardCommandExecutor<ICreateDataControlCommand> commandExecutor) {
        this();
        ICreateDataControlCommand command = (ICreateDataControlCommand)commandExecutor.getCommand();
        if (command.getStructureSource() == null) {
            throw new IllegalArgumentException("The source must be set");
        }
        this.model = new DataControlWizardModel(commandExecutor);
        this.loadDialogSettings();
    }

    public void dispose() {
        if (this.contextPages != null) {
            for (IWizardPage iWizardPage : this.contextPages) {
                iWizardPage.dispose();
            }
            this.contextPages.clear();
            this.contextPages = null;
        }
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource resource;
        assert (this.model == null);
        this.model = new DataControlWizardModel();
        this.loadDialogSettings();
        Object object = DTRTUIUtil.getFirstElement((ISelection)selection);
        if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            this.model.setSelectedResource(resource);
        }
    }

    public void addPages() {
        if (this.model.getStructureSource() == null) {
            this.addPage((IWizardPage)new SourcePage(this.model));
        } else {
            this.getShell().setSize(580, 475);
            try {
                List types = this.model.getContext().getDataControlTypes(this.model.getStructureSource());
                if (types.isEmpty()) {
                    this.addPage((IWizardPage)new TypePage(this.model));
                    return;
                }
                if (types.size() == 1) {
                    this.model.setDataControlType((IDescribable)types.get(0));
                } else {
                    this.addPage((IWizardPage)new TypePage(this.model));
                }
            }
            catch (Exception e) {
                DTRTUIUtil.handleError((Shell)this.getShell(), (Throwable)e);
            }
        }
        this.pageBeforeContextPages = new DetailsPage(this.model);
        this.addPage(this.pageBeforeContextPages);
        this.pageAfterContextPages = new SummaryPage(this.model);
        this.addPage(this.pageAfterContextPages);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int n;
        if (this.pageBeforeContextPages == page) {
            assert (this.model.getContext() != null);
            this.model.clearSummaryProviders();
            this.contextPages = this.model.getCommandExecutor().createWizardPages();
            for (IWizardPage iWizardPage : this.contextPages) {
                iWizardPage.setWizard((IWizard)this);
                if (!(iWizardPage instanceof ISummaryProvider)) continue;
                this.model.addSummaryProvider((ISummaryProvider)iWizardPage);
            }
            return this.contextPages.isEmpty() ? this.pageAfterContextPages : this.contextPages.get(0);
        }
        if (this.contextPages != null && (n = this.contextPages.indexOf(page)) >= 0) {
            return n == this.contextPages.size() - 1 ? this.pageAfterContextPages : this.contextPages.get(n + 1);
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index;
        if (this.contextPages != null && (index = this.contextPages.indexOf(page)) >= 0) {
            return index == 0 ? this.pageBeforeContextPages : this.contextPages.get(index - 1);
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        if (this.contextPages != null) {
            for (IWizardPage iWizardPage : this.contextPages) {
                if (iWizardPage.isPageComplete()) continue;
                return false;
            }
        }
        return super.canFinish();
    }

    public int getPageCount() {
        return super.getPageCount() + (this.contextPages != null ? this.contextPages.size() : 0);
    }

    public IWizardPage getPage(String name) {
        IWizardPage page = super.getPage(name);
        if (page == null && this.contextPages != null) {
            for (IWizardPage iWizardPage : this.contextPages) {
                if (!iWizardPage.getName().equals(name)) continue;
                page = iWizardPage;
                break;
            }
        }
        return page;
    }

    public IWizardPage[] getPages() {
        IWizardPage[] pages = super.getPages();
        if (this.contextPages != null) {
            IWizardPage[] array = new IWizardPage[pages.length + this.contextPages.size()];
            int index = 0;
            IWizardPage[] iWizardPageArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                array[index++] = page;
                if (page.equals(this.pageBeforeContextPages)) {
                    for (IWizardPage iWizardPage : this.contextPages) {
                        array[index++] = iWizardPage;
                    }
                }
                ++n2;
            }
            pages = array;
        }
        return pages;
    }

    public boolean performFinish() {
        try {
            List markers;
            IObject object;
            SaveSummaryCollector collector;
            if (this.model.isShowModifiedFiles()) {
                collector = new SaveSummaryCollector();
                this.model.getContext().addListener((IOEPEContext.IContextListener)collector);
            } else {
                collector = null;
            }
            this.getContainer().run(false, true, (IRunnableWithProgress)new WizardRunnable());
            if (collector != null) {
                new SaveSummaryDialog(this.getShell(), !collector.isEmpty() ? (IOEPEExecutableContext.ISaveSummary)((Pair)collector.getSaveSummaries().get(0)).getSecond() : EmptySaveSummary).open();
            }
            this.updateDialogSettings();
            if (this.model.isShowDataControlManagerOnFinish() && this.model.getContext().getMostRecentCommand().getAffectedObjects().size() > 0 && (object = (IObject)this.model.getContext().getMostRecentCommand().getAffectedObjects().get(0)) instanceof IDataControl && !(markers = this.model.getContext().getAccessibleDeclarations(object)).isEmpty()) {
                final URI uri = ((IDataControl)object).getURI();
                final IFileMarker fileMarker = (IFileMarker)markers.get(0);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IEditorPart part = DTRTUIUtil.openEditor((IFileMarker)fileMarker, (String)"oracle.eclipse.tools.adf.view.ui.datacontrols.manager.DataControlManager");
                            if (part instanceof DataControlManager) {
                                part.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)uri));
                            }
                        }
                        catch (Exception e) {
                            DTRTViewUIUtil.log(e);
                        }
                    }
                });
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            DTRTUIUtil.handleError((Shell)this.getShell(), (Throwable)e);
        }
        return false;
    }

    private void loadDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String object;
            if (dialogSettings.get(DSKEY_SHOW_MODIFIED_FILES) != null) {
                this.model.setShowModifiedFiles(dialogSettings.getBoolean(DSKEY_SHOW_MODIFIED_FILES));
            }
            if (dialogSettings.get(DSKEY_SHOW_DATA_CONTROL_MANAGER) != null) {
                this.model.setShowDataControlManagerOnFinish(dialogSettings.getBoolean(DSKEY_SHOW_DATA_CONTROL_MANAGER));
            }
            if (this.model.isCanUpdateStructure() && (object = dialogSettings.get(DSKEY_WIZARD_ACTION)) instanceof String) {
                this.model.setWizardAction(DataControlWizardModel.WizardAction.valueOf(object));
            }
        }
    }

    private void updateDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put(DSKEY_SHOW_MODIFIED_FILES, this.model.isShowModifiedFiles());
            dialogSettings.put(DSKEY_SHOW_DATA_CONTROL_MANAGER, this.model.isShowDataControlManagerOnFinish());
            if (this.model.isCanUpdateStructure()) {
                dialogSettings.put(DSKEY_WIZARD_ACTION, this.model.getWizardAction().name());
            }
        }
    }

    private class WizardRunnable
    implements IRunnableWithProgress {
        private WizardRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.doRun(monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void doRun(IProgressMonitor monitor) throws CoreException, InterruptedException {
            ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)3);
            if (DataControlCreationWizard.this.model.getWizardAction() == DataControlWizardModel.WizardAction.UPDATE) {
                IUpdateStructureCommand command = (IUpdateStructureCommand)DataControlCreationWizard.this.model.getContext().createCommand(IUpdateStructureCommand.class);
                command.setStructureSource(DataControlCreationWizard.this.model.getStructureSource());
                DataControlCreationWizard.this.model.getContext().setExecuteCommand((ICommand)command);
                DataControlCreationWizard.this.model.getContext().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            } else if (DataControlCreationWizard.this.model.getWizardAction() == DataControlWizardModel.WizardAction.CREATE) {
                assert (DataControlCreationWizard.this.model.getCommandExecutor() != null);
                DataControlCreationWizard.this.model.getCommandExecutor().performFinish(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)2));
            } else {
                throw new IllegalStateException();
            }
            DataControlCreationWizard.this.model.getContext().save(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        }
    }
}

