/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlChild;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicDataControlObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.BasicObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.OpenableXMLResource;
import oracle.eclipse.tools.adf.dtrt.util.DTRTContentType;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IFileMarker;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.BaseObjectDetailsPage;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DataControlManager;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DetailsPageSectionUtil;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

final class DataControlObjectDetailsPage
extends BaseObjectDetailsPage {
    public DataControlObjectDetailsPage(EditorPage<IDataControlContext> editorPage) {
        super(editorPage);
    }

    @Override
    public void addDetailPageSection(DetailsPageSectionUtil.IDetailPageSection detailPageSection) {
        super.addDetailPageSection(detailPageSection);
        if (detailPageSection instanceof DetailsPageSectionUtil.StructureTreeSection) {
            detailPageSection.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DataControlObjectDetailsPage.this.getEditorPage().getEditor().selectionChanged(event);
                }
            });
        }
    }

    @Override
    public IUIObjectEditor getObjectEditor(IObject object) {
        IUIObjectEditor objectEditor = (IUIObjectEditor)this.getContext().createObjectEditor(IUIObjectEditor.class, object);
        if (objectEditor == null) {
            if (object instanceof IDataControlObject) {
                boolean showDeclarationAsLink = object instanceof IDataControlChild;
                if (!showDeclarationAsLink) {
                    IProject mainProject = ((DataControlManager)this.getEditorPage().getEditor()).getProject();
                    IFileMarker fileMarker = this.getContext().getAccessibleDeclaration((IDataControlObject)object);
                    if (fileMarker != null && fileMarker.getFile() != null) {
                        showDeclarationAsLink = !mainProject.equals((Object)fileMarker.getFile().getProject());
                    }
                }
                objectEditor = new BasicDataControlObjectEditor((IDataControlProvider)this.getEditorPage().getContext(), (IDataControlObject)object, showDeclarationAsLink, true);
            } else {
                objectEditor = new BasicObjectEditor(object);
            }
        }
        objectEditor.addObjectSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                DataControlObjectDetailsPage.this.getEditorPage().getEditor().setSelection(selection);
            }
        });
        if (objectEditor instanceof BasicDataControlObjectEditor) {
            ((BasicDataControlObjectEditor)objectEditor).setDeclarationEditorId(DTRTContentType.CONFIGURATION, "oracle.eclipse.tools.adf.view.ui.datacontrols.manager.DataControlManager");
        }
        objectEditor.setClient((IUIObjectEditor.IObjectEditorClient)this.getEditorPage().getEditor());
        return objectEditor;
    }

    @Override
    public String getSectionTitle(IObject object) {
        return object instanceof IDataControlObject ? DTRTUtil.getLabel((IDescriptor)((IDataControlObject)object).getTypeDescriptor()) : Messages.dataControlObject;
    }

    @Override
    protected void setInput(DetailsPageSectionUtil.IDetailPageSection detailPageSection, IObject object) {
        if (detailPageSection instanceof DetailsPageSectionUtil.OpenableSection) {
            if (object instanceof IDataControl) {
                DTRTContentType contentType;
                IFile file = this.getContext().getAccessibleFile(object);
                if (file != null && (contentType = DTRTContentType.getDTRTContentType((IFile)file)) != null && contentType.isXML(file)) {
                    OpenableXMLResource openable = new OpenableXMLResource(file);
                    openable.setTypeLabel(contentType.getDescriptor().getLabel());
                    ((DetailsPageSectionUtil.OpenableSection)detailPageSection).setDeclarationOpenable((IOpenable)openable);
                }
            } else {
                ((DetailsPageSectionUtil.OpenableSection)detailPageSection).setDeclarationOpenable(null);
            }
        }
        super.setInput(detailPageSection, object);
    }
}

