/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.ui.datacontrol.manager;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IDataControlContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.ObjectDetailsPage;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.view.ui.datacontrol.manager.DetailsPageSectionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;

abstract class BaseObjectDetailsPage
extends ObjectDetailsPage<IDataControlContext>
implements DetailsPageSectionUtil.IObjectSectionHandler {
    private IOEPEExecutableContext.IExecutableContextListener contextListener = new ExecutableContextAdapter(){

        public void handleCommandOperation(IOEPEExecutableContext context, ICommand command) {
            BaseObjectDetailsPage.this.refreshSections();
        }

        public void handleSave(IOEPEExecutableContext context, IOEPEExecutableContext.ISaveSummary saveSummary) {
            BaseObjectDetailsPage.this.refreshSections();
        }
    };
    private List<DetailsPageSectionUtil.IDetailPageSection> detailPageSections;

    public BaseObjectDetailsPage(EditorPage<IDataControlContext> editorPage) {
        super(editorPage);
        ((IDataControlContext)editorPage.getContext()).addListener((IOEPEContext.IContextListener)this.contextListener);
    }

    public void dispose() {
        if (this.contextListener != null) {
            if (this.getEditorPage() != null && this.getEditorPage().getContext() != null) {
                ((IDataControlContext)this.getEditorPage().getContext()).removeListener((IOEPEContext.IContextListener)this.contextListener);
            }
            this.contextListener = null;
        }
        if (this.detailPageSections != null) {
            DTRTUtil.dispose(this.detailPageSections);
            this.detailPageSections.clear();
            this.detailPageSections = null;
        }
        super.dispose();
    }

    protected final IDataControlContext getContext() {
        return (IDataControlContext)this.getEditorPage().getContext();
    }

    public void addDetailPageSection(DetailsPageSectionUtil.IDetailPageSection detailPageSection) {
        if (detailPageSection != null) {
            if (this.detailPageSections == null) {
                this.detailPageSections = new ArrayList<DetailsPageSectionUtil.IDetailPageSection>(5);
            }
            this.detailPageSections.add(detailPageSection);
        }
    }

    public final void createContents(Composite parent) {
        super.createContents(parent);
        DetailsPageSectionUtil.ObjectSection objectSection = new DetailsPageSectionUtil.ObjectSection(this);
        if (this.detailPageSections == null) {
            this.addDetailPageSection(objectSection);
        } else {
            this.detailPageSections.add(0, objectSection);
        }
        int i = 0;
        int max = this.detailPageSections.size() - 1;
        while (i <= max) {
            this.detailPageSections.get(i).createControls(this.getManagedForm(), parent, i == max);
            ++i;
        }
    }

    public final void selectionChanged(IFormPart part, ISelection selection) {
        IObject object;
        if (this.detailPageSections != null && !this.detailPageSections.isEmpty() && !this.isCurrentObject(object = DTRTUIUtil.getObject((ISelection)selection))) {
            this.disposeObjectEditor();
            for (DetailsPageSectionUtil.IDetailPageSection detailPageSection : this.detailPageSections) {
                this.setInput(detailPageSection, object);
            }
        }
    }

    private void refreshSections() {
        if (this.detailPageSections != null && !this.detailPageSections.isEmpty() && this.getObjectEditor() != null) {
            IObject object = this.getObjectEditor().getObject();
            for (DetailsPageSectionUtil.IDetailPageSection detailPageSection : this.detailPageSections) {
                detailPageSection.refresh(object);
            }
        }
    }

    protected void setInput(DetailsPageSectionUtil.IDetailPageSection detailPageSection, IObject object) {
        detailPageSection.setInput(object);
    }

    @Override
    public final void setObjectEditorControl(IUIObjectEditor objectEditor, Control control) {
        this.objectEditor = objectEditor;
        this.objectEditorControl = control;
    }
}

