/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.RelativePathBrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.TextFieldPropertyEditorPresentation;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public final class WorkspaceRelativePathPropertyEditorPresentation
extends TextFieldPropertyEditorPresentation {
    public WorkspaceRelativePathPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    protected void createContents(Composite parent) {
        PropertyEditorPart part = this.part();
        Value value = (Value)part.property();
        Element element = value.element();
        Text textField = (Text)super.createContents(parent, true);
        Composite drillDownParent = this.createMainComposite(parent, new PropertyEditorPresentation.CreateMainCompositeDelegate((PropertyEditorPresentation)this, part){

            public boolean getShowLabel() {
                return false;
            }
        });
        drillDownParent.setLayout((Layout)GridLayoutUtil.glayout((int)1, (int)9, (int)0, (int)0, (int)0));
        DrillDownComposite drillDown = new DrillDownComposite(drillDownParent, 2048);
        drillDown.setLayoutData((Object)GridLayoutUtil.gdfill());
        final TreeViewer treeViewer = new TreeViewer((Composite)drillDown, 0);
        Tree tree = treeViewer.getTree();
        drillDown.setChildTree(treeViewer);
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        treeViewer.setSorter(new ViewerSorter());
        ValidFileSystemResourceType validFileSystemResourceTypeAnnotation = (ValidFileSystemResourceType)value.definition().getAnnotation(ValidFileSystemResourceType.class);
        if (validFileSystemResourceTypeAnnotation != null) {
            FileExtensionsService fileExtensionsService;
            if (validFileSystemResourceTypeAnnotation.value() == FileSystemResourceType.FOLDER) {
                treeViewer.addFilter((ViewerFilter)new RelativePathBrowseActionHandler.ContainersOnlyViewerFilter());
            }
            if ((fileExtensionsService = (FileExtensionsService)value.service(FileExtensionsService.class)) != null) {
                final RelativePathBrowseActionHandler.ExtensionBasedViewerFilter filter = new RelativePathBrowseActionHandler.ExtensionBasedViewerFilter(fileExtensionsService.extensions());
                treeViewer.addFilter((ViewerFilter)filter);
                final Listener listener = new Listener(){

                    public void handle(Event event) {
                        filter.change(fileExtensionsService.extensions());
                        treeViewer.refresh();
                    }
                };
                fileExtensionsService.attach(listener);
                tree.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        fileExtensionsService.detach(listener);
                    }
                });
            }
        }
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    Object item = selection.getFirstElement();
                    if (treeViewer.getExpandedState(item)) {
                        treeViewer.collapseToLevel(item, 1);
                    } else {
                        treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        Object root = element instanceof CreateWorkspaceFileOp ? (IContainer)((CreateWorkspaceFileOp)element).getRoot().resolve() : ResourcesPlugin.getWorkspace().getRoot();
        treeViewer.setInput(root);
        this.decorator.addEditorControl((Control)drillDown);
        this.decorator.addEditorControl((Control)tree);
        String val = value.text();
        if (val != null) {
            Path path = new Path(val);
            IResource resource = root.findMember(val);
            while (resource == null) {
                path = path.removeLastSegments(1);
                resource = root.findMember((IPath)path);
            }
            if (resource instanceof IFile && validFileSystemResourceTypeAnnotation.value() == FileSystemResourceType.FOLDER) {
                resource = resource.getParent();
            }
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener((IContainer)root, textField){
            private final /* synthetic */ IContainer val$root;
            private final /* synthetic */ Text val$textField;
            {
                this.val$root = iContainer;
                this.val$textField = text;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IResource resource = selection == null || selection.isEmpty() ? (IResource)treeViewer.getInput() : (IResource)selection.getFirstElement();
                String path = resource.getFullPath().makeRelativeTo(this.val$root.getFullPath()).toString();
                if (path.startsWith("/") && path.length() > 1) {
                    path = path.substring(1);
                }
                this.val$textField.setText(path);
            }
        });
        textField.setData("binding", (Object)this.binding);
        this.addControl((Control)tree);
    }

    protected boolean canScaleVertically() {
        return true;
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new WorkspaceRelativePathPropertyEditorPresentation((FormComponentPart)part, parent, composite);
        }
    }
}

