/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.Messages;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarketplaceUrlHandler {
    public static final String DESCRIPTOR_HINT = "org.eclipse.epp.mpc.descriptorHint";
    public static final String MPC_INSTALL_URI = "/mpc/install?";
    public static final String SITE_SEARCH_URI = "/search/site";
    private static final Pattern CONTENT_URL_PATTERN = Pattern.compile("(?:^|/)content/([^/#?]+)");
    private static final Pattern NODE_URL_PATTERN = Pattern.compile("(?:^|/)node/([^/#?]+)");
    protected static final String UTF_8 = "UTF-8";
    private static final String PARAM_SPLIT_REGEX = "&";
    private static final String EQUALS_REGEX = "=";
    private static final String MPC_STATE = "mpc_state";
    private static final String MPC_INSTALL = "mpc_install";

    public static SolutionInstallationInfo createSolutionInstallInfo(String url) {
        String installId = null;
        String state = null;
        Map<String, String> query = MarketplaceUrlHandler.parseQuery(url);
        if (query != null) {
            installId = query.get(MPC_INSTALL);
            state = query.get(MPC_STATE);
        }
        if (installId != null) {
            CatalogDescriptor descriptor = CatalogRegistry.getInstance().findCatalogDescriptor(url);
            if (descriptor == null) {
                try {
                    descriptor = new CatalogDescriptor(new URL(url), DESCRIPTOR_HINT);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            SolutionInstallationInfo info = new SolutionInstallationInfo(installId, state, descriptor);
            info.setRequestUrl(url);
            return info;
        }
        return null;
    }

    public static String getMPCState(String url) {
        Map<String, String> query = MarketplaceUrlHandler.parseQuery(url);
        return query == null ? null : query.get(MPC_STATE);
    }

    private static Map<String, String> parseQuery(String url) {
        String[] params;
        String query;
        try {
            query = new URL(url).getQuery();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (query == null) {
            return null;
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        String[] stringArray = params = query.split(PARAM_SPLIT_REGEX);
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] keyValue = param.split(EQUALS_REGEX);
            if (keyValue.length == 2) {
                String key = keyValue[0];
                String value = keyValue[1];
                values.put(key, value);
            }
            ++n2;
        }
        return values;
    }

    public static boolean isPotentialSolution(String url) {
        return url != null && url.contains(MPC_INSTALL);
    }

    public static void triggerInstall(SolutionInstallationInfo info) {
        if (info.getRequestUrl() != null) {
            MarketplaceClientUi.getLog().log((IStatus)new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceUrlHandler_performInstallRequest, (Object)info.getRequestUrl())));
        }
        String installId = info.getInstallId();
        String mpcState = info.getState();
        CatalogDescriptor catalogDescriptor = info.getCatalogDescriptor();
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setSelectedCatalogDescriptor(catalogDescriptor);
        try {
            if (mpcState != null) {
                command.setWizardState(URLDecoder.decode(mpcState, UTF_8));
            }
            HashMap<String, Operation> nodeToOperation = new HashMap<String, Operation>();
            nodeToOperation.put(URLDecoder.decode(installId, UTF_8), Operation.INSTALL);
            command.setOperations(nodeToOperation);
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalStateException(e1);
        }
        try {
            command.execute(new ExecutionEvent());
        }
        catch (ExecutionException e) {
            IStatus status = MarketplaceClientUi.computeStatus((Exception)((Object)e), Messages.MarketplaceUrlHandler_cannotOpenMarketplaceWizard);
            StatusManager.getManager().handle(status, 7);
        }
    }

    public boolean handleUri(String uri) {
        String baseUri;
        SolutionInstallationInfo installInfo;
        if (MarketplaceUrlHandler.isPotentialSolution(uri) && (installInfo = MarketplaceUrlHandler.createSolutionInstallInfo(uri)) != null) {
            return this.handleInstallRequest(installInfo, uri);
        }
        CatalogDescriptor descriptor = CatalogRegistry.getInstance().findCatalogDescriptor(uri);
        if (descriptor == null && (descriptor = this.handleUnknownCatalog(uri)) == null) {
            return false;
        }
        try {
            baseUri = descriptor.getUrl().toURI().toString();
            if (!baseUri.endsWith("/")) {
                baseUri = String.valueOf(baseUri) + '/';
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (!uri.startsWith(baseUri) && !(uri = this.resolve(uri, baseUri, descriptor)).startsWith(baseUri)) {
            return false;
        }
        String relativeUri = uri.substring(baseUri.length());
        if (relativeUri.startsWith("favorites/top")) {
            return this.handleFavorites(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("featured")) {
            return this.handleFeatured(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("content")) {
            return this.handleNodeContent(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("node")) {
            return this.handleNode(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("popular/top")) {
            return this.handlePopular(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("recent")) {
            return this.handleRecent(descriptor, relativeUri);
        }
        if (relativeUri.startsWith("search/apachesolr_search/") || relativeUri.startsWith("api/p/search/apachesolr_search/")) {
            return this.handleSolrSearch(descriptor, relativeUri);
        }
        if (relativeUri.startsWith(SITE_SEARCH_URI.substring(1))) {
            return this.handleSiteSearch(descriptor, relativeUri);
        }
        return this.handleUnknownPath(descriptor, relativeUri);
    }

    protected String resolve(String url, String baseUri, CatalogDescriptor descriptor) {
        if (url.startsWith("https:") && baseUri.startsWith("http:")) {
            url = "http:" + url.substring("https:".length());
        } else if (url.startsWith("http:") && baseUri.startsWith("https:")) {
            url = "https:" + url.substring("http:".length());
        }
        return url;
    }

    protected boolean handleUnknownPath(CatalogDescriptor descriptor, String url) {
        return false;
    }

    private boolean handleSolrSearch(CatalogDescriptor descriptor, String url) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String searchString = this.parseSearchQuery(descriptor, url, params);
            return this.handleSearch(descriptor, url, searchString, params);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private boolean handleSiteSearch(CatalogDescriptor descriptor, String url) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String searchString = this.parseSearchQuery(descriptor, url, params);
            StringBuilder filter = new StringBuilder();
            Iterator i = params.values().iterator();
            while (i.hasNext()) {
                int sep;
                String str = (String)i.next();
                if (!str.startsWith("im_taxonomy_vocabulary_") || (sep = str.indexOf(58)) == -1) continue;
                String tid = str.substring(sep + 1);
                if (filter.length() > 0) {
                    filter.append(' ');
                }
                filter.append(tid);
                i.remove();
            }
            return this.handleSearch(descriptor, url, searchString, params);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    private String parseSearchQuery(CatalogDescriptor descriptor, String url, Map<String, String> params) throws URISyntaxException, MalformedURLException {
        URI searchUri = new URL(descriptor.getUrl(), url).toURI();
        String path = searchUri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int sep = path.lastIndexOf(47);
        String searchString = path.substring(sep + 1);
        String query = searchUri.getQuery();
        if (query != null) {
            this.extractParams(query, params);
        }
        return searchString;
    }

    protected boolean handleSearch(CatalogDescriptor descriptor, String url, String searchString, Map<String, String> params) {
        return false;
    }

    private void extractParams(String query, Map<String, String> params) {
        String[] paramStrings;
        String[] stringArray = paramStrings = query.split(PARAM_SPLIT_REGEX);
        int n = paramStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] parts = param.split(EQUALS_REGEX);
            if (parts.length == 2) {
                params.put(parts[0], parts[1]);
            }
            ++n2;
        }
    }

    protected boolean handleRecent(CatalogDescriptor descriptor, String url) {
        return false;
    }

    protected boolean handlePopular(CatalogDescriptor descriptor, String url) {
        return false;
    }

    private boolean handleNode(CatalogDescriptor descriptor, String url) {
        Matcher matcher = NODE_URL_PATTERN.matcher(url);
        String id = null;
        if (matcher.find()) {
            id = matcher.group(1);
        }
        Node node = new Node();
        node.setId(id);
        return this.handleNode(descriptor, url, (INode)node);
    }

    private boolean handleNodeContent(CatalogDescriptor descriptor, String url) {
        Matcher matcher = CONTENT_URL_PATTERN.matcher(url);
        String title = null;
        if (matcher.find()) {
            title = matcher.group(1);
        }
        Node node = new Node();
        node.setUrl(url);
        if (title != null) {
            int titleEnd;
            String base = descriptor.getUrl().toExternalForm();
            if (!base.endsWith("/")) {
                base = String.valueOf(base) + "/";
            }
            if ((titleEnd = matcher.end()) > -1) {
                node.setUrl(String.valueOf(base) + url.substring(0, titleEnd));
            } else {
                node.setUrl(String.valueOf(base) + url);
            }
        }
        return this.handleNode(descriptor, url, (INode)node);
    }

    protected boolean handleNode(CatalogDescriptor descriptor, String url, INode node) {
        return false;
    }

    private boolean handleFeatured(CatalogDescriptor descriptor, String url) {
        Matcher matcher = Pattern.compile("(?:^|/)featured/(\\d+)(?:,(\\d+))?").matcher(url);
        String cat = null;
        String market = null;
        if (matcher.find()) {
            cat = matcher.group(1);
            if (matcher.groupCount() > 1) {
                market = matcher.group(2);
            }
        }
        return this.handleFeatured(descriptor, url, cat, market);
    }

    protected boolean handleFeatured(CatalogDescriptor descriptor, String url, String category, String market) {
        return false;
    }

    protected boolean handleFavorites(CatalogDescriptor descriptor, String url) {
        return false;
    }

    protected CatalogDescriptor handleUnknownCatalog(String url) {
        if (url.startsWith("https:")) {
            url = "http:" + url.substring("https:".length());
            return CatalogRegistry.getInstance().findCatalogDescriptor(url);
        }
        if (url.startsWith("http:")) {
            url = "https:" + url.substring("http:".length());
            return CatalogRegistry.getInstance().findCatalogDescriptor(url);
        }
        return null;
    }

    protected boolean handleInstallRequest(SolutionInstallationInfo installInfo, String url) {
        return false;
    }

    public static class SolutionInstallationInfo {
        private String requestUrl;
        private String installId;
        private String state;
        private CatalogDescriptor catalogDescriptor;

        public SolutionInstallationInfo() {
        }

        protected SolutionInstallationInfo(String installId, String state, CatalogDescriptor catalogDescriptor) {
            this.installId = installId;
            this.state = state;
            this.catalogDescriptor = catalogDescriptor;
        }

        public String getInstallId() {
            return this.installId;
        }

        public String getState() {
            return this.state;
        }

        public CatalogDescriptor getCatalogDescriptor() {
            return this.catalogDescriptor;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }
    }
}

