/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.Identifiable;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.BrowseCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IDiscoveryItemFactory;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePatternFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewerSorter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IIdentifiable;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.TextSearchControl;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceViewer
extends CatalogViewer {
    private ViewerFilter[] filters;
    private ContentType contentType = ContentType.SEARCH;
    public static String CONTENT_TYPE_PROPERTY = "contentType";
    private final SelectionModel selectionModel;
    private String queryText;
    private IMarket queryMarket;
    private ICategory queryCategory;
    private ContentType queryContentType;
    private final IMarketplaceWebBrowser browser;
    private String findText;
    private final MarketplaceWizard wizard;
    private final List<IPropertyChangeListener> listeners = new LinkedList<IPropertyChangeListener>();
    private IDiscoveryItemFactory discoveryItemFactory;

    public MarketplaceViewer(Catalog catalog, IShellProvider shellProvider, MarketplaceWizard wizard) {
        super(catalog, shellProvider, (IRunnableContext)wizard.getContainer(), (CatalogConfiguration)wizard.getConfiguration());
        this.browser = wizard;
        this.selectionModel = wizard.getSelectionModel();
        this.wizard = wizard;
        this.setAutomaticFind(false);
    }

    protected void doCreateHeaderControls(Composite parent) {
        int originalChildCount = parent.getChildren().length;
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            if (!(filter instanceof MarketplaceFilter)) continue;
            MarketplaceFilter marketplaceFilter = (MarketplaceFilter)filter;
            marketplaceFilter.createControl(parent);
            marketplaceFilter.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("selected".equals(event.getProperty())) {
                        MarketplaceViewer.this.doQuery();
                    }
                }
            });
        }
        Control[] children = parent.getChildren();
        int x = originalChildCount;
        while (x < children.length) {
            Control child = children[x];
            GridDataFactory.swtDefaults().hint(135, -1).applyTo(child);
            ++x;
        }
        Button goButton = new Button(parent, 8);
        goButton.setText(Messages.MarketplaceViewer_go);
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceViewer.this.doQuery();
            }
        });
    }

    protected CatalogViewer.CatalogContentProvider doCreateContentProvider() {
        return new MarketplaceCatalogContentProvider();
    }

    protected void catalogUpdated(boolean wasCancelled, boolean wasError) {
        super.catalogUpdated(wasCancelled, wasError);
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            if (!(filter instanceof MarketplaceFilter)) continue;
            ((MarketplaceFilter)filter).catalogUpdated(wasCancelled);
        }
        this.setFilters(this.queryMarket, this.queryCategory, this.queryText);
    }

    protected void filterTextChanged() {
        this.doFind(this.getFilterText());
    }

    protected void doFind(String text) {
        this.findText = text;
        this.doQuery();
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        if (element instanceof CatalogItem) {
            CatalogItem catalogItem = (CatalogItem)element;
            if (catalogItem.getData() instanceof CatalogDescriptor) {
                CatalogDescriptor catalogDescriptor = (CatalogDescriptor)catalogItem.getData();
                return new BrowseCatalogItem(parent, this.getResources(), this.shellProvider, this.browser, (MarketplaceCategory)catalogItem.getCategory(), catalogDescriptor, this);
            }
            DiscoveryItem<CatalogItem> discoveryItem = this.createDiscoveryItem(parent, catalogItem);
            discoveryItem.setSelected(this.getCheckedItems().contains(catalogItem));
            return discoveryItem;
        }
        if (element instanceof MarketplaceCategory) {
            MarketplaceCategory category = (MarketplaceCategory)((Object)element);
            if (category.getContents() != MarketplaceCategory.Contents.FEATURED) {
                throw new IllegalStateException();
            }
            category.setName(Messages.MarketplaceViewer_featured);
            CategoryItem categoryItem = (CategoryItem)super.doCreateViewerItem(parent, element);
            MarketplaceViewer.setSeparatorVisible(categoryItem, false);
            MarketplaceViewer.fixLayout(categoryItem);
            return categoryItem;
        }
        return super.doCreateViewerItem(parent, element);
    }

    private DiscoveryItem<CatalogItem> createDiscoveryItem(Composite parent, CatalogItem catalogItem) {
        if (this.discoveryItemFactory != null) {
            return this.discoveryItemFactory.createDiscoveryItem(catalogItem, this, parent, this.getResources(), this.shellProvider, this.browser);
        }
        return new DiscoveryItem<CatalogItem>(parent, 0, this.getResources(), this.shellProvider, this.browser, catalogItem, this);
    }

    public void show(Set<? extends INode> nodes) {
        ContentType newContentType = ContentType.SEARCH;
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.fireContentTypeChange(oldContentType, newContentType);
        this.doQuery(null, null, null, nodes);
    }

    public void search(IMarket market, ICategory category, String query) {
        ContentType newContentType = ContentType.SEARCH;
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.fireContentTypeChange(oldContentType, newContentType);
        this.setFilters(market, category, query);
        this.queryMarket = market;
        this.queryCategory = category;
        this.queryText = query;
        this.doQuery(market, category, query, null);
    }

    private void setFilters(IMarket market, ICategory category, String query) {
        this.setFindText(query == null ? "" : query);
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            List<Tag> choices = tagFilter.getChoices();
            Tag tag2 = tag = choices.isEmpty() ? null : choices.get(0);
            if (tag == null) continue;
            IMarket data = null;
            if (tag.getTagClassifier() == IMarket.class) {
                data = market;
            } else {
                if (tag.getTagClassifier() != ICategory.class) continue;
                data = category;
            }
            tag = null;
            if (data != null) {
                for (Tag choice : choices) {
                    Object choiceData = choice.getData();
                    if (choiceData != data && !MarketplaceViewer.matches((IIdentifiable)data, choiceData)) continue;
                    tag = choice;
                    break;
                }
            }
            tagFilter.setSelected(tag == null ? Collections.emptySet() : Collections.singleton(tag));
            tagFilter.updateUi();
        }
    }

    private static boolean matches(IIdentifiable data, Object tagData) {
        return tagData instanceof IIdentifiable && Identifiable.matches((IIdentifiable)((IIdentifiable)tagData), (IIdentifiable)data);
    }

    private void doQuery() {
        this.initQueryFromFilters();
        this.doQuery(this.queryMarket, this.queryCategory, this.queryText, null);
    }

    private void initQueryFromFilters() {
        this.queryMarket = null;
        this.queryCategory = null;
        this.queryText = null;
        this.findText = this.getFilterText();
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            Tag tag2 = tag = tagFilter.getSelected().isEmpty() ? null : tagFilter.getSelected().iterator().next();
            if (tag == null) continue;
            if (tag.getTagClassifier() == IMarket.class) {
                this.queryMarket = (IMarket)tag.getData();
                continue;
            }
            if (tag.getTagClassifier() != ICategory.class) continue;
            this.queryCategory = (ICategory)tag.getData();
        }
        this.queryText = this.findText;
    }

    public void doQueryForTag(String tag) {
        ContentType newContentType = ContentType.SEARCH;
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.fireContentTypeChange(oldContentType, newContentType);
        this.setFindText(tag);
        this.doQuery(null, null, tag, null);
    }

    private void setFindText(String tag) {
        try {
            Field filterTextField = FilteredViewer.class.getDeclaredField("filterText");
            filterTextField.setAccessible(true);
            TextSearchControl textSearchControl = (TextSearchControl)filterTextField.get((Object)this);
            textSearchControl.getTextControl().setText(tag);
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.epp.mpc.ui", Messages.MarketplaceViewer_Could_not_change_find_text, (Throwable)e));
        }
    }

    private void fireContentTypeChange(ContentType oldValue, ContentType newValue) {
        MarketplaceViewer source = this;
        String property = CONTENT_TYPE_PROPERTY;
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)source, property, (Object)oldValue, (Object)newValue));
    }

    private void doQuery(final IMarket market, final ICategory category, final String queryText, final Set<? extends INode> nodes) {
        try {
            ContentType queryType;
            this.queryContentType = queryType = this.contentType;
            final IStatus[] result = new IStatus[1];
            this.context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    switch (queryType) {
                        case POPULAR: {
                            result[0] = MarketplaceViewer.this.getCatalog().popular(monitor);
                            break;
                        }
                        case RECENT: {
                            result[0] = MarketplaceViewer.this.getCatalog().recent(monitor);
                            break;
                        }
                        case INSTALLED: {
                            result[0] = MarketplaceViewer.this.getCatalog().installed(monitor);
                            break;
                        }
                        case SELECTION: {
                            HashSet<String> nodeIds = new HashSet<String>();
                            for (CatalogItem item : MarketplaceViewer.this.getSelectionModel().getItemToSelectedOperation().keySet()) {
                                nodeIds.add(((INode)item.getData()).getId());
                            }
                            result[0] = MarketplaceViewer.this.getCatalog().performQuery(monitor, nodeIds);
                            break;
                        }
                        default: {
                            result[0] = nodes != null && !nodes.isEmpty() ? MarketplaceViewer.this.getCatalog().performNodeQuery(monitor, nodes) : (queryText != null && queryText.length() > 0 ? MarketplaceViewer.this.getCatalog().performQuery(market, category, queryText, monitor) : MarketplaceViewer.this.getCatalog().featured(monitor, market, category));
                        }
                    }
                    if (!monitor.isCanceled() && result[0] != null && result[0].getSeverity() != 8) {
                        MarketplaceViewer.this.getCatalog().checkForUpdates(monitor);
                    }
                    MarketplaceViewer.this.getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MarketplaceViewer.this.updateViewer(queryText);
                        }
                    });
                }
            });
            if (result[0] != null && !result[0].isOK() && result[0].getSeverity() != 8) {
                StatusManager.getManager().handle(result[0], 7);
            } else {
                this.verifyUpdateSiteAvailability();
            }
        }
        catch (InvocationTargetException e) {
            IStatus status = this.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
            StatusManager.getManager().handle(status, 7);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void updateViewer(String queryText) {
        if (this.contentType == ContentType.INSTALLED) {
            this.getViewer().setSorter((ViewerSorter)new MarketplaceViewerSorter());
        } else {
            this.getViewer().setSorter(null);
        }
        super.doFind(queryText);
        this.getViewer().getControl().getParent().layout(true, true);
    }

    public void showSelected() {
        this.contentType = ContentType.SELECTION;
        this.queryMarket = null;
        this.queryCategory = null;
        this.queryText = null;
        this.findText = null;
        this.setHeaderVisible(true);
        this.doQuery(null, null, this.findText, null);
        this.contentType = ContentType.SEARCH;
    }

    public MarketplaceCatalogConfiguration getConfiguration() {
        return (MarketplaceCatalogConfiguration)super.getConfiguration();
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    protected PatternFilter doCreateFilter() {
        return new MarketplacePatternFilter();
    }

    public void setContentType(ContentType contentType) {
        if (this.contentType != contentType) {
            ContentType oldContentType = this.contentType;
            this.contentType = contentType;
            this.fireContentTypeChange(oldContentType, contentType);
            this.setHeaderVisible(contentType == ContentType.SEARCH || contentType == ContentType.SELECTION);
            this.doQuery();
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public void setHeaderVisible(boolean visible) {
        if (visible != this.isHeaderVisible()) {
            if (!visible) {
                this.filters = this.getViewer().getFilters();
                this.getViewer().resetFilters();
            } else if (this.filters != null) {
                this.getViewer().setFilters(this.filters);
                this.filters = null;
            }
            super.setHeaderVisible(visible);
        }
    }

    protected boolean doFilter(CatalogItem item) {
        return true;
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        ServiceReference serviceReference = null;
        final BundleContext bundleContext = MarketplaceClientUiPlugin.getInstance().getBundle().getBundleContext();
        try {
            serviceReference = bundleContext.getServiceReference(IDiscoveryItemFactory.class);
            if (serviceReference != null) {
                this.discoveryItemFactory = (IDiscoveryItemFactory)bundleContext.getService(serviceReference);
            }
        }
        catch (Exception ex) {
            MarketplaceClientUi.error(ex);
        }
        StructuredViewer viewer = super.doCreateViewer(container);
        viewer.setSorter(null);
        if (serviceReference != null) {
            final ServiceReference ref = serviceReference;
            viewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    bundleContext.ungetService(ref);
                }
            });
        }
        return viewer;
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void modifySelection(CatalogItem connector, Operation operation) {
        this.modifySelection(connector, operation == null ? null : operation.getOperation());
    }

    protected void modifySelection(CatalogItem connector, org.eclipse.epp.mpc.ui.Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel.select(connector, operation);
        super.modifySelection(connector, operation != org.eclipse.epp.mpc.ui.Operation.NONE);
    }

    protected void postDiscovery() {
    }

    public void updateCatalog() {
        if (this.getWizard().wantInitializeInitialSelection()) {
            try {
                this.getWizard().initializeInitialSelection();
                this.catalogUpdated(false, false);
            }
            catch (CoreException e) {
                boolean wasCancelled;
                boolean bl = wasCancelled = e.getStatus().getSeverity() == 8;
                if (!wasCancelled) {
                    StatusManager.getManager().handle(e.getStatus(), 7);
                }
                this.catalogUpdated(wasCancelled, !wasCancelled);
            }
        } else {
            super.updateCatalog();
        }
        this.refresh();
    }

    protected IStatus computeStatus(InvocationTargetException e, String message) {
        return MarketplaceClientUi.computeStatus(e, message);
    }

    private MarketplaceWizard getWizard() {
        return this.wizard;
    }

    public List<CatalogItem> getCheckedItems() {
        ArrayList<CatalogItem> items = new ArrayList<CatalogItem>();
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : this.getSelectionModel().getItemToSelectedOperation().entrySet()) {
            if (entry.getValue() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            items.add(entry.getKey());
        }
        return items;
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.getCheckedItems());
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public ICategory getQueryCategory() {
        return this.queryCategory;
    }

    public IMarket getQueryMarket() {
        return this.queryMarket;
    }

    ContentType getQueryContentType() {
        return this.queryContentType;
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return MarketplaceClientUi.computeInstalledFeatures(monitor);
    }

    protected static void fixLayout(CategoryItem<?> categoryItem) {
        CatalogCategory category = (CatalogCategory)categoryItem.getData();
        boolean hasDescription = category.getDescription() != null;
        int valignTitle = hasDescription ? 1 : 0x1000000;
        int totalRows = hasDescription ? 2 : 1;
        Control[] children = categoryItem.getChildren();
        Composite categoryHeaderContainer = (Composite)children[0];
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, hasDescription ? 5 : 10).equalWidth(false).applyTo(categoryHeaderContainer);
        Control[] headerChildren = categoryHeaderContainer.getChildren();
        Control iconLabel = headerChildren[0];
        Control nameLabel = headerChildren[1];
        Control tooltip = headerChildren[2];
        GridDataFactory.swtDefaults().align(0x1000000, valignTitle).span(1, totalRows).applyTo(iconLabel);
        GridDataFactory.fillDefaults().grab(true, false).align(1, valignTitle).applyTo(nameLabel);
        if (tooltip instanceof Label) {
            GridDataFactory.fillDefaults().align(0x1000008, valignTitle).applyTo(tooltip);
        }
    }

    protected static void setSeparatorVisible(CategoryItem<?> categoryItem, boolean visible) {
        Control childControl = categoryItem.getChildren()[0];
        if (childControl instanceof GradientCanvas) {
            GradientCanvas canvas = (GradientCanvas)childControl;
            canvas.setSeparatorVisible(visible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        SEARCH,
        RECENT,
        POPULAR,
        INSTALLED,
        SELECTION;

    }

    public static class MarketplaceCatalogContentProvider
    extends CatalogViewer.CatalogContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];

        public Catalog getCatalog() {
            return super.getCatalog();
        }

        public Object[] getElements(Object inputElement) {
            if (this.getCatalog() != null) {
                ArrayList<CatalogCategory> items = new ArrayList<CatalogCategory>(this.getCatalog().getItems());
                for (CatalogCategory category : this.getCatalog().getCategories()) {
                    MarketplaceCategory marketplaceCategory;
                    if (!(category instanceof MarketplaceCategory) || (marketplaceCategory = (MarketplaceCategory)category).getContents() != MarketplaceCategory.Contents.FEATURED) continue;
                    items.add(0, category);
                }
                return items.toArray();
            }
            return NO_ELEMENTS;
        }
    }
}

