/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.CatalogBranding;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogSwitcher;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplacePage
extends CatalogPage {
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogDescriptor previousCatalogDescriptor;
    private boolean updated;
    private Link selectionLink;
    private TabFolder tabFolder;
    private TabItem searchTabItem;
    private TabItem recentTabItem;
    private TabItem popularTabItem;
    private TabItem newsTabItem;
    private Control tabContent;
    private TabItem installedTabItem;
    private NewsViewer newsViewer;
    private CatalogSwitcher marketplaceSwitcher;
    protected boolean disableTabSelection;
    protected CatalogDescriptor lastSelection;

    public MarketplacePage(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog);
        this.configuration = configuration;
        this.setDescription(Messages.MarketplacePage_selectSolutionsToInstall);
        this.setTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.configuration.getCatalogDescriptor() != null) {
            this.setTitle(this.configuration.getCatalogDescriptor().getLabel());
        }
    }

    public void createControl(Composite originalParent) {
        Composite parent = originalParent;
        boolean needSwitchMarketplaceControl = this.configuration.getCatalogDescriptors().size() > 1;
        parent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 5).applyTo(parent);
        this.tabFolder = new TabFolder(parent, 128);
        if (originalParent != parent) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        }
        super.createControl((Composite)this.tabFolder);
        this.tabContent = this.getControl();
        this.createSearchTab();
        this.createRecentTab();
        this.createPopularTab();
        this.createInstalledTab();
        this.createNewsTab();
        this.tabFolder.setSelection(this.searchTabItem);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.setActiveTab((TabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectionLink = new Link(parent, 0);
        this.selectionLink.setToolTipText(Messages.MarketplacePage_showSelection);
        this.selectionLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketplacePage.this.selectionLinkActivated();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.selectionLink);
        this.computeSelectionLinkText();
        if (needSwitchMarketplaceControl) {
            this.createMarketplaceSwitcher(parent);
        }
        this.updateBranding();
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private int previousSelectionSize = 0;

            public void selectionChanged(SelectionChangedEvent event) {
                IWizardPage nextPage;
                IWizardPage currentPage;
                if (!MarketplacePage.this.isCurrentPage()) {
                    return;
                }
                SelectionModel selectionModel = MarketplacePage.this.getWizard().getSelectionModel();
                int newSelectionSize = selectionModel.getItemToSelectedOperation().size();
                if (!event.getSelection().isEmpty() && this.previousSelectionSize == 0 && newSelectionSize == 1 && selectionModel.computeProvisioningOperationViable() && (currentPage = MarketplacePage.this.getContainer().getCurrentPage()).isPageComplete() && (nextPage = MarketplacePage.this.getWizard().getNextPage((IWizardPage)MarketplacePage.this)) != null && nextPage instanceof WizardPage) {
                    ((WizardPage)nextPage).setPageComplete(true);
                    MarketplacePage.this.getContainer().showPage(nextPage);
                }
                this.previousSelectionSize = newSelectionSize;
            }
        });
        this.getViewer().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(MarketplaceViewer.CONTENT_TYPE_PROPERTY) && event.getNewValue() != null) {
                    MarketplacePage.this.setActiveTab((MarketplaceViewer.ContentType)((Object)event.getNewValue()));
                }
            }
        });
        this.setControl((Control)(parent == originalParent ? this.tabFolder : parent));
        MarketplaceClientUi.setDefaultHelp(this.tabContent);
    }

    private void setActiveTab(TabItem tab) {
        TabItem tabItem;
        if (this.disableTabSelection) {
            return;
        }
        if (tab == this.newsTabItem) {
            INews news = this.getNews();
            boolean wasUpdated = this.newsViewer.isUpdated(news);
            this.newsViewer.showNews(news);
            if (wasUpdated) {
                this.updateBranding();
                this.tabFolder.setSelection(this.newsTabItem);
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MarketplacePage.this.tabFolder.setSelection(MarketplacePage.this.newsTabItem);
                    }
                });
            }
            return;
        }
        MarketplaceViewer.ContentType currentContentType = this.getViewer().getContentType();
        if (currentContentType != null && (tabItem = this.getTabItem(currentContentType)) == tab) {
            this.setActiveTab(currentContentType);
            return;
        }
        MarketplaceViewer.ContentType[] contentTypeArray = MarketplaceViewer.ContentType.values();
        int n = contentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarketplaceViewer.ContentType contentType = contentTypeArray[n2];
            if (this.getTabItem(contentType) == tab) {
                this.setActiveTab(contentType);
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    private void setActiveTab(MarketplaceViewer.ContentType contentType) {
        if (this.disableTabSelection) {
            return;
        }
        TabItem tabItem = this.getTabItem(contentType);
        this.tabFolder.setSelection(tabItem);
        this.getViewer().setContentType(contentType);
    }

    private TabItem getTabItem(MarketplaceViewer.ContentType content) {
        switch (content) {
            case INSTALLED: {
                return this.installedTabItem;
            }
            case POPULAR: {
                return this.popularTabItem;
            }
            case RECENT: {
                return this.recentTabItem;
            }
            case SEARCH: {
                return this.searchTabItem;
            }
            case SELECTION: {
                return this.searchTabItem;
            }
        }
        throw new IllegalArgumentException();
    }

    private void createInstalledTab() {
        this.installedTabItem = new TabItem(this.tabFolder, 0);
        this.installedTabItem.setText(Messages.MarketplacePage_installed);
        this.installedTabItem.setControl(this.tabContent);
    }

    private void createPopularTab() {
        this.popularTabItem = new TabItem(this.tabFolder, 0);
        this.popularTabItem.setText(Messages.MarketplacePage_popular);
        this.popularTabItem.setControl(this.tabContent);
    }

    private void createRecentTab() {
        this.recentTabItem = new TabItem(this.tabFolder, 0);
        this.recentTabItem.setText(Messages.MarketplacePage_recent);
        this.recentTabItem.setControl(this.tabContent);
    }

    private void createSearchTab() {
        this.searchTabItem = new TabItem(this.tabFolder, 0);
        this.searchTabItem.setText(Messages.MarketplacePage_search);
        this.searchTabItem.setControl(this.tabContent);
    }

    private void createNewsTab() {
        this.newsTabItem = new TabItem(this.tabFolder, 1);
        this.newsTabItem.setText(Messages.MarketplacePage_DefaultNewsTitle);
        INews news = this.getNews();
        if (news == null) {
            this.newsTabItem.dispose();
            return;
        }
        if (news.getShortTitle() != null && news.getShortTitle().length() > 0) {
            String title;
            String tooltip = title = news.getShortTitle();
            if (title.length() > 40) {
                tooltip = title;
                title = String.valueOf(title.substring(0, 39)) + '\u2026';
            }
            this.newsTabItem.setText(title);
            this.newsTabItem.setToolTipText(tooltip);
        }
        if (this.newsViewer == null) {
            this.createNewsViewer((Composite)this.tabFolder);
        }
        this.newsTabItem.setControl(this.newsViewer.getControl());
        this.updateNewsStatus();
    }

    private void updateNewsStatus() {
        INews news = this.getNews();
        Image tabImage = null;
        if (news != null && this.newsViewer.isUpdated(news)) {
            tabImage = MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NEWS_ICON_UPDATE");
        }
        this.newsTabItem.setImage(tabImage);
        this.newsTabItem.getParent().layout();
    }

    private INews getNews() {
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        INews news = CatalogRegistry.getInstance().getCatalogNews(descriptor);
        return news;
    }

    private void createNewsViewer(Composite parent) {
        this.newsViewer = new NewsViewer(this.getWizard());
        this.newsViewer.createControl(parent);
    }

    private void createMarketplaceSwitcher(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        CatalogSwitcher switcher = new CatalogSwitcher(composite, 2048, this.configuration);
        switcher.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CatalogDescriptor descriptor = (CatalogDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
                MarketplacePage.this.showMarketplace(descriptor);
            }
        });
        CatalogDescriptor selectedDescriptor = this.configuration.getCatalogDescriptor();
        if (selectedDescriptor != null) {
            switcher.setSelection((ISelection)new StructuredSelection((Object)selectedDescriptor));
        }
        this.marketplaceSwitcher = switcher;
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).minSize(1, -1).hint(500, -1).applyTo((Control)composite);
    }

    private void computeSelectionLinkText() {
        if (this.selectionLink != null) {
            String originalText = this.selectionLink.getText();
            String text = " ";
            int count = this.getWizard().getSelectionModel().getItemToSelectedOperation().size();
            if (count == 1) {
                text = Messages.MarketplacePage_linkShowSelection_One;
            } else if (count > 0) {
                text = NLS.bind((String)Messages.MarketplacePage_linkShowSelection_Multiple, (Object)count);
            }
            if (!(text == originalText || text != null && text.equals(originalText))) {
                boolean exclude = text == null || text.trim().length() == 0;
                boolean originalExclude = ((GridData)this.selectionLink.getLayoutData()).exclude;
                this.selectionLink.setText(text);
                if (originalExclude != exclude) {
                    this.selectionLink.setVisible(!exclude);
                    ((GridData)this.selectionLink.getLayoutData()).exclude = exclude;
                    ((Composite)this.getControl()).layout(true, true);
                }
            }
        }
    }

    protected void selectionLinkActivated() {
        this.tabFolder.setSelection(this.searchTabItem);
        this.getViewer().showSelected();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        MarketplaceViewer viewer = new MarketplaceViewer(this.getCatalog(), (IShellProvider)this, this.getWizard());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        return viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!MarketplacePage.this.getControl().isDisposed() && MarketplacePage.this.isCurrentPage()) {
                        MarketplacePage.this.getWizard().updateNews();
                        MarketplacePage.this.getViewer().updateCatalog();
                        MarketplacePage.this.updateBranding();
                    }
                }
            });
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
            if (catalogDescriptor != null) {
                this.setTitle(catalogDescriptor.getLabel());
            }
            if (this.previousCatalogDescriptor == null || !this.previousCatalogDescriptor.equals(catalogDescriptor)) {
                this.previousCatalogDescriptor = catalogDescriptor;
                this.tabFolder.setSelection(this.searchTabItem);
                this.getViewer().setContentType(MarketplaceViewer.ContentType.SEARCH);
                this.getWizard().initializeCatalog();
                this.updated = false;
            }
        }
        super.setVisible(visible);
    }

    public void setPageComplete(boolean complete) {
        if (complete) {
            complete = this.getWizard().getSelectionModel().computeProvisioningOperationViable();
        }
        this.computeMessages();
        super.setPageComplete(complete);
    }

    private void computeMessages() {
        this.computeStatusMessage();
        this.computeSelectionLinkText();
    }

    private void computeStatusMessage() {
        IStatus viability;
        String message = null;
        int messageType = 0;
        if (this.getWizard() != null && (viability = this.getWizard().getSelectionModel().computeProvisioningOperationViability()) != null) {
            message = viability.getMessage();
            messageType = Util.computeMessageType(viability);
        }
        this.setMessage(message, messageType);
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    private void updateBranding() {
        boolean isSelected;
        boolean hasPopularTab;
        boolean hasRecentTab;
        ICatalogBranding branding;
        this.disableTabSelection = true;
        this.updateTitle();
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        ICatalogBranding iCatalogBranding = branding = descriptor == null ? null : descriptor.getCatalogBranding();
        if (branding == null) {
            branding = this.getDefaultBranding();
        }
        TabItem selectedTabItem = null;
        int selectionIndex = this.tabFolder.getSelectionIndex();
        if (selectionIndex != -1) {
            selectedTabItem = this.tabFolder.getItem(selectionIndex);
        }
        this.newsTabItem.dispose();
        this.searchTabItem.dispose();
        this.recentTabItem.dispose();
        this.popularTabItem.dispose();
        this.installedTabItem.dispose();
        boolean hasSearchTab = branding.hasSearchTab();
        if (hasSearchTab) {
            boolean isSelected2 = selectedTabItem == this.searchTabItem;
            this.createSearchTab();
            this.searchTabItem.setText(branding.getSearchTabName());
            if (isSelected2) {
                selectedTabItem = this.searchTabItem;
            }
        }
        if (hasRecentTab = branding.hasRecentTab()) {
            boolean isSelected3 = selectedTabItem == this.recentTabItem;
            this.createRecentTab();
            this.recentTabItem.setText(branding.getRecentTabName());
            if (isSelected3) {
                selectedTabItem = this.recentTabItem;
            }
        }
        if (hasPopularTab = branding.hasPopularTab()) {
            isSelected = selectedTabItem == this.popularTabItem;
            this.createPopularTab();
            this.popularTabItem.setText(branding.getPopularTabName());
            if (isSelected) {
                selectedTabItem = this.popularTabItem;
            }
        }
        isSelected = selectedTabItem == this.installedTabItem;
        this.createInstalledTab();
        if (isSelected) {
            selectedTabItem = this.installedTabItem;
        }
        isSelected = selectedTabItem == this.newsTabItem;
        this.createNewsTab();
        if (isSelected) {
            selectedTabItem = this.newsTabItem;
        }
        if (selectedTabItem == null || selectedTabItem.isDisposed()) {
            selectedTabItem = this.tabFolder.getItem(0);
        }
        this.tabFolder.setSelection(selectedTabItem);
        try {
            ImageDescriptor wizardIconDescriptor = branding.getWizardIcon() == null ? DiscoveryImages.BANNER_DISOVERY : ImageDescriptor.createFromURL((URL)new URL(branding.getWizardIcon()));
            this.setImageDescriptor(wizardIconDescriptor);
        }
        catch (MalformedURLException e) {
            MarketplaceClientUi.error(e);
        }
        this.disableTabSelection = false;
    }

    private ICatalogBranding getDefaultBranding() {
        CatalogBranding branding = new CatalogBranding();
        branding.setHasSearchTab(true);
        branding.setHasPopularTab(true);
        branding.setHasRecentTab(true);
        branding.setSearchTabName(Messages.MarketplacePage_search);
        branding.setPopularTabName(Messages.MarketplacePage_popular);
        branding.setRecentTabName(Messages.MarketplacePage_recent);
        branding.setWizardTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        return branding;
    }

    public IStatus showMarketplace(CatalogDescriptor catalogDescriptor) {
        if (this.configuration.getCatalogDescriptor() != catalogDescriptor) {
            if (this.getWizard().getSelectionModel().getSelectedCatalogItems().size() > 0) {
                boolean discardSelection = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MarketplacePage_selectionSolutions, (String)Messages.MarketplacePage_discardPendingSolutions);
                if (discardSelection) {
                    this.getWizard().getSelectionModel().clear();
                    this.computeSelectionLinkText();
                } else {
                    if (this.marketplaceSwitcher != null) {
                        this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)this.lastSelection));
                    }
                    return Status.CANCEL_STATUS;
                }
            }
            this.lastSelection = catalogDescriptor;
            this.configuration.setCatalogDescriptor(catalogDescriptor);
            if (this.marketplaceSwitcher != null) {
                this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)catalogDescriptor));
            }
            this.updateCatalog();
        }
        return Status.OK_STATUS;
    }

    private void updateCatalog() {
        this.getWizard().initializeCatalog();
        this.getWizard().updateNews();
        this.getViewer().updateCatalog();
        this.updateBranding();
    }

    public void showNews(CatalogDescriptor catalogDescriptor) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.newsTabItem);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, MarketplaceViewer.ContentType content) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(content);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, Set<? extends INode> nodes) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().show(nodes);
        }
    }

    public void search(CatalogDescriptor catalogDescriptor, IMarket searchMarket, ICategory searchCategory, String searchString) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().search(searchMarket, searchCategory, searchString);
        }
    }

    protected void initialize(MarketplaceWizard.WizardState initialState) {
        MarketplaceViewer.ContentType contentType = initialState.getContentType();
        if (contentType != null && contentType != MarketplaceViewer.ContentType.SEARCH) {
            this.show(this.configuration.getCatalogDescriptor(), contentType);
        } else if (initialState.getContent() != null && !initialState.getContent().isEmpty()) {
            this.show(this.configuration.getCatalogDescriptor(), initialState.getContent());
        } else {
            IMarket market = initialState.getFilterMarket();
            ICategory category = initialState.getFilterCategory();
            String query = initialState.getFilterQuery();
            if (market != null || category != null || query != null) {
                this.search(this.configuration.getCatalogDescriptor(), market, category, query);
            }
        }
    }

    public void dispose() {
        if (this.marketplaceSwitcher != null) {
            this.marketplaceSwitcher.dispose();
        }
        super.dispose();
    }
}

