/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.util;

import java.awt.AWTError;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class Util {
    private static boolean useAwt = true;

    public static Image scaleImage(Image image, int maxWidth, int maxHeight) {
        int newHeight;
        int newWidth;
        Rectangle bounds = image.getBounds();
        float widthRatio = (float)bounds.width / (float)maxWidth;
        float heightRatio = (float)bounds.height / (float)maxHeight;
        if (widthRatio > heightRatio) {
            newWidth = maxWidth;
            newHeight = -1;
        } else {
            newWidth = -1;
            newHeight = maxHeight;
        }
        if (useAwt) {
            try {
                BufferedImage img = Util.convertToAWT(image.getImageData());
                AreaAveragingScaleFilter filter = new AreaAveragingScaleFilter(newWidth, newHeight);
                FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
                PixelGrabber pixelGrabber = new PixelGrabber(prod, 0, 0, newWidth, newHeight, null, 0, newWidth){

                    public void setDimensions(int width, int height) {
                        super.setDimensions(width, height);
                    }
                };
                if (pixelGrabber.grabPixels()) {
                    Image scaledImage = new Image(image.getDevice(), Util.convertToSWT(pixelGrabber));
                    return scaledImage;
                }
            }
            catch (Exception exception) {
                useAwt = false;
            }
            catch (AWTError aWTError) {
                useAwt = false;
            }
        }
        if (newHeight == -1) {
            newHeight = Math.min(maxHeight, (int)((float)bounds.height / widthRatio));
        } else {
            newWidth = Math.min(maxWidth, (int)((float)bounds.width / heightRatio));
        }
        Image scaledImage = new Image(image.getDevice(), newWidth, newHeight);
        GC gc = new GC((Drawable)scaledImage);
        try {
            gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, newWidth, newHeight);
        }
        finally {
            gc.dispose();
        }
        return scaledImage;
    }

    private static BufferedImage convertToAWT(ImageData data) {
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 2);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, data.getAlpha(x, y) << 24 | rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        IndexColorModel colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private static ImageData convertToSWT(PixelGrabber pixels) {
        byte[] byteData;
        int[] intData;
        Object data = pixels.getPixels();
        assert (data != null);
        if (data instanceof int[]) {
            intData = (int[])data;
            byteData = null;
        } else {
            byteData = (byte[])data;
            intData = null;
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (pixels.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)pixels.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            boolean hasAlpha = colorModel.hasAlpha();
            ImageData imageData = new ImageData(width, height, colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < imageData.height) {
                int x = 0;
                while (x < imageData.width) {
                    int rgb = intData != null ? intData[width * y + x] : colorModel.getRGB(byteData[width * y + x] & 0xFF);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    imageData.setPixel(x, y, pixel);
                    if (hasAlpha) {
                        imageData.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return imageData;
        }
        if (pixels.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)pixels.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data2 = new ImageData(width, height, colorModel.getPixelSize(), palette);
            data2.transparentPixel = colorModel.getTransparentPixel();
            int y = 0;
            while (y < data2.height) {
                int x = 0;
                while (x < data2.width) {
                    int pixel = intData != null ? intData[y * width + x] : byteData[y * width + x] & 0xFF;
                    data2.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data2;
        }
        return null;
    }

    public static int computeMessageType(IStatus status) {
        int messageType;
        switch (status.getSeverity()) {
            case 0: 
            case 1: {
                messageType = 1;
                break;
            }
            case 2: {
                messageType = 2;
                break;
            }
            default: {
                messageType = 3;
            }
        }
        return messageType;
    }
}

