/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.mpc.core.model.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceInfo {
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    private static final String PERSISTENT_FILE = String.valueOf(MarketplaceInfo.class.getSimpleName()) + ".xml";
    private Map<String, List<String>> nodeKeyToIU = new HashMap<String, List<String>>();
    private Map<String, List<String>> iuToNodeKey = new HashMap<String, List<String>>();

    public Map<String, List<String>> getNodeKeyToIU() {
        return this.nodeKeyToIU;
    }

    public void setNodeKeyToIU(Map<String, List<String>> nodeKeyToIU) {
        this.nodeKeyToIU = nodeKeyToIU;
    }

    public Map<String, List<String>> getIuToNodeKey() {
        return this.iuToNodeKey;
    }

    public void setIuToNodeKey(Map<String, List<String>> iuToNodeKey) {
        this.iuToNodeKey = iuToNodeKey;
    }

    public synchronized Set<INode> computeInstalledNodes(URL repositoryUrl, Set<String> installedIus) {
        HashSet<INode> nodes = new HashSet<INode>();
        String keyPrefix = String.valueOf(this.computeUrlKey(repositoryUrl)) + '#';
        for (Map.Entry<String, List<String>> entry : this.nodeKeyToIU.entrySet()) {
            List<String> ius;
            if (!entry.getKey().startsWith(keyPrefix) || !this.computeInstalled(installedIus, ius = this.nodeKeyToIU.get(entry.getKey()))) continue;
            String nodeId = entry.getKey().substring(keyPrefix.length());
            Node node = new Node();
            node.setId(nodeId);
            nodes.add((INode)node);
        }
        return nodes;
    }

    @Deprecated
    public boolean computeInstalled(Set<String> installedFeatures, Set<URI> knownRepositories, INode node) {
        String updateurl = node.getUpdateurl();
        if (updateurl == null) {
            return false;
        }
        boolean installed = this.computeInstalled(installedFeatures, node);
        if (installed && knownRepositories != null) {
            try {
                URI uri = new URL(node.getUpdateurl()).toURI();
                if (!knownRepositories.contains(uri)) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return installed;
    }

    public boolean computeInstalled(Set<String> installedFeatures, INode node) {
        if (node.getIus() != null && !node.getIus().getIu().isEmpty()) {
            ArrayList<String> ius = new ArrayList<String>(new HashSet(node.getIus().getIu()));
            return this.computeInstalled(installedFeatures, ius);
        }
        return false;
    }

    private boolean computeInstalled(Set<String> installedIus, List<String> ius) {
        int installCount = 0;
        for (String iu : ius) {
            if (!installedIus.contains(iu) && !installedIus.contains(String.valueOf(iu) + P2_FEATURE_GROUP_SUFFIX)) continue;
            ++installCount;
        }
        return installCount > 0;
    }

    public synchronized void map(URL marketUrl, INode node) {
        block4: {
            String itemKey;
            block3: {
                itemKey = this.computeItemKey(marketUrl, node);
                if (node.getIus() == null || node.getIus().getIu().isEmpty()) break block3;
                ArrayList ius = new ArrayList(new HashSet(node.getIus().getIu()));
                this.nodeKeyToIU.put(itemKey, ius);
                for (String iu : ius) {
                    List<String> catalogNodes = this.iuToNodeKey.get(iu);
                    if (catalogNodes != null) {
                        if (catalogNodes.contains(itemKey)) continue;
                        catalogNodes.add(itemKey);
                        continue;
                    }
                    catalogNodes = new ArrayList<String>(1);
                    catalogNodes.add(itemKey);
                    this.iuToNodeKey.put(iu, catalogNodes);
                }
                break block4;
            }
            List<String> ius = this.nodeKeyToIU.remove(itemKey);
            if (ius == null) break block4;
            for (String iu : ius) {
                List<String> catalogNodes = this.iuToNodeKey.get(iu);
                if (catalogNodes == null) continue;
                catalogNodes.remove(itemKey);
                if (!catalogNodes.isEmpty()) continue;
                this.iuToNodeKey.remove(iu);
            }
        }
    }

    private String computeItemKey(URL marketUrl, INode item) {
        return String.valueOf(this.computeUrlKey(marketUrl)) + '#' + item.getId();
    }

    private String computeUrlKey(URL url) {
        try {
            return url.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MarketplaceInfo getInstance() {
        File registryFile = MarketplaceInfo.computeRegistryFile();
        if (registryFile == null) return new MarketplaceInfo();
        if (!registryFile.exists()) return new MarketplaceInfo();
        Class<MarketplaceInfo> clazz = MarketplaceInfo.class;
        synchronized (MarketplaceInfo.class) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(registryFile));
                try {
                    XMLDecoder decoder = new XMLDecoder(in);
                    Object object = decoder.readObject();
                    decoder.close();
                    if (!(object instanceof MarketplaceInfo)) return new MarketplaceInfo();
                    MarketplaceInfo marketplaceInfo = (MarketplaceInfo)object;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return marketplaceInfo;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (Throwable t) {
                MarketplaceClientUi.error(t);
            }
            return new MarketplaceInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() {
        File registryFile = MarketplaceInfo.computeRegistryFile();
        if (registryFile == null) return;
        Class<MarketplaceInfo> clazz = MarketplaceInfo.class;
        synchronized (MarketplaceInfo.class) {
            try {
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(registryFile));
                try {
                    XMLEncoder encoder = new XMLEncoder(outputStream);
                    encoder.writeObject(this);
                    encoder.close();
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (Throwable throwable) {}
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static final File computeRegistryFile() {
        File dataFile = Platform.getBundle((String)"org.eclipse.epp.mpc.ui").getBundleContext().getDataFile(PERSISTENT_FILE);
        if (dataFile != null) {
            return dataFile;
        }
        String userHome = System.getProperty("user.home");
        File userHomeFile = new File(userHome);
        if (userHomeFile.exists()) {
            File mpcConfigLocation = new File(userHomeFile, ".eclipse_mpc");
            if (!mpcConfigLocation.exists() && !mpcConfigLocation.mkdir()) {
                return null;
            }
            return MarketplaceInfo.computeConfigFile(mpcConfigLocation);
        }
        return null;
    }

    private static File computeConfigFile(File mpcConfigLocation) {
        return new File(mpcConfigLocation, PERSISTENT_FILE);
    }
}

