/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.annotation;

import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.ASTAnnotationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.IAnnotationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.JDTAnnotationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public abstract class JWSAnnotation {
    protected IAnnotationContext jwsAnnotation;
    protected JWSValidationContext context;

    public JWSAnnotation(String annotation, BodyDeclaration declaration, JWSValidationContext context) {
        this.jwsAnnotation = new ASTAnnotationContext(annotation, declaration, context);
        this.context = context;
    }

    public JWSAnnotation(String annotation, SingleVariableDeclaration declaration, JWSValidationContext context) {
        this.jwsAnnotation = new ASTAnnotationContext(annotation, declaration, context);
        this.context = context;
    }

    public JWSAnnotation(String annotation, IType primaryType, IAnnotatable anno, JWSValidationContext context) {
        this.jwsAnnotation = new JDTAnnotationContext(annotation, primaryType, anno, context);
        this.context = context;
    }

    public boolean exists() {
        return this.jwsAnnotation.exists();
    }

    public ASTNode getASTNode() {
        return this.jwsAnnotation.getASTNode();
    }

    public boolean isMatchingAttribute(String value, String fullyQualifiedReference) throws JavaModelException {
        String binding2;
        int dot2;
        if (fullyQualifiedReference.equals(value)) {
            return true;
        }
        int dot = fullyQualifiedReference.lastIndexOf(46);
        String binding = fullyQualifiedReference.substring(dot);
        if (value != null && (dot2 = value.lastIndexOf(46)) > -1 && binding.equals(binding2 = value.substring(dot2))) {
            String fullyQualified = ClassUtil.resolveType((String)value.substring(0, dot2), (ICompilationUnit)this.context.getIcompilationUnit());
            return ClassUtil.isAssignableFrom((String)fullyQualified, (String)fullyQualifiedReference.substring(0, dot), (IProject)this.context.getProject());
        }
        return false;
    }

    public <T extends Enum<T>> T getAnnotationEnumValue(String name, Class<T> enumType, T defaultEnum) {
        String val = this.jwsAnnotation.getMemberValue(name);
        if (!StringUtil.isEmpty((String)val)) {
            if (StringUtil.isEmpty((String)(val = StringUtil.stripPackage((String)val)))) {
                return defaultEnum;
            }
            return Enum.valueOf(enumType, val);
        }
        return defaultEnum;
    }
}

