/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws.annotation;

import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.validation.jws.JWSValidationContext;
import oracle.eclipse.tools.webservices.validation.jws.annotation.IAnnotationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;

public final class JDTAnnotationContext
implements IAnnotationContext {
    private IType primaryType;
    private IAnnotation annotation = null;
    private JWSValidationContext context;

    public JDTAnnotationContext(String anno, IType primaryType, IAnnotatable annotatable, JWSValidationContext context) {
        this.primaryType = primaryType;
        this.context = context;
        this.annotation = JDTAnnotationContext.getIAnnotation(anno, annotatable);
    }

    @Override
    public boolean exists() {
        return this.annotation != null;
    }

    private String getMemberValue(IAnnotation anno, String name, boolean resolveBinding) throws JavaModelException {
        if (anno != null) {
            IMemberValuePair[] memberValuePairs;
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = anno.getMemberValuePairs();
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberValuePair.getMemberName().equals(name)) {
                    int kind = memberValuePair.getValueKind();
                    if (kind == 12 && resolveBinding) {
                        String fullyQualifiedType;
                        IType type;
                        IField[] fields;
                        String enumValue = memberValuePair.getValue().toString();
                        String baseType = memberValuePair.getValue().toString();
                        int i = enumValue.lastIndexOf(46);
                        if (i > 0) {
                            enumValue = enumValue.substring(i + 1);
                            baseType = baseType.substring(0, i);
                        }
                        if ((fields = (type = ClassUtil.getType((String)(fullyQualifiedType = ClassUtil.resolveType((String)baseType, (IType)this.primaryType)), (IProject)this.context.getProject())).getFields()).length > 0) {
                            IField[] iFieldArray = fields;
                            int n3 = fields.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object value;
                                IField field = iFieldArray[n4];
                                if (field.getElementName().equals(enumValue) && (value = field.getConstant()) instanceof String) {
                                    return this.unquote((String)value);
                                }
                                ++n4;
                            }
                        }
                    }
                    return memberValuePair.getValue().toString();
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getMemberValue(String name) {
        try {
            return this.getMemberValue(this.annotation, name, false);
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            return null;
        }
    }

    @Override
    public String getBindingMemberValue(String name) {
        try {
            return this.getMemberValue(this.annotation, name, true);
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
            return null;
        }
    }

    public static IAnnotation getIAnnotation(String annotationType, IAnnotatable primaryType) {
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = primaryType.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals(annotationType)) {
                    return annotation;
                }
                ++n2;
            }
            int dot = annotationType.lastIndexOf(46);
            if (dot > -1) {
                String dotAnnotation = annotationType.substring(dot + 1);
                IAnnotation[] iAnnotationArray2 = annotations;
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation annotation = iAnnotationArray2[n4];
                    String name = annotation.getElementName();
                    if (name.equals(dotAnnotation)) {
                        return annotation;
                    }
                    ++n4;
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.webservices", (CoreException)((Object)e));
        }
        return null;
    }

    @Override
    public ASTNode getASTNode() {
        return null;
    }

    private String unquote(String quoted) {
        if (quoted != null && quoted.length() >= 2) {
            char lastChar;
            int len = quoted.length();
            char firstChar = quoted.charAt(0);
            if (firstChar == (lastChar = quoted.charAt(len - 1)) && (firstChar == '\'' || firstChar == '\"')) {
                return quoted.substring(1, len - 1);
            }
        }
        return quoted;
    }
}

