/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public final class JWSValidationContext {
    private IResource jwsResource;
    private CompilationUnit compilationUnit;
    private ICompilationUnit icompilationUnit;
    private WebServiceProject wsProject;

    public JWSValidationContext(IResource jwsResource) {
        this.jwsResource = jwsResource;
        this.initialize();
    }

    public JWSValidationContext(ICompilationUnit icompilationUnit, CompilationUnit compilationUnit) {
        this.icompilationUnit = icompilationUnit;
        this.compilationUnit = compilationUnit;
        this.jwsResource = icompilationUnit.getResource();
        this.wsProject = new WebServiceProject(this.jwsResource.getProject());
    }

    private void initialize() {
        IJavaElement javaElement = JavaCore.create((IResource)this.jwsResource);
        if (javaElement instanceof ICompilationUnit) {
            this.icompilationUnit = (ICompilationUnit)javaElement;
            this.compilationUnit = this.getASTRoot(this.icompilationUnit);
        }
        this.wsProject = new WebServiceProject(this.jwsResource.getProject());
    }

    public IResource getJwsResource() {
        return this.jwsResource;
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public ICompilationUnit getIcompilationUnit() {
        return this.icompilationUnit;
    }

    public int getLinePosition(ASTNode node) {
        if (node != null) {
            int pos = node.getStartPosition();
            return this.compilationUnit.getLineNumber(pos);
        }
        return 0;
    }

    public int getLinePosition(ISourceRange sourceRange) {
        return this.compilationUnit.getLineNumber(sourceRange.getOffset());
    }

    public int getStartPosition(ASTNode node) {
        return this.compilationUnit.getExtendedStartPosition(node);
    }

    public int getLength(ASTNode node) {
        return this.compilationUnit.getExtendedLength(node);
    }

    public TypeDeclaration getPrimaryType() {
        return ReaderUtil.getPrimaryType((CompilationUnit)this.getCompilationUnit());
    }

    public IMethod[] getTypeMethods() throws JavaModelException {
        IType type = this.icompilationUnit.getType(this.getPrimaryType().getName().getFullyQualifiedName());
        return type.getMethods();
    }

    public IProject getProject() {
        return this.jwsResource.getProject();
    }

    public WebServiceProject getWebServiceProject() {
        return this.wsProject;
    }

    public String getFullyQualifiedTypeName() {
        try {
            return ClassUtil.resolveType((String)this.getPrimaryType().getName().getFullyQualifiedName(), (ICompilationUnit)this.getIcompilationUnit());
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)((Object)e));
            return null;
        }
    }

    private CompilationUnit getASTRoot(ICompilationUnit cu) {
        return ReaderUtil.parse((ICompilationUnit)cu, (boolean)true);
    }
}

