/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation.jws;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;

public class ASTVisitorFactory {

    public static class MethodVisitor
    extends ASTVisitor {
        private IMethod method;
        private MethodDeclaration matchNode;

        public MethodVisitor(IMethod method) {
            this.method = method;
        }

        public MethodDeclaration getMatchNode() {
            return this.matchNode;
        }

        public boolean visit(MethodDeclaration node) {
            ISourceRange sourceRange = null;
            try {
                sourceRange = this.method.getSourceRange();
                int endPos = sourceRange.getOffset() + sourceRange.getLength();
                if (sourceRange.getOffset() <= node.getStartPosition() && endPos > node.getStartPosition()) {
                    this.matchNode = node;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)((Object)e));
            }
            return super.visit(node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement node) {
            return false;
        }
    }
}

