/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.validation;

import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class WebServicesValidationBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "oracle.eclipse.tools.webservices.WebServicesValidationBuilder";
    private static final String VALIDATION_PROBLEM_MARKER = "oracle.eclipse.tools.webservices.WSValidatorProblem";
    private static final String EAR_FACET_VALIDATION_PROBLEM_MARKER = "oracle.eclipse.tools.webservices.WSEarFacetValidatorProblem";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return null;
        }
        currentProject.deleteMarkers(VALIDATION_PROBLEM_MARKER, true, 2);
        if (!WebServiceProject.isWebServiceProject(currentProject)) {
            return null;
        }
        IWeblogicServerRuntime wsr = this.getServerRuntime(currentProject);
        WSRuntime runtime = (WSRuntime)((Object)currentProject.getAdapter(WSRuntime.class));
        if (wsr == null && runtime == null) {
            IMarker marker = currentProject.createMarker(VALIDATION_PROBLEM_MARKER);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)Messages.no_runtime_specified);
        }
        Set earProjects = WtpProjectUtil.findReferencingEarProjects((IProject)currentProject);
        for (IProject earProject : earProjects) {
            IMarker marker;
            earProject.deleteMarkers(VALIDATION_PROBLEM_MARKER, true, 2);
            earProject.deleteMarkers(EAR_FACET_VALIDATION_PROBLEM_MARKER, true, 2);
            wsr = this.getServerRuntime(earProject);
            runtime = (WSRuntime)((Object)earProject.getAdapter(WSRuntime.class));
            if (wsr == null && runtime == null) {
                marker = earProject.createMarker(VALIDATION_PROBLEM_MARKER);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)Messages.no_runtime_specified);
            }
            if (WlsEarFacet.isInstalled((IProject)earProject)) continue;
            marker = earProject.createMarker(EAR_FACET_VALIDATION_PROBLEM_MARKER);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)Messages.bind((String)Messages.publish_task_error_missing_facet, (Object)earProject.getName(), (Object)WlsEarFacet.FACET.getLabel()));
        }
        return null;
    }

    private IWeblogicServerRuntime getServerRuntime(IProject project) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime;
        IFacetedProject fproj;
        block5: {
            fproj = ProjectFacetsManager.create((IProject)project);
            primaryRuntime = fproj.getPrimaryRuntime();
            if (primaryRuntime != null) break block5;
            return null;
        }
        try {
            IWeblogicServerRuntime wsr;
            IRuntime wstRuntime = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
            if (wstRuntime != null && (wsr = (IWeblogicServerRuntime)wstRuntime.getAdapter(IWeblogicServerRuntime.class)) != null) {
                return wsr;
            }
            Set runtimes = fproj.getTargetedRuntimes();
            for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt : runtimes) {
                IWeblogicServerRuntime wsr2;
                wstRuntime = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
                if (wstRuntime == null || (wsr2 = (IWeblogicServerRuntime)wstRuntime.getAdapter(IWeblogicServerRuntime.class)) == null) continue;
                return wsr2;
            }
        }
        catch (CoreException coreException) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)coreException, (String)("unable to determine runtime from project " + project));
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return;
        }
        currentProject.deleteMarkers(VALIDATION_PROBLEM_MARKER, true, 2);
    }
}

