/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClassPathBuilder {
    private ClassPathBuilder() {
    }

    public static Collection<String> buildClassPath(IJavaProject jp) throws JavaModelException {
        return ClassPathBuilder.buildClassPathImpl(jp, new HashSet<IClasspathEntry>());
    }

    private static Collection<String> buildClassPathImpl(IJavaProject jp, Set<IClasspathEntry> circularCheck) throws JavaModelException {
        IClasspathEntry[] entries;
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        IProject proj = jp.getProject();
        IClasspathEntry[] iClasspathEntryArray = entries = jp.getResolvedClasspath(true);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 2) {
                if (!circularCheck.contains(entry)) {
                    circularCheck.add(entry);
                    classpaths.addAll(ClassPathBuilder.buildClassPathImpl(ClassPathBuilder.getJavaProjectForEntry(entry), circularCheck));
                }
            } else {
                IPath path = ClassPathBuilder.qualifyPath(entry, jp, proj);
                if (path != null) {
                    classpaths.add(path.toString());
                }
            }
            ++n2;
        }
        return classpaths;
    }

    private static IJavaProject getJavaProjectForEntry(IClasspathEntry entry) {
        String projectName = entry.getPath().lastSegment();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject;
    }

    private static IPath qualifyPath(IClasspathEntry entry, IJavaProject javaProject, IProject project) throws JavaModelException {
        int kind = entry.getEntryKind();
        if (kind == 3 || kind == 2) {
            IPath path = entry.getOutputLocation();
            if (path == null) {
                path = javaProject.getOutputLocation();
            }
            IPath projPath = project.getLocation();
            projPath = projPath.removeLastSegments(1);
            IPath qualifiedPath = projPath.append(path);
            return qualifiedPath;
        }
        IPath entryPath = entry.getPath();
        IResource entryResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
        if (entryResource != null) {
            return entryResource.getLocation();
        }
        return entryPath;
    }
}

