/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.publish;

import java.io.InputStream;
import java.util.Map;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.StringInputStream;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.Messages;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class WebServicesPublishCleaner
extends IncrementalProjectBuilder {
    public static final String ID = "oracle.eclipse.tools.webservices.WebServicesPublishCleaner";
    private static final String CLEAN_PROBLEM_MARKER = "oracle.eclipse.tools.webservices.WSCleanProblem";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return null;
        }
        try {
            WebServiceProject webServiceProject = new WebServiceProject(currentProject);
            IPath outputLoc = webServiceProject.getJavaProject().getOutputLocation();
            IPath path = outputLoc.append("oepe-jws");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (!file.exists()) {
                StringInputStream is = new StringInputStream("" + System.currentTimeMillis());
                file.create((InputStream)is, true, monitor);
            }
            file.touch(monitor);
        }
        catch (Exception exception) {}
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return;
        }
        currentProject.deleteMarkers(CLEAN_PROBLEM_MARKER, true, 2);
        try {
            WebServiceProject webServiceProject = new WebServiceProject(currentProject);
            webServiceProject.cleanOutputFolder(monitor);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)e);
            this.createMarker((IResource)currentProject, Messages.bind((String)Messages.clean_failed, (Object)e.getLocalizedMessage()), 2);
            DialogService.showErrorDialog((String)Messages.bind((String)Messages.clean_failed, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void createMarker(IResource resource, String msg, int severity) {
        if (resource == null) {
            return;
        }
        try {
            IMarker marker = resource.createMarker(CLEAN_PROBLEM_MARKER);
            marker.setAttribute("severity", severity);
            marker.setAttribute("message", (Object)msg);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (CoreException)e);
        }
    }
}

