/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.wsdl.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.webservices.model.jws.internal.JAXBTypeMapper;
import oracle.eclipse.tools.webservices.model.wsdl.ISchema;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaComplexType;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaElement;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaSimpleType;
import oracle.eclipse.tools.webservices.model.wsdl.ISchemaType;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;

public final class SchemaElementTypeMapper
extends JAXBTypeMapper {
    public String read() {
        assert (this.property().element() instanceof ISchemaElement);
        assert (this.property().definition() == ISchemaElement.PROP_JAVA_TYPE);
        ISchemaElement element = (ISchemaElement)this.property().element();
        ISchema schema = (ISchema)element.nearest(ISchema.class);
        String ref = element.getRefName().text();
        if (ref != null) {
            IWsdlModel wsdlModel = schema.getWsdlModel();
            element = wsdlModel.findElement(ref);
        }
        if (element != null) {
            String type = element.getTypeName().text();
            if (type != null) {
                String prefix = element.getTypeNamespacePrefix().text();
                boolean lookUpType = false;
                if (prefix != null) {
                    String namespace = this.getNamespaceURI(schema, prefix);
                    String targetNamespace = this.getNamespaceURI(schema, null);
                    lookUpType = ObjectUtil.equals((Object)namespace, (Object)targetNamespace);
                } else {
                    lookUpType = true;
                }
                if (lookUpType) {
                    ISchemaType schemaType = schema.getWsdlModel().findType(type);
                    return schemaType == null ? "Unknown Type: " + type : schemaType.getJavaType().text();
                }
                return this.mapNameAndNamespaceToType(type, prefix, schema);
            }
            ISchemaComplexType complex = (ISchemaComplexType)element.getComplexType().content();
            if (complex != null) {
                return complex.getJavaType().text();
            }
            ISchemaSimpleType simple = (ISchemaSimpleType)element.getSimpleType().content();
            if (simple != null) {
                return simple.getJavaType().text();
            }
        }
        return "" + schema.getTargetNamespace() != null && schema.getTargetNamespace().text() != null ? schema.getTargetNamespace().text() : (":" + element.getElementName() != null && element.getElementName().text() != null ? element.getElementName().text() : "");
    }
}

