/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.model.jws.internal;

import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSModelGroupResource;
import oracle.eclipse.tools.webservices.model.wsdl.IWsdlModel;
import oracle.eclipse.tools.webservices.util.NameConverter;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public final class PackageNameDefaultProvider
extends DefaultValueService {
    private Listener listener;

    protected void initDefaultValueService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PackageNameDefaultProvider.this.refresh();
            }
        };
        JWSJavaPackage model = (JWSJavaPackage)this.context(JWSJavaPackage.class);
        model.attach(this.listener, "/BindingsSet/Definitions/PackageName");
    }

    public void dispose() {
        if (this.listener != null) {
            JWSJavaPackage model = (JWSJavaPackage)this.context(JWSJavaPackage.class);
            model.detach(this.listener, "/BindingsSet/Definitions/PackageName");
            this.listener = null;
        }
        super.dispose();
    }

    public String getTargetNameSpace(Element element) {
        JWSModelGroup jwsModelGroup = (JWSModelGroup)element.nearest(JWSModelGroup.class);
        if (jwsModelGroup != null) {
            IWsdlModel wsdlModel = ((JWSModelGroupResource)jwsModelGroup.resource()).getWsdlModel();
            return wsdlModel == null ? null : wsdlModel.getTargetNamespace().text();
        }
        return null;
    }

    protected DefaultValueServiceData compute() {
        Element modelElement = (Element)this.context(Element.class);
        String targetNameSpace = this.getTargetNameSpace(modelElement);
        return new DefaultValueServiceData(targetNameSpace != null ? NameConverter.toPackageName(targetNameSpace) : null);
    }
}

